/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Entities;

import java.util.function.Supplier;
import net.eldercodes.thercmod.Audio.MovingSoundBoatHigh;
import net.eldercodes.thercmod.Audio.MovingSoundWater;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.GlobalItem;
import net.eldercodes.thercmod.KeyHandler;
import net.eldercodes.thercmod.Packets.MessageEntityBoat;
import net.eldercodes.thercmod.Packets.MessageHandler;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityBoat
extends GlobalEntity {
    public float[] state = new float[2];
    public float[] prevState = new float[2];
    private float[] netState = new float[2];
    private float inputAngle;

    public EntityBoat(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
        this.field_70145_X = true;
    }

    public EntityBoat(EntityType<?> entityType, World world, double par2, double par4, double par6) {
        this(entityType, world);
        this.func_70107_b(par2, par4, par6);
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    public EntityBoat(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(RCM_Main.boatType, world);
    }

    @Override
    public int getID() {
        return 7;
    }

    public boolean func_70112_a(double par1) {
        double d = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d *= 64.0) * d;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.defaultControls = new String[]{"** Default Controls **", "[W]/[S] - Move forward/backward", "[A]/[D] - Turn left/right", "", "[R] - Retreive boat", "", "[F3] - Show forces", "[F5] - Change camera view", "", "** Camera Default Controls **", "[Num 4]/[Num 6] - Move left/right", "[Num 8]/[Num 2] - Move up/down", "[Num 5] - Reset position"};
    }

    @Override
    public void calculatePhysics() {
        this.prevState = (float[])this.state.clone();
        if (this.activated && this.holdingremotecontrol(this.thePlayer)) {
            this.inputAngle = KeyHandler.turnMovement;
        }
        this.power = this.activated && this.holdingremotecontrol(this.thePlayer) && !this.damaged ? (KeyHandler.powerMovement >= 0.0f ? KeyHandler.powerMovement * 100.0f : KeyHandler.powerMovement * 25.0f) : 0.0f;
        this.state[0] = this.physicsWorld.motors.get(0).getOutputSpeed();
        this.state[1] = this.physicsWorld.wings.get(3).getPropAngle();
        this.physicsWorld.setControlChannel(11, this.power / 100.0f);
        this.physicsWorld.setControlChannel(12, this.power / 100.0f);
        this.physicsWorld.setControlChannel(5, -this.inputAngle);
        this.sendAdditionalPacket();
    }

    @Override
    public void sendAdditionalPacket() {
        if (!this.field_70170_p.field_72995_K) {
            MessageHandler.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with((Supplier)this), (Object)new MessageEntityBoat(this.func_145782_y(), this.state));
        } else if (this.field_70170_p.field_72995_K) {
            MessageHandler.HANDLER.sendToServer((Object)new MessageEntityBoat(this.func_145782_y(), this.state));
        }
    }

    public void additionalInfoUpdate(float[] newState) {
        this.netState = newState;
    }

    @Override
    public void updateAdditionalInfo() {
        this.prevState = (float[])this.state.clone();
        this.state = (float[])this.netState.clone();
    }

    @Override
    public void spawnItems() {
        if (!this.damaged) {
            ItemStack gStack = new ItemStack((IItemProvider)RCM_Main.item_boat);
            this.dropCustomItem(gStack, (GlobalItem)gStack.func_77973_b());
        } else {
            this.dropCraftItem((IItemProvider)RCM_Main.item_receivermodule, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_boat_body, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_servo, 0.8);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSounds() {
        super.registerSounds();
        RCM_Main.PROXY.getSoundHandler().func_147682_a((ISound)new MovingSoundBoatHigh(this));
        RCM_Main.PROXY.getSoundHandler().func_147682_a((ISound)new MovingSoundWater(this));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        super.spawnParticles();
        if (this.power > 25.0f && !this.damaged) {
            boolean a = false;
            BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u - 0.5 - (double)a, this.field_70161_v);
            BlockState blockstate = this.field_70170_p.func_180495_p(blockPos);
            for (int i1 = 0; i1 < 20; ++i1) {
                double d1 = -0.6;
                double d2 = (double)this.field_70146_Z.nextFloat() * -0.5 + 0.25;
                if (!this.field_70146_Z.nextBoolean()) continue;
                double d3 = this.field_70165_t + d1 * (double)this.Forward.x + d2 * (double)this.Left.x * 0.5;
                double d4 = this.field_70161_v + d1 * (double)this.Forward.z + d2 * (double)this.Left.z * 0.5;
                double d5 = d1 * (double)this.Forward.x + d2 * (double)this.Left.x;
                double d6 = d1 * (double)this.Forward.z + d2 * (double)this.Left.z;
                if (blockstate.func_185904_a() != Material.field_151586_h) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, d3, (double)(blockPos.func_177956_o() + 1), d4, d5, (double)(20.0f * this.power), d6);
            }
        }
    }

    @Override
    public String getEntityName() {
        return "RC Boat";
    }
}

