/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Entities;

import java.util.function.Supplier;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Audio.MovingSoundStuntPlaneHigh;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.GlobalItem;
import net.eldercodes.thercmod.KeyHandler;
import net.eldercodes.thercmod.Packets.MessageEntityStuntPlane;
import net.eldercodes.thercmod.Packets.MessageHandler;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityStuntPlane
extends GlobalEntity {
    public float[] state = new float[12];
    public float[] prevState = new float[12];
    public float[] netState = new float[12];
    private boolean smoke;
    private int smokeTimer;

    public EntityStuntPlane(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
        this.field_70145_X = true;
    }

    public EntityStuntPlane(EntityType<?> entityType, World world, double par2, double par4, double par6) {
        this(entityType, world);
        this.func_70107_b(par2, par4, par6);
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    public EntityStuntPlane(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(RCM_Main.stuntplaneType, world);
    }

    @Override
    public int getID() {
        return 9;
    }

    public boolean func_70112_a(double par1) {
        double d = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d *= 64.0) * d;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.defaultControls = new String[]{"** Default Controls **", "[W]/[S] - Increase/decrease speed", "[A]/[D] - Yaw left/right", "[Up Key]/[Down Key] - Nose down/up", "[Left Key]/[Right Key] - Roll left/right", "", "[K] - Toggle smoke", "[R] - Retreive stunt plane", "", "[F3] - Show forces", "[F5] - Change camera view", "", "** Camera Default Controls **", "[Num 4]/[Num 6] - Move left/right", "[Num 8]/[Num 2] - Move up/down", "[Num 5] - Reset position"};
    }

    @Override
    public void calculatePhysics() {
        this.prevState = (float[])this.state.clone();
        if (KeyHandler.motorKill && this.smokeTimer == 0) {
            this.smoke = !this.smoke;
            this.smokeTimer = 5;
        }
        if (this.smokeTimer > 0) {
            --this.smokeTimer;
        }
        if (this.activated && this.holdingremotecontrol(this.thePlayer)) {
            this.state[3] = -KeyHandler.yawMovement;
            this.state[4] = -KeyHandler.pitchMovement;
            this.state[2] = KeyHandler.rollMovement;
        }
        this.power = this.activated && this.holdingremotecontrol(this.thePlayer) && !this.damaged ? KeyHandler.absPowerMovement * 100.0f : 0.0f;
        this.state[0] = this.physicsWorld.rotaryWings.get(0).getAngularVelocity();
        this.state[1] = this.physicsWorld.rotaryWings.get(0).getRotationAngle();
        this.state[5] = 0.0f;
        this.state[6] = this.physicsWorld.vehicle.wheelInfo.get((int)2).rotation * this.helper.radToDeg;
        this.state[7] = this.physicsWorld.vehicle.wheelInfo.get((int)0).rotation * this.helper.radToDeg;
        this.state[8] = this.physicsWorld.vehicle.wheelInfo.get((int)1).rotation * this.helper.radToDeg;
        this.state[9] = 0.0f;
        this.state[10] = this.physicsWorld.vehicle.wheelInfo.get((int)0).wheelsSuspensionForce / this.physicsWorld.vehicle.wheelInfo.get((int)0).suspensionStiffness;
        this.state[11] = this.physicsWorld.vehicle.wheelInfo.get((int)1).wheelsSuspensionForce / this.physicsWorld.vehicle.wheelInfo.get((int)1).suspensionStiffness;
        this.physicsWorld.setControlChannel(1, -this.state[2]);
        this.physicsWorld.setControlChannel(2, -this.state[2]);
        this.physicsWorld.setControlChannel(3, -this.state[4]);
        this.physicsWorld.setControlChannel(4, this.state[4]);
        this.physicsWorld.setControlChannel(5, -this.state[3]);
        this.physicsWorld.setControlChannel(9, -this.state[3]);
        this.physicsWorld.setControlChannel(11, this.power / 100.0f);
        this.sendAdditionalPacket();
    }

    @Override
    public void spawnItems() {
        if (!this.damaged) {
            ItemStack gStack = new ItemStack((IItemProvider)RCM_Main.item_stuntplane);
            this.dropCustomItem(gStack, (GlobalItem)gStack.func_77973_b());
        } else {
            this.dropCraftItem((IItemProvider)RCM_Main.item_receivermodule, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_stuntplane_body, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_narrowwheel, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_servo, 0.8);
            this.dropCraftItem((IItemProvider)RCM_Main.item_propeller_high, 0.8);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSounds() {
        super.registerSounds();
        RCM_Main.PROXY.getSoundHandler().func_147682_a((ISound)new MovingSoundStuntPlaneHigh(this));
    }

    @Override
    public void sendAdditionalPacket() {
        if (!this.field_70170_p.field_72995_K) {
            MessageHandler.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with((Supplier)this), (Object)new MessageEntityStuntPlane(this.func_145782_y(), this.state));
        } else if (this.field_70170_p.field_72995_K) {
            MessageHandler.HANDLER.sendToServer((Object)new MessageEntityStuntPlane(this.func_145782_y(), this.state));
        }
    }

    public void additionalInfoUpdate(float[] newState) {
        this.netState = newState;
    }

    @Override
    public void updateAdditionalInfo() {
        this.prevState = (float[])this.state.clone();
        this.state = (float[])this.netState.clone();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        super.spawnParticles();
        if (this.power > 25.0f && !this.damaged) {
            BlockPos blockPos;
            BlockState blockstate;
            Block block;
            int a = -1;
            while ((block = (blockstate = this.field_70170_p.func_180495_p(blockPos = new BlockPos(this.field_70165_t, this.field_70163_u - 0.5 - (double)(++a), this.field_70161_v))).func_177230_c()) == Blocks.field_150350_a && a != 1) {
            }
            if (block == Blocks.field_150433_aE) {
                blockPos.func_177982_a(0, -1, 0);
            }
            int i1 = 0;
            while ((double)i1 < 2.0) {
                double d1 = this.field_70146_Z.nextFloat() * -1.0f - 1.0f;
                double d2 = (double)this.field_70146_Z.nextFloat() * -0.5 + 0.25;
                if (this.field_70146_Z.nextBoolean()) {
                    double d3 = this.field_70165_t + d1 * (double)this.Forward.x + d2 * (double)this.Left.x;
                    double d4 = this.field_70161_v + d1 * (double)this.Forward.z + d2 * (double)this.Left.z;
                    double d5 = d1 * (double)this.Forward.x + d2 * (double)this.Left.x;
                    double d6 = d1 * (double)this.Forward.z + d2 * (double)this.Left.z;
                    if (block != Blocks.field_150350_a && blockstate.func_185904_a() != Material.field_151579_a) {
                        this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(blockPos), d3, (double)blockPos.func_177956_o() + 1.125, d4, d5 * 10.0, 0.0, d6 * 10.0);
                    }
                }
                ++i1;
            }
        }
        if (!this.damaged && this.smoke) {
            for (int i1 = 0; i1 < 4; ++i1) {
                Vector3f pos = new Vector3f(this.Forward);
                pos.scale(-2.0f);
                Vector3f dis = new Vector3f(this.Up);
                dis.scale(-0.2f);
                pos.add((Tuple3f)dis);
                Vector3f vel = new Vector3f(this.Forward);
                vel.scale(-0.5f * this.power / 100.0f);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, (double)vel.x, (double)vel.y, (double)vel.z);
            }
        }
    }

    @Override
    public String getEntityName() {
        return "RC Stunt Plane";
    }
}

