/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Gui;

import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Gui.EntityContainer;
import net.eldercodes.thercmod.Gui.EntityGuiButton;
import net.eldercodes.thercmod.Items.ItemBattery;
import net.eldercodes.thercmod.Items.ItemElectricMotor;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class ContainerGui
extends ContainerScreen<Container> {
    private static final ResourceLocation guiTexture = new ResourceLocation("thercmod:textures/overlay/entitygui.png");
    private static final ResourceLocation guiPlaneIcon = new ResourceLocation("thercmod:textures/items/item_trainerplane.png");
    private static final ResourceLocation guiCarIcon = new ResourceLocation("thercmod:textures/items/item_car.png");
    private static final ResourceLocation guiBoatIcon = new ResourceLocation("thercmod:textures/items/item_boat.png");
    private static final ResourceLocation guiHeliIcon = new ResourceLocation("thercmod:textures/items/item_heli.png");
    private static final ResourceLocation guiDroneIcon = new ResourceLocation("thercmod:textures/items/item_drone.png");
    private static final ResourceLocation guiF22Icon = new ResourceLocation("thercmod:textures/items/item_f22.png");
    private static final ResourceLocation guiSubmarineIcon = new ResourceLocation("thercmod:textures/items/item_submarine.png");
    private static final ResourceLocation guiStuntPlaneIcon = new ResourceLocation("thercmod:textures/items/item_stuntplane.png");
    private static final ResourceLocation guiOctocopterIcon = new ResourceLocation("thercmod:textures/items/item_octocopter.png");
    private static final ResourceLocation guiRacerIcon = new ResourceLocation("thercmod:textures/items/item_racer.png");
    private final GlobalEntity rcentity;
    private ItemBattery itemBattery;
    private ItemElectricMotor itemMotor;

    public ContainerGui(Container screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        EntityContainer container = (EntityContainer)screenContainer;
        this.rcentity = container.getEntiy();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(guiTexture);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.minecraft.func_110434_K().func_110577_a(this.getIconResourceLocation(this.rcentity.getID()));
        ContainerGui.blit((int)(this.field_147003_i + 10), (int)(this.field_147009_r + 10), (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        ((Widget)this.buttons.get((int)0)).active = ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d();
    }

    public void init() {
        super.init();
        this.addButton((Widget)new EntityGuiButton(this.field_147003_i + 106, this.field_147009_r + 47, 30, 7, "", null, this.rcentity.activated));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String entityName = this.rcentity.getEntityName();
        this.font.func_211126_b(entityName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(entityName) / 2), 6.0f, 0x404040);
        this.font.func_211126_b("Inventory", 8.0f, 72.0f, 0x404040);
        this.drawControlsText(this.rcentity.defaultControls);
        this.drawInfo();
        this.func_191948_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
    }

    private ResourceLocation getIconResourceLocation(int id) {
        switch (id) {
            case 1: {
                return guiPlaneIcon;
            }
            case 2: {
                return guiDroneIcon;
            }
            case 3: {
                return guiCarIcon;
            }
            case 4: {
                return guiF22Icon;
            }
            case 5: {
                return guiHeliIcon;
            }
            case 6: {
                return guiF22Icon;
            }
            case 7: {
                return guiBoatIcon;
            }
            case 8: {
                return guiSubmarineIcon;
            }
            case 9: {
                return guiStuntPlaneIcon;
            }
            case 10: {
                return guiOctocopterIcon;
            }
            case 11: {
                return guiRacerIcon;
            }
        }
        return guiPlaneIcon;
    }

    private void drawControlsText(String[] controlList) {
        GL11.glPushMatrix();
        int HeightOffSet = this.field_147009_r - 20;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < controlList.length; ++i) {
            this.font.func_211126_b(controlList[i], (float)(-this.field_146999_f - 40), (float)HeightOffSet, 0xFFFFFF);
            HeightOffSet += 16;
        }
        GL11.glPopMatrix();
    }

    private void drawInfo() {
        String strTemp = "0";
        String strPerc = "0";
        if (((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d()) {
            this.itemMotor = (ItemElectricMotor)((Slot)this.field_147002_h.field_75151_b.get(0)).func_75211_c().func_77973_b();
            strTemp = String.format("%.0f", Float.valueOf(this.itemMotor.getMotorTemp(this.field_147002_h.func_75139_a(0).func_75211_c())));
        }
        if (((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d()) {
            this.itemBattery = (ItemBattery)((Slot)this.field_147002_h.field_75151_b.get(2)).func_75211_c().func_77973_b();
            strPerc = String.format("%.0f", Float.valueOf(this.itemBattery.getCharge(this.field_147002_h.func_75139_a(2).func_75211_c())));
        }
        GL11.glPushMatrix();
        int HeightOffSet = 41;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.font.func_211126_b("Electric Motor", (float)(this.field_146999_f + 25), (float)HeightOffSet, 0x404040);
        this.font.func_211126_b("Temperature: " + strTemp + "\u00b0C", (float)(this.field_146999_f + 25), (float)(HeightOffSet + 12), 0x404040);
        this.font.func_211126_b("Electric Speed Controller", (float)(this.field_146999_f + 25), (float)(HeightOffSet + 40), 0x404040);
        this.font.func_211126_b("On", (float)(this.field_146999_f + 25), (float)(HeightOffSet + 40 + 16), 0x404040);
        this.font.func_211126_b("Off", (float)(this.field_146999_f + 96), (float)(HeightOffSet + 40 + 16), 0x404040);
        this.font.func_211126_b("Battery", (float)(this.field_146999_f + 25), (float)(HeightOffSet + 80), 0x404040);
        this.font.func_211126_b("Charge: " + strPerc + "%", (float)(this.field_146999_f + 25), (float)(HeightOffSet + 12 + 80), 0x404040);
        GL11.glPopMatrix();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        EntityGuiButton button = (EntityGuiButton)((Object)this.buttons.get(0));
        if (button.isHovered() && ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d()) {
            this.rcentity.sendGUIStateToServer(button.getButtonState());
        }
        if (!(((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d() || !button.getButtonState().booleanValue())) {
            this.rcentity.sendGUIStateToServer(false);
            button.setState(false);
        }
        return true;
    }
}

