/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Items;

import java.util.List;
import javax.annotation.Nullable;
import net.eldercodes.thercmod.Capability.IItemStackHandler;
import net.eldercodes.thercmod.Capability.ItemStackProvider;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemElectricMotor
extends Item {
    public ItemElectricMotor(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        float altitude = (float)(entityIn.field_70163_u - worldIn.func_72919_O());
        float tempDiff = 25.0f + worldIn.func_180494_b(entityIn.func_180425_c()).func_180626_a(entityIn.func_180425_c()) * 10.0f - 0.4f * altitude - this.getMotorTemp(stack);
        float cooling = 2.3565001f * tempDiff / 2310.0f;
        this.changeMotorTemp(cooling, stack);
    }

    public void setMotorTemp(float temp, ItemStack stack) {
        ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).orElseThrow(null)).setMotorTemp(temp);
    }

    public float getMotorTemp(ItemStack stack) {
        return ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).orElseThrow(null)).getMotorTemp();
    }

    public void changeMotorTemp(float delta, ItemStack stack) {
        ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).orElseThrow(null)).addMotorTemp(delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).isPresent()) {
            String strPerc = String.format("%.0f", Float.valueOf(((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).orElseThrow(null)).getMotorTemp()));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.BLUE + "Temperature: " + strPerc + "\u00b0C", new Object[0]));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        IItemStackHandler handler = (IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null).orElseThrow(null);
        INBT capTag = ItemStackProvider.ITEMSTACK_CAP.getStorage().writeNBT(ItemStackProvider.ITEMSTACK_CAP, (Object)handler, null);
        tag.func_218657_a("ItemCap", capTag);
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        stack.func_77982_d(nbt);
        if (nbt != null) {
            CompoundNBT capTag = (CompoundNBT)nbt.func_74781_a("ItemCap");
            this.setMotorTemp(capTag.func_74760_g("motorTemp"), stack);
        }
    }
}

