/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Models;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Models.ModelFace;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class Model {
    private List<Vector3f> vertices = new ArrayList<Vector3f>();
    private List<Vector2f> textureCoordinates = new ArrayList<Vector2f>();
    private List<Vector3f> normals = new ArrayList<Vector3f>();
    private List<ModelFace> faces = new ArrayList<ModelFace>();
    private int[] vbo;

    public List<ModelFace> getFaces() {
        return this.faces;
    }

    public List<Vector3f> getVertices() {
        return this.vertices;
    }

    public List<Vector3f> getNormals() {
        return this.normals;
    }

    public List<Vector2f> getTextureCoordinates() {
        return this.textureCoordinates;
    }

    public void loadModel(String path, String name) throws FileNotFoundException, IOException {
        String line;
        URL url = Model.class.getResource(path);
        InputStream inputstream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
        while (!((line = reader.readLine()) == null || line.startsWith("o ") && line.contains(name))) {
        }
        line = reader.readLine();
        while (line != null && !line.startsWith("e ")) {
            if (line.startsWith("v ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                this.vertices.add(new Vector3f(x, y, z));
            } else if (line.startsWith("t ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = -Float.valueOf(line.split(" ")[2]).floatValue();
                this.textureCoordinates.add(new Vector2f(x, y));
            } else if (line.startsWith("n ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                this.normals.add(new Vector3f(x, y, z));
            } else if (line.startsWith("f ")) {
                int[] vertexIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[0]), Integer.valueOf(line.split(" ")[2].split("/")[0]), Integer.valueOf(line.split(" ")[3].split("/")[0])};
                int[] textureCoordinateIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[1]), Integer.valueOf(line.split(" ")[2].split("/")[1]), Integer.valueOf(line.split(" ")[3].split("/")[1])};
                int[] normalIndices = new int[]{Integer.valueOf(line.split(" ")[1].split("/")[2]), Integer.valueOf(line.split(" ")[2].split("/")[2]), Integer.valueOf(line.split(" ")[3].split("/")[2])};
                this.faces.add(new ModelFace(vertexIndices, normalIndices, textureCoordinateIndices));
            }
            line = reader.readLine();
        }
        reader.close();
        inputstream.close();
    }

    public int[] getVBO() {
        return this.vbo;
    }

    public void createVBO() {
        int vboVertexHandle = GL15.glGenBuffers();
        int vboNormalHandle = GL15.glGenBuffers();
        int vboTextureHandler = GL15.glGenBuffers();
        FloatBuffer textCoord = this.reserveData(this.faces.size() * 6);
        FloatBuffer norm = this.reserveData(this.faces.size() * 9);
        FloatBuffer vert = this.reserveData(this.faces.size() * 9);
        for (ModelFace face : this.faces) {
            textCoord.put(this.asFloats(this.textureCoordinates.get(face.getTextureCoordinateIndices()[0] - 1)));
            textCoord.put(this.asFloats(this.textureCoordinates.get(face.getTextureCoordinateIndices()[1] - 1)));
            textCoord.put(this.asFloats(this.textureCoordinates.get(face.getTextureCoordinateIndices()[2] - 1)));
            norm.put(this.asFloats(this.normals.get(face.getNormalIndices()[0] - 1)));
            norm.put(this.asFloats(this.normals.get(face.getNormalIndices()[1] - 1)));
            norm.put(this.asFloats(this.normals.get(face.getNormalIndices()[2] - 1)));
            vert.put(this.asFloats(this.vertices.get(face.getVertexIndices()[0] - 1)));
            vert.put(this.asFloats(this.vertices.get(face.getVertexIndices()[1] - 1)));
            vert.put(this.asFloats(this.vertices.get(face.getVertexIndices()[2] - 1)));
        }
        vert.flip();
        norm.flip();
        textCoord.flip();
        GL15.glBindBuffer((int)34962, (int)vboTextureHandler);
        GL15.glBufferData((int)34962, (FloatBuffer)textCoord, (int)35044);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)vboNormalHandle);
        GL15.glBufferData((int)34962, (FloatBuffer)norm, (int)35044);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)vboVertexHandle);
        GL15.glBufferData((int)34962, (FloatBuffer)vert, (int)35044);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
        this.vbo = new int[]{vboVertexHandle, vboNormalHandle, vboTextureHandler};
    }

    private FloatBuffer reserveData(int size) {
        return BufferUtils.createFloatBuffer((int)size);
    }

    private float[] asFloats(Vector3f v) {
        return new float[]{v.x, v.y, v.z};
    }

    private float[] asFloats(Vector2f v) {
        return new float[]{v.x, -v.y};
    }

    public void draw() {
        for (ModelFace face : this.faces) {
            Vector2f t1 = this.getTextureCoordinates().get(face.getTextureCoordinateIndices()[0] - 1);
            GL11.glTexCoord2f((float)t1.x, (float)(-t1.y));
            Vector3f n1 = this.getNormals().get(face.getNormalIndices()[0] - 1);
            GL11.glNormal3f((float)n1.x, (float)n1.y, (float)n1.z);
            Vector3f v1 = this.getVertices().get(face.getVertexIndices()[0] - 1);
            GL11.glVertex3f((float)v1.x, (float)v1.y, (float)v1.z);
            Vector2f t2 = this.getTextureCoordinates().get(face.getTextureCoordinateIndices()[1] - 1);
            GL11.glTexCoord2f((float)t2.x, (float)(-t2.y));
            Vector3f n2 = this.getNormals().get(face.getNormalIndices()[1] - 1);
            GL11.glNormal3f((float)n2.x, (float)n2.y, (float)n2.z);
            Vector3f v2 = this.getVertices().get(face.getVertexIndices()[1] - 1);
            GL11.glVertex3f((float)v2.x, (float)v2.y, (float)v2.z);
            Vector2f t3 = this.getTextureCoordinates().get(face.getTextureCoordinateIndices()[2] - 1);
            GL11.glTexCoord2f((float)t3.x, (float)(-t3.y));
            Vector3f n3 = this.getNormals().get(face.getNormalIndices()[2] - 1);
            GL11.glNormal3f((float)n3.x, (float)n3.y, (float)n3.z);
            Vector3f v3 = this.getVertices().get(face.getVertexIndices()[2] - 1);
            GL11.glVertex3f((float)v3.x, (float)v3.y, (float)v3.z);
        }
    }
}

