/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Packets;

import java.util.function.Supplier;
import net.eldercodes.thercmod.Entities.EntityBoat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityBoat {
    private float[] netState = new float[2];
    private int ID;

    public MessageEntityBoat(int entityID, float[] state) {
        this.ID = entityID;
        this.netState = state;
    }

    public static void encoder(MessageEntityBoat msg, PacketBuffer buf) {
        buf.writeInt(msg.ID);
        buf.writeFloat(msg.netState[0]);
        buf.writeFloat(msg.netState[1]);
    }

    public static MessageEntityBoat decoder(PacketBuffer buf) {
        int id = buf.readInt();
        float[] state = new float[12];
        state[0] = buf.readFloat();
        state[1] = buf.readFloat();
        return new MessageEntityBoat(id, state);
    }

    public static class Handler {
        public static void handler(MessageEntityBoat msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = null;
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.ID);
                } else if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                    entity = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(msg.ID);
                }
                if (entity != null && entity.func_145782_y() == msg.ID) {
                    EntityBoat pentity = (EntityBoat)entity;
                    pentity.additionalInfoUpdate(msg.netState);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

