/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Packets;

import java.util.function.Supplier;
import javax.vecmath.Quat4f;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageGlobalEntity {
    private int ID;
    private double posX;
    private double posY;
    private double posZ;
    private float throttle;
    private float quadX;
    private float quadY;
    private float quadZ;
    private float quadW;
    private boolean damaged;

    public MessageGlobalEntity(int entityID, double pX, double pY, double pZ, float qX, float qY, float qZ, float qW, float entityThrottle, boolean damage) {
        this.ID = entityID;
        this.posX = pX;
        this.posY = pY;
        this.posZ = pZ;
        this.quadX = qX;
        this.quadY = qY;
        this.quadZ = qZ;
        this.quadW = qW;
        this.throttle = entityThrottle;
        this.damaged = damage;
    }

    public static void encoder(MessageGlobalEntity msg, PacketBuffer buf) {
        buf.writeInt(msg.ID);
        buf.writeDouble(msg.posX);
        buf.writeDouble(msg.posY);
        buf.writeDouble(msg.posZ);
        buf.writeFloat(msg.quadX);
        buf.writeFloat(msg.quadY);
        buf.writeFloat(msg.quadZ);
        buf.writeFloat(msg.quadW);
        buf.writeFloat(msg.throttle);
        buf.writeBoolean(msg.damaged);
    }

    public static MessageGlobalEntity decoder(PacketBuffer buf) {
        return new MessageGlobalEntity(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
    }

    public static class Handler {
        public static void handler(MessageGlobalEntity msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = null;
                GlobalEntity nwEntity = null;
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.ID);
                } else if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                    entity = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(msg.ID);
                }
                if (entity != null && entity.func_145782_y() == msg.ID) {
                    nwEntity = (GlobalEntity)entity;
                    if (msg.quadX + msg.quadY + msg.quadZ + msg.quadW != 0.0f) {
                        nwEntity.packetUpdate(msg.posX, msg.posY, msg.posZ, new Quat4f(msg.quadX, msg.quadY, msg.quadZ, msg.quadW), msg.throttle, msg.damaged);
                    } else {
                        nwEntity.packetUpdate(msg.posX, msg.posY, msg.posZ, new Quat4f(), msg.throttle, msg.damaged);
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

