/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Packets;

import java.util.function.Supplier;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.ItemRemoteControl;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageItemStackHandler {
    private int ID;
    private int type;
    private float charge;
    private float motorTemp;
    private boolean state;

    public MessageItemStackHandler(int entityID, int messageType, float mTemp, float bCharge, boolean powerState) {
        this.ID = entityID;
        this.type = messageType;
        this.motorTemp = mTemp;
        this.charge = bCharge;
        this.state = powerState;
    }

    public static void encoder(MessageItemStackHandler msg, PacketBuffer buf) {
        buf.writeInt(msg.ID);
        buf.writeInt(msg.type);
        buf.writeFloat(msg.motorTemp);
        buf.writeFloat(msg.charge);
        buf.writeBoolean(msg.state);
    }

    public static MessageItemStackHandler decoder(PacketBuffer buf) {
        return new MessageItemStackHandler(buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
    }

    private static void handleItemRemoteControl(MessageItemStackHandler msg, Supplier<NetworkEvent.Context> ctx) {
        Entity entity = null;
        PlayerEntity player = null;
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.ID);
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            entity = ctx.get().getSender().field_70170_p.func_73045_a(msg.ID);
        }
        if (entity != null && entity.func_145782_y() == msg.ID && (player = (PlayerEntity)entity).func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemRemoteControl) {
            ItemRemoteControl remote = (ItemRemoteControl)player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                remote.setClientPowerState(player.func_184586_b(Hand.MAIN_HAND), msg.state);
            } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                remote.setServerPowerState(msg.ID, player.func_184586_b(Hand.MAIN_HAND).getStack(), msg.state, (Entity)player);
            }
        }
    }

    private static void handleItemBattery(MessageItemStackHandler msg, Supplier<NetworkEvent.Context> ctx) {
        Entity entity = null;
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            entity = ctx.get().getSender().field_70170_p.func_73045_a(msg.ID);
        }
        if (entity != null && entity.func_145782_y() == msg.ID) {
            GlobalEntity nwEntity = (GlobalEntity)entity;
            nwEntity.updateNetInventoryStats(msg.motorTemp, msg.charge);
        }
    }

    public static class Handler {
        public static void handler(MessageItemStackHandler msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                switch (msg.type) {
                    case 1: {
                        MessageItemStackHandler.handleItemRemoteControl(msg, ctx);
                        break;
                    }
                    case 2: {
                        MessageItemStackHandler.handleItemBattery(msg, ctx);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

