/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Physics.TimeToBreak;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PhysicsWorld {
    private DynamicsWorld dynamicsWorld;
    private Set<RigidBody> collisionShapes = new HashSet<RigidBody>();
    private Set<RigidBody> rigidbodies = new HashSet<RigidBody>();
    private Set<RigidBody> bodyRemoveList = new HashSet<RigidBody>();
    private Set<RaycastVehicle> vehicles = new HashSet<RaycastVehicle>();
    private Vector3f vSampleSize = new Vector3f((float)this.sampleSize, (float)this.sampleSize, (float)this.sampleSize);
    private int sampleSize = 1;

    public PhysicsWorld() {
        float gravity = -9.81f;
        DbvtBroadphase broadphase = new DbvtBroadphase();
        DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
        CollisionDispatcher dispatcher = new CollisionDispatcher(collisionConfiguration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld(dispatcher, broadphase, solver, collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3f(0.0f, gravity, 0.0f));
    }

    public void stepSimulation(float deltaTime, int maxSubSteps) {
        if (this.dynamicsWorld != null) {
            this.dynamicsWorld.stepSimulation(deltaTime, maxSubSteps);
            int numManifolds = this.dynamicsWorld.getDispatcher().getNumManifolds();
            for (int i = 0; i < numManifolds; ++i) {
                TimeToBreak dTime;
                PersistentManifold contactManifold = this.dynamicsWorld.getDispatcher().getManifoldByIndexInternal(i);
                RigidBody collidingBody = (RigidBody)contactManifold.getBody0();
                if (collidingBody.getUserPointer() == null || contactManifold.getNumContacts() <= 0 || !((dTime = (TimeToBreak)collidingBody.getUserPointer()).update(deltaTime) < 0.0f)) continue;
                this.bodyRemoveList.add(collidingBody);
                break;
            }
            for (RigidBody rb : this.bodyRemoveList) {
                this.removeConstraint(rb.getConstraintRef(0));
                this.removeRigidBody(rb);
            }
            this.bodyRemoveList.clear();
        }
    }

    public void addRigidBody(RigidBody entityBody) {
        this.dynamicsWorld.addRigidBody(entityBody);
        this.rigidbodies.add(entityBody);
    }

    public void removeRigidBody(RigidBody entityBody) {
        this.dynamicsWorld.removeRigidBody(entityBody);
        this.rigidbodies.remove(entityBody);
    }

    public void removeConstraint(TypedConstraint ct) {
        this.dynamicsWorld.removeConstraint(ct);
    }

    public void addVehicle(RaycastVehicle vehicle) {
        this.dynamicsWorld.addVehicle(vehicle);
        this.vehicles.add(vehicle);
    }

    public void removeVehicle(RaycastVehicle vehicle) {
        this.dynamicsWorld.removeVehicle(vehicle);
        this.vehicles.remove(vehicle);
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public void removeAll() {
        for (RaycastVehicle rv : this.vehicles) {
            this.dynamicsWorld.removeVehicle(rv);
        }
        for (RigidBody rb : this.rigidbodies) {
            this.dynamicsWorld.removeRigidBody(rb);
            if (rb.getNumConstraintRefs() <= 0) continue;
            this.dynamicsWorld.removeConstraint(rb.getConstraintRef(0));
        }
        this.vehicles.clear();
        this.rigidbodies.clear();
    }

    public void loadCollisionShapes(GlobalEntity entity, World world, Vector3f position) {
        Vector3f minAABB = new Vector3f(position);
        Vector3f maxAABB = new Vector3f(position);
        minAABB.sub((Tuple3f)this.vSampleSize);
        maxAABB.add((Tuple3f)this.vSampleSize);
        AxisAlignedBB aabb = new AxisAlignedBB((double)minAABB.x, (double)minAABB.y, (double)minAABB.z, (double)maxAABB.x, (double)maxAABB.y, (double)maxAABB.z);
        Iterator iterator = world.func_217352_b((Entity)entity, aabb, Collections.emptySet()).flatMap(p_212329_0_ -> p_212329_0_.func_197756_d().stream()).iterator();
        while (iterator.hasNext()) {
            AxisAlignedBB boxAABB;
            Vector3f newBoxPos = new Vector3f(((float)boxAABB.field_72336_d + (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e + (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f + (float)boxAABB.field_72339_c) / 2.0f);
            boxAABB = (AxisAlignedBB)iterator.next();
            if (this.shoudlDiscardShape(world, entity, newBoxPos, boxAABB)) continue;
            Vector3f boxSize = new Vector3f(((float)boxAABB.field_72336_d - (float)boxAABB.field_72340_a) / 2.0f + 0.005f, ((float)boxAABB.field_72337_e - (float)boxAABB.field_72338_b) / 2.0f + 0.005f, ((float)boxAABB.field_72334_f - (float)boxAABB.field_72339_c) / 2.0f + 0.005f);
            BoxShape groundBlock = new BoxShape(boxSize);
            ((CollisionShape)groundBlock).setMargin(0.01f);
            Transform startTransform = new Transform();
            startTransform.setIdentity();
            startTransform.origin.set((Tuple3f)newBoxPos);
            DefaultMotionState groundMotionState = new DefaultMotionState(startTransform);
            RigidBodyConstructionInfo groundBodyConstructionInfo = new RigidBodyConstructionInfo(0.0f, groundMotionState, groundBlock, new Vector3f(0.0f, 0.0f, 0.0f));
            RigidBody groundRigidBody = new RigidBody(groundBodyConstructionInfo);
            this.dynamicsWorld.addRigidBody(groundRigidBody);
            this.collisionShapes.add(groundRigidBody);
        }
    }

    private boolean shoudlDiscardShape(World world, Entity entity, Vector3f newBoxPos, AxisAlignedBB boxAABB) {
        for (RigidBody collisionBox : this.collisionShapes) {
            Vector3f boxPosition = collisionBox.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            if (boxPosition.x != newBoxPos.x || boxPosition.y != newBoxPos.y || boxPosition.z != newBoxPos.z) continue;
            return true;
        }
        if (!this.isSideBlock(world, newBoxPos)) {
            return true;
        }
        List entityList = world.func_72839_b(entity, boxAABB);
        for (Entity gEntity : entityList) {
            if (!(gEntity instanceof GlobalEntity)) continue;
            return true;
        }
        return world.func_217357_a(ItemEntity.class, boxAABB).size() > 0;
    }

    private boolean isSideBlock(World world, Vector3f pos) {
        BlockPos bp = new BlockPos((double)(pos.x - 0.5f + 1.0f), (double)(pos.y - 0.5f), (double)(pos.z - 0.5f));
        for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 1: {
                    bp = new BlockPos((double)(pos.x - 0.5f - 1.0f), (double)(pos.y - 0.5f), (double)(pos.z - 0.5f));
                    break;
                }
                case 2: {
                    bp = new BlockPos((double)(pos.x - 0.5f), (double)(pos.y - 0.5f + 1.0f), (double)(pos.z - 0.5f));
                    break;
                }
                case 3: {
                    bp = new BlockPos((double)(pos.x - 0.5f), (double)(pos.y - 0.5f - 1.0f), (double)(pos.z - 0.5f));
                    break;
                }
                case 4: {
                    bp = new BlockPos((double)(pos.x - 0.5f), (double)(pos.y - 0.5f), (double)(pos.z - 0.5f + 1.0f));
                    break;
                }
                case 5: {
                    bp = new BlockPos((double)(pos.x - 0.5f), (double)(pos.y - 0.5f), (double)(pos.z - 0.5f - 1.0f));
                    break;
                }
            }
            BlockState bs = world.func_180495_p(bp);
            if (bs.func_185904_a().func_76230_c() && bs.func_215686_e((IBlockReader)world, bp)) continue;
            return true;
        }
        return false;
    }

    public void unloadCollisionShapes(World world, List<GlobalEntity> entityList) {
        HashSet<RigidBody> toRemoveColBox = new HashSet<RigidBody>();
        for (RigidBody collisionBks : this.collisionShapes) {
            boolean flag = false;
            Vector3f boxPosition = collisionBks.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            for (GlobalEntity entity : entityList) {
                Vector3f dist = new Vector3f(entity.position);
                dist.sub((Tuple3f)boxPosition);
                if (!(dist.length() <= (float)(this.sampleSize + 1))) continue;
                flag = true;
                BlockPos bp = new BlockPos((double)boxPosition.x, (double)boxPosition.y, (double)boxPosition.z);
                BlockState bs = world.func_180495_p(bp);
                flag = bs.func_185904_a().func_76230_c();
            }
            if (flag) continue;
            toRemoveColBox.add(collisionBks);
        }
        for (RigidBody colBox : toRemoveColBox) {
            this.dynamicsWorld.removeRigidBody(colBox);
            this.collisionShapes.remove(colBox);
        }
        toRemoveColBox.clear();
    }
}

