/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Renders;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.eldercodes.thercmod.Entities.EntityCar;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Models.Model;
import net.eldercodes.thercmod.RCM_Main;
import net.eldercodes.thercmod.Renders.GlobalRender;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderCar
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/carskin.png");
    public Model rightWheel = null;
    public Model leftWheel = null;
    public Model suspension = null;

    public RenderCar(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.2f;
        String filePath = RCM_Main.modelFilePath + "car.rcm";
        try {
            this.mainBody = new Model();
            this.rightWheel = new Model();
            this.leftWheel = new Model();
            this.suspension = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.leftWheel.loadModel(filePath, "LeftWheel");
            this.rightWheel.loadModel(filePath, "RightWheel");
            this.suspension.loadModel(filePath, "Suspension");
        }
        catch (FileNotFoundException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file is missing!!");
        }
        catch (IOException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file loaded incorrectly!!");
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        EntityCar carEntity = (EntityCar)rcentity;
        GL11.glPushMatrix();
        float dis = (carEntity.prevState[6] + (carEntity.state[6] - carEntity.prevState[6]) * timeStep) * 0.125f;
        float def = -((float)(Math.asin(dis / 0.10942101f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)0.03f, (float)-0.00616f, (float)0.1771f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.suspension.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.10942101f, (float)-0.02765f, (float)0.0f);
        GL11.glRotatef((float)(carEntity.prevState[1] + (carEntity.state[1] - carEntity.prevState[1]) * timeStep), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(carEntity.prevState[2] + (carEntity.state[2] - carEntity.prevState[2]) * timeStep), (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.leftWheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dis = (carEntity.prevState[7] + (carEntity.state[7] - carEntity.prevState[7]) * timeStep) * 0.125f;
        def = -((float)(Math.asin(dis / 0.10942101f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)-0.03f, (float)-0.00616f, (float)0.1771f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.suspension.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.10942101f, (float)-0.02765f, (float)0.0f);
        GL11.glRotatef((float)(carEntity.prevState[1] + (carEntity.state[1] - carEntity.prevState[1]) * timeStep), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(carEntity.prevState[3] + (carEntity.state[3] - carEntity.prevState[3]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rightWheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dis = (carEntity.prevState[8] + (carEntity.state[8] - carEntity.prevState[8]) * timeStep) * 0.125f;
        def = -((float)(Math.asin(dis / 0.10942101f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)0.03f, (float)-0.00616f, (float)-0.16f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.suspension.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.10942101f, (float)-0.02765f, (float)0.0f);
        GL11.glRotatef((float)(carEntity.prevState[4] + (carEntity.state[4] - carEntity.prevState[4]) * timeStep), (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.leftWheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dis = (carEntity.prevState[9] + (carEntity.state[9] - carEntity.prevState[9]) * timeStep) * 0.125f;
        def = -((float)(Math.asin(dis / 0.10942101f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)-0.03f, (float)-0.00616f, (float)-0.16f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.suspension.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.10942101f, (float)-0.02765f, (float)0.0f);
        GL11.glRotatef((float)(carEntity.prevState[5] + (carEntity.state[5] - carEntity.prevState[5]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rightWheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation getEntityTexture(GlobalEntity entity) {
        return this.textureLocation;
    }
}

