/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Renders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Items.ItemRemoteControl;
import net.eldercodes.thercmod.Models.Model;
import net.eldercodes.thercmod.Models.ModelFace;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderRemoteControl
extends ItemStackTileEntityRenderer
implements Supplier<Callable<ItemStackTileEntityRenderer>>,
Callable<ItemStackTileEntityRenderer> {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/remotecontrolskin.png");
    private ResourceLocation textureLocationLight = new ResourceLocation("thercmod:textures/items/item_remotecontrolon.png");
    private Model remoteModel = null;

    public RenderRemoteControl() {
        String filePath = RCM_Main.modelFilePath + "remotecontrol.rcm";
        try {
            this.remoteModel = new Model();
            this.remoteModel.loadModel(filePath, "RemoteControl");
        }
        catch (FileNotFoundException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "Remote Control model file is missing!!");
        }
        catch (IOException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "Remote Control model file loaded incorrectly!!");
        }
    }

    public void func_179022_a(ItemStack itemstack) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureLocation);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.remoteModel);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        ItemRemoteControl remote = (ItemRemoteControl)itemstack.func_77973_b();
        if (remote.getPowerState(itemstack)) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureLocationLight);
            GL11.glPushMatrix();
            int x = 32;
            int y = 32;
            float f5 = 0.002f;
            GL11.glScalef((float)f5, (float)f5, (float)f5);
            GL11.glTranslatef((float)0.0f, (float)60.8f, (float)1.43f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)6.1f, (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b((double)(-x), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)(-x), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            GL11.glClear((int)0);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public void drawObject(Model model) {
        for (ModelFace face : model.getFaces()) {
            Vector2f t1 = model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[0] - 1);
            GL11.glTexCoord2f((float)t1.x, (float)t1.y);
            Vector3f n1 = model.getNormals().get(face.getNormalIndices()[0] - 1);
            GL11.glNormal3f((float)n1.x, (float)n1.y, (float)n1.z);
            Vector3f v1 = model.getVertices().get(face.getVertexIndices()[0] - 1);
            GL11.glVertex3f((float)v1.x, (float)v1.y, (float)v1.z);
            Vector2f t2 = model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[1] - 1);
            GL11.glTexCoord2f((float)t2.x, (float)t2.y);
            Vector3f n2 = model.getNormals().get(face.getNormalIndices()[1] - 1);
            GL11.glNormal3f((float)n2.x, (float)n2.y, (float)n2.z);
            Vector3f v2 = model.getVertices().get(face.getVertexIndices()[1] - 1);
            GL11.glVertex3f((float)v2.x, (float)v2.y, (float)v2.z);
            Vector2f t3 = model.getTextureCoordinates().get(face.getTextureCoordinateIndices()[2] - 1);
            GL11.glTexCoord2f((float)t3.x, (float)t3.y);
            Vector3f n3 = model.getNormals().get(face.getNormalIndices()[2] - 1);
            GL11.glNormal3f((float)n3.x, (float)n3.y, (float)n3.z);
            Vector3f v3 = model.getVertices().get(face.getVertexIndices()[2] - 1);
            GL11.glVertex3f((float)v3.x, (float)v3.y, (float)v3.z);
        }
    }

    @Override
    public Callable<ItemStackTileEntityRenderer> get() {
        return this;
    }

    @Override
    public ItemStackTileEntityRenderer call() throws Exception {
        return this;
    }
}

