/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Renders;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.EntityStuntPlane;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Models.Model;
import net.eldercodes.thercmod.RCM_Main;
import net.eldercodes.thercmod.Renders.GlobalRender;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderStuntPlane
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/stuntplaneskin.png");
    private ResourceLocation textureLocationBlur = new ResourceLocation("thercmod:textures/models/stuntplaneblur.png");
    public Model canopy = null;
    public Model rightAileron = null;
    public Model leftAileron = null;
    public Model rudder = null;
    public Model elevator = null;
    public Model propeller = null;
    public Model propellerBlur = null;
    public Model wheel = null;
    public Model mainGearRight = null;
    public Model mainGearLeft = null;
    public Model smallWheel = null;

    public RenderStuntPlane(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.25f;
        String filePath = RCM_Main.modelFilePath + "stuntplane.rcm";
        try {
            this.mainBody = new Model();
            this.canopy = new Model();
            this.rightAileron = new Model();
            this.leftAileron = new Model();
            this.rudder = new Model();
            this.elevator = new Model();
            this.propeller = new Model();
            this.propellerBlur = new Model();
            this.wheel = new Model();
            this.mainGearRight = new Model();
            this.mainGearLeft = new Model();
            this.smallWheel = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.canopy.loadModel(filePath, "Canopy");
            this.rightAileron.loadModel(filePath, "RightAileron");
            this.leftAileron.loadModel(filePath, "LeftAileron");
            this.rudder.loadModel(filePath, "Rudder");
            this.elevator.loadModel(filePath, "Elevator");
            this.propeller.loadModel(filePath, "Propeller");
            this.propellerBlur.loadModel(filePath, "PropellerBlur");
            this.wheel.loadModel(filePath, "Wheel");
            this.mainGearRight.loadModel(filePath, "MainGearRight");
            this.mainGearLeft.loadModel(filePath, "MainGearLeft");
            this.smallWheel.loadModel(filePath, "SmallWheel");
        }
        catch (FileNotFoundException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file is missing!!");
        }
        catch (IOException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file loaded incorrectly!!");
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        EntityStuntPlane trainerenity = (EntityStuntPlane)rcentity;
        GL11.glPushMatrix();
        float dis = (trainerenity.prevState[10] + (trainerenity.state[10] - trainerenity.prevState[10]) * timeStep) * 0.5f;
        float def = -((float)(Math.asin(dis / 0.18511f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)-0.068858f, (float)-0.068858f, (float)0.0f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.mainGearRight.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.117475f, (float)-0.141741f, (float)0.09809f);
        GL11.glRotatef((float)(trainerenity.prevState[7] + (trainerenity.state[7] - trainerenity.prevState[7]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.wheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dis = (trainerenity.prevState[11] + (trainerenity.state[11] - trainerenity.prevState[11]) * timeStep) * 0.5f;
        def = (float)(Math.asin(dis / 0.18511f) / Math.PI) * 180.0f;
        GL11.glTranslatef((float)0.068858f, (float)-0.068858f, (float)0.0f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.mainGearLeft.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.117475f, (float)-0.141741f, (float)0.09809f);
        GL11.glRotatef((float)(trainerenity.prevState[8] + (trainerenity.state[8] - trainerenity.prevState[8]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.wheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        Vector3f localTrans = new Vector3f();
        Vector3f rotateAxis = new Vector3f();
        localTrans.set(-0.102224f, -0.025836f, -0.173656f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.064059f, 0.0f, 0.997946f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((trainerenity.prevState[2] + (trainerenity.state[2] - trainerenity.prevState[2]) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rightAileron.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.102224f, -0.025836f, -0.173656f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, -0.064059f, 0.0f, 0.997946f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[2] + (trainerenity.state[2] - trainerenity.prevState[2]) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.leftAileron.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, 0.049582f, -0.856495f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[3] + (trainerenity.state[3] - trainerenity.prevState[3]) * timeStep) * 30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rudder.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.18596f, (float)-0.03945f);
        GL11.glRotatef((float)(trainerenity.prevState[6] + (trainerenity.state[6] - trainerenity.prevState[6]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.smallWheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        localTrans.set(0.0f, -0.006036f, -0.83929f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[4] + (trainerenity.state[4] - trainerenity.prevState[4]) * timeStep) * 25.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.elevator.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.canopy.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, 0.029381f, 0.392859f);
        rotateAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(trainerenity.prevState[1] + (trainerenity.state[1] - trainerenity.prevState[1]) * timeStep * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.propeller.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.field_76990_c.field_78724_e.func_110577_a(this.textureLocationBlur);
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(trainerenity.prevState[1] + (trainerenity.state[1] - trainerenity.prevState[1]) * timeStep * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBegin((int)4);
        float visiblility = 1.0f;
        float par1 = trainerenity.prevState[0] + (trainerenity.state[0] - trainerenity.prevState[0]) * timeStep;
        if (Math.abs(par1) < 600.0f) {
            visiblility = Math.abs(par1 / 600.0f);
        }
        if (visiblility > 1.0f) {
            visiblility = 1.0f;
        } else if (visiblility < 0.0f) {
            visiblility = 0.0f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
        this.propellerBlur.draw();
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation getEntityTexture(GlobalEntity entity) {
        return this.textureLocation;
    }
}

