/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Renders;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.EntityTrainerPlane;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Models.Model;
import net.eldercodes.thercmod.RCM_Main;
import net.eldercodes.thercmod.Renders.GlobalRender;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderTrainerPlane
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/trainerplaneskin.png");
    public Model rightAileron = null;
    public Model leftAileron = null;
    public Model rudder = null;
    public Model elevator = null;
    public Model propeller = null;
    public Model propellerBlur = null;
    public Model frontGear = null;
    public Model wheel = null;
    public Model mainGear = null;
    public Model mainGearLeft = null;

    public RenderTrainerPlane(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.25f;
        String filePath = RCM_Main.modelFilePath + "trainerplane.rcm";
        try {
            this.mainBody = new Model();
            this.rightAileron = new Model();
            this.leftAileron = new Model();
            this.rudder = new Model();
            this.elevator = new Model();
            this.propeller = new Model();
            this.propellerBlur = new Model();
            this.frontGear = new Model();
            this.wheel = new Model();
            this.mainGear = new Model();
            this.mainGearLeft = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.rightAileron.loadModel(filePath, "RightAileron");
            this.leftAileron.loadModel(filePath, "LeftAileron");
            this.rudder.loadModel(filePath, "Rudder");
            this.elevator.loadModel(filePath, "Elevator");
            this.propeller.loadModel(filePath, "Propeller");
            this.propellerBlur.loadModel(filePath, "PropellerBlur");
            this.frontGear.loadModel(filePath, "FrontGear");
            this.wheel.loadModel(filePath, "Wheel");
            this.mainGear.loadModel(filePath, "MainGear");
            this.mainGearLeft.loadModel(filePath, "MainGearLeft");
        }
        catch (FileNotFoundException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file is missing!!");
        }
        catch (IOException e) {
            RCM_Main.LOGGER.log(Level.ERROR, "RC Trainer model file loaded incorrectly!!");
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        EntityTrainerPlane trainerenity = (EntityTrainerPlane)rcentity;
        GL11.glPushMatrix();
        float dis = (trainerenity.prevState[11] + (trainerenity.state[11] - trainerenity.prevState[11]) * timeStep) * 0.5f;
        float def = -((float)(Math.asin(dis / 0.18511f) / Math.PI)) * 180.0f;
        GL11.glTranslatef((float)-0.043f, (float)-0.09252f, (float)-0.10614f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.mainGear.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.18511f, (float)-0.091704f, (float)-0.03213f);
        GL11.glRotatef((float)(trainerenity.prevState[7] + (trainerenity.state[7] - trainerenity.prevState[7]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.wheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        dis = (trainerenity.prevState[10] + (trainerenity.state[10] - trainerenity.prevState[10]) * timeStep) * 0.5f;
        def = (float)(Math.asin(dis / 0.18511f) / Math.PI) * 180.0f;
        GL11.glTranslatef((float)0.043f, (float)-0.09252f, (float)-0.10614f);
        GL11.glRotatef((float)def, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.mainGearLeft.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.18511f, (float)-0.091704f, (float)-0.03213f);
        GL11.glRotatef((float)(trainerenity.prevState[8] + (trainerenity.state[8] - trainerenity.prevState[8]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.wheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        Vector3f localTrans = new Vector3f();
        Vector3f rotateAxis = new Vector3f();
        localTrans.set(0.0f, -0.15517f, 0.20623f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.093f, 0.0f, 0.0f, 0.996f), new Vector3f(0.0f, 1.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)(localTrans.y + (trainerenity.prevState[9] + (trainerenity.state[9] - trainerenity.prevState[9]) * timeStep)), (float)localTrans.z);
        GL11.glRotatef((float)(trainerenity.prevState[5] + (trainerenity.state[5] - trainerenity.prevState[5]) * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.frontGear.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.03135f, (float)0.0058380067f);
        GL11.glRotatef((float)(trainerenity.prevState[6] + (trainerenity.state[6] - trainerenity.prevState[6]) * timeStep), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.wheel.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        localTrans.set(0.0f, -0.0077f, 0.31713f);
        rotateAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(trainerenity.prevState[1] + (trainerenity.state[1] - trainerenity.prevState[1]) * timeStep * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.propeller.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(trainerenity.prevState[1] + (trainerenity.state[1] - trainerenity.prevState[1]) * timeStep * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBegin((int)4);
        float visiblility = 1.0f;
        float par1 = trainerenity.prevState[0] + (trainerenity.state[0] - trainerenity.prevState[0]) * timeStep;
        if (Math.abs(par1) < 300.0f) {
            visiblility = Math.abs(par1 / 300.0f);
        }
        if (visiblility > 1.0f) {
            visiblility = 1.0f;
        } else if (visiblility < 0.0f) {
            visiblility = 0.0f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
        this.propellerBlur.draw();
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        localTrans.set(-0.45133f, 0.09713f, -0.22248f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, -0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((trainerenity.prevState[2] + (trainerenity.state[2] - trainerenity.prevState[2]) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rightAileron.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.45133f, 0.09713f, -0.22248f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, 0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[2] + (trainerenity.state[2] - trainerenity.prevState[2]) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.leftAileron.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, 0.08955f, -0.85616f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.112f, 0.0f, 0.0f, 0.994f), new Vector3f(0.0f, 1.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[3] + (trainerenity.state[3] - trainerenity.prevState[3]) * timeStep) * 20.0f), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.rudder.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, -0.01398f, -0.83274f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-(trainerenity.prevState[4] + (trainerenity.state[4] - trainerenity.prevState[4]) * timeStep) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.elevator.draw();
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation getEntityTexture(GlobalEntity entity) {
        return this.textureLocation;
    }
}

