/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod;

import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.CameraHandler;
import net.eldercodes.thercmod.Entities.EntityF22;
import net.eldercodes.thercmod.Entities.EntitySubmarine;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.ItemBattery;
import net.eldercodes.thercmod.Packets.MessageCanTeleportPlayer;
import net.eldercodes.thercmod.Packets.MessageHandler;
import net.eldercodes.thercmod.Packets.MessageTeleportPlayer;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class TickHandler {
    private ResourceLocation textureLocationCompass = new ResourceLocation("thercmod:textures/overlay/compass.png");
    private ResourceLocation textureLocationArrow = new ResourceLocation("thercmod:textures/overlay/arrow.png");
    private ResourceLocation textureLocationRemoteScreen = new ResourceLocation("thercmod:textures/overlay/remotescreen.png");
    private ResourceLocation textureLocationCrosshair = new ResourceLocation("thercmod:textures/overlay/crosshair.png");
    private ResourceLocation textureLocationBattery = new ResourceLocation("thercmod:textures/overlay/battery.png");
    private ResourceLocation textureLocationBatteryBar = new ResourceLocation("thercmod:textures/overlay/batterybar.png");
    public static GlobalEntity rcEntity;
    private CameraHandler camEntity;
    public double posX;
    public double posY;
    public double posZ;
    private boolean setPos = false;
    private float fistLookYaw;
    private float lookYaw;
    private float prevLookYaw;
    private int camMode;
    private int oldCamMode;
    public static boolean thirdPersonView;
    private boolean canResetPos;
    private boolean resetLook;
    private long counter;
    private boolean notificationSent;
    private long endTime;

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            ItemStack itemstack = null;
            if (mc.field_71439_g != null) {
                itemstack = mc.field_71439_g.field_71071_by.func_70448_g();
            }
            if (itemstack != null && rcEntity != null) {
                if (TickHandler.rcEntity.activated && rcEntity.holdingremotecontrol((PlayerEntity)mc.field_71439_g)) {
                    this.camMode = mc.field_71474_y.field_74320_O;
                    this.setCamLock(mc, itemstack, event.renderTickTime);
                    if (this.camEntity != null && !mc.func_147113_T()) {
                        this.camEntity.customTick(event.renderTickTime, mc);
                    }
                    if (!thirdPersonView && this.oldCamMode - this.camMode == 2) {
                        this.setRCCam((World)mc.field_71441_e, mc, rcEntity);
                    } else if (thirdPersonView && this.camMode == 1) {
                        this.resetRCCam(mc);
                    }
                    this.oldCamMode = this.camMode;
                } else {
                    if (thirdPersonView) {
                        this.resetRCCam(mc);
                    }
                    this.camMode = 0;
                    this.setPos = false;
                }
            } else {
                if (thirdPersonView) {
                    this.resetRCCam(mc);
                }
                this.camMode = 0;
                this.setPos = false;
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            this.endTime = System.currentTimeMillis();
            if (!"4.0.1.0".equals(RCM_Main.newVersion) && !this.notificationSent && mc.func_195544_aj() && mc.field_71439_g != null) {
                this.notificationSent = true;
                TranslationTextComponent finalMsg = new TranslationTextComponent("The RC Mod", new Object[0]);
                finalMsg.func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE));
                TranslationTextComponent text = new TranslationTextComponent(" update available: ", new Object[0]);
                text.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
                finalMsg.func_150257_a((ITextComponent)text);
                Style linkStyle = new Style();
                linkStyle.func_150228_d(Boolean.valueOf(true));
                linkStyle.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://www.eldercodes.net/downloads"));
                linkStyle.func_150238_a(TextFormatting.GOLD);
                text = new TranslationTextComponent("v" + RCM_Main.newVersion, new Object[0]);
                text.func_150255_a(linkStyle);
                finalMsg.func_150257_a((ITextComponent)text);
                mc.field_71439_g.func_145747_a((ITextComponent)finalMsg);
            }
            int i = mc.field_195558_d.func_198107_o();
            int j = mc.field_195558_d.func_198087_p();
            if (thirdPersonView && mc.field_71462_r == null && rcEntity != null && !mc.field_71456_v.func_146158_b().func_146241_e()) {
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glOrtho((double)0.0, (double)mc.field_195558_d.func_198105_m(), (double)mc.field_195558_d.func_198083_n(), (double)0.0, (double)10000.0, (double)-10000.0);
                GL11.glMatrixMode((int)5888);
                GL11.glScaled((double)mc.field_195558_d.func_198100_s(), (double)mc.field_195558_d.func_198100_s(), (double)mc.field_195558_d.func_198100_s());
                this.drawCompass(mc, i, 30, event.renderTickTime);
                this.drawRemoteScreen(mc, i, j, event.renderTickTime);
                this.drawRemoteScreenText(mc, i, j, event.renderTickTime);
                this.drawBattery(mc, i, j);
                if (TickHandler.rcEntity.weaponsMode && rcEntity instanceof EntitySubmarine) {
                    this.drawCrosshair(mc, i, j);
                }
                this.drawChat(mc, i, j);
            }
        }
    }

    private void setCamLock(Minecraft mc, ItemStack itemstack, float partialTick) {
        double distToEntity;
        if (!this.setPos) {
            this.posX = mc.field_71439_g.field_70165_t;
            this.posY = mc.field_71439_g.field_70163_u;
            this.posZ = mc.field_71439_g.field_70161_v;
            this.setPos = true;
            this.resetLook = true;
        }
        if (this.resetLook) {
            this.fistLookYaw = mc.field_71439_g.field_70177_z / 180.0f * (float)Math.PI;
            while (this.fistLookYaw >= (float)Math.PI * 2) {
                this.fistLookYaw -= (float)Math.PI * 2;
            }
            while (this.fistLookYaw < (float)Math.PI * -2) {
                this.fistLookYaw += (float)Math.PI * 2;
            }
            this.resetLook = false;
        }
        float deltaPosX = (float)(TickHandler.rcEntity.field_70169_q + (TickHandler.rcEntity.field_70165_t - TickHandler.rcEntity.field_70169_q) * (double)partialTick - this.posX);
        float deltaPosY = (float)(TickHandler.rcEntity.field_70167_r + (TickHandler.rcEntity.field_70163_u - TickHandler.rcEntity.field_70167_r) * (double)partialTick - (this.posY + (double)mc.field_71439_g.func_70047_e()));
        float deltaPosZ = (float)(TickHandler.rcEntity.field_70166_s + (TickHandler.rcEntity.field_70161_v - TickHandler.rcEntity.field_70166_s) * (double)partialTick - this.posZ);
        Vector3f pitchLookVec = new Vector3f(deltaPosX, deltaPosY, deltaPosZ);
        Vector3f pitchReferenceVec = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f yawLookVec = new Vector3f(deltaPosX, 0.0f, deltaPosZ);
        Vector3f prevYawLookVec = new Vector3f(deltaPosX, 0.0f, deltaPosZ);
        Vector3f yawReferenceVec = new Vector3f(0.0f, 0.0f, 1.0f);
        float lookPitch = pitchLookVec.angle(pitchReferenceVec) - 1.5707964f;
        if (pitchLookVec.x < 0.0f) {
            this.lookYaw = yawLookVec.angle(yawReferenceVec);
            this.prevLookYaw = prevYawLookVec.angle(yawReferenceVec);
        } else {
            this.lookYaw = -yawLookVec.angle(yawReferenceVec);
            this.prevLookYaw = -prevYawLookVec.angle(yawReferenceVec);
        }
        float lookYawdiff = this.lookYaw - this.fistLookYaw > (float)Math.PI ? this.lookYaw - this.fistLookYaw - (float)Math.PI * 2 : (this.lookYaw - this.fistLookYaw < (float)(-Math.PI) ? this.lookYaw - this.fistLookYaw + (float)Math.PI * 2 : this.lookYaw - this.fistLookYaw);
        if (mc.field_71474_y.field_74320_O == 0 && !thirdPersonView) {
            mc.field_71439_g.field_70125_A = lookPitch * 180.0f / (float)Math.PI + 5.0f;
        } else if (mc.field_71474_y.field_74320_O == 1 && !thirdPersonView) {
            mc.field_71439_g.field_70125_A = lookPitch * 180.0f / (float)Math.PI + 15.0f;
        } else if (!thirdPersonView) {
            mc.field_71439_g.field_70125_A = lookPitch * 180.0f / (float)Math.PI;
        }
        if (!thirdPersonView) {
            mc.field_71439_g.field_70177_z += lookYawdiff * 180.0f / (float)Math.PI;
        }
        if (((distToEntity = rcEntity.func_70092_e(this.posX, TickHandler.rcEntity.field_70163_u, this.posZ)) <= 40000.0 && !thirdPersonView || distToEntity <= 2500.0 && thirdPersonView) && !this.canResetPos) {
            mc.field_71439_g.func_213315_a(MoverType.PLAYER, new Vec3d(this.posX - mc.field_71439_g.field_70165_t, this.posY - mc.field_71439_g.field_70163_u, this.posZ - mc.field_71439_g.field_70161_v));
        } else if (thirdPersonView && distToEntity > 2500.0 && TickHandler.rcEntity.activated) {
            MessageHandler.HANDLER.sendToServer((Object)new MessageCanTeleportPlayer(rcEntity.func_145782_y(), true));
            this.canResetPos = true;
        } else if (distToEntity <= 2500.0) {
            this.resetPlayerPos((PlayerEntity)mc.field_71439_g);
        }
        mc.field_71439_g.func_213293_j(0.0, 0.0, 0.0);
        this.fistLookYaw = this.lookYaw;
    }

    public void setRCCam(World world, Minecraft mc, GlobalEntity entity) {
        this.camEntity = new CameraHandler(world, entity);
        mc.func_175607_a((Entity)this.camEntity);
        mc.field_71474_y.field_74319_N = true;
        mc.field_71474_y.field_74320_O = 0;
        thirdPersonView = true;
    }

    public void resetRCCam(Minecraft mc) {
        if (this.camEntity != null) {
            this.camEntity = null;
        }
        if (mc.field_71439_g != null) {
            mc.field_71439_g.func_213315_a(MoverType.PLAYER, new Vec3d(this.posX - mc.field_71439_g.field_70165_t, this.posY - mc.field_71439_g.field_70163_u, this.posZ - mc.field_71439_g.field_70161_v));
            mc.func_175607_a((Entity)mc.field_71439_g);
            mc.field_71474_y.field_74319_N = false;
            mc.field_71474_y.field_74320_O = 0;
            if (this.canResetPos) {
                this.resetPlayerPos((PlayerEntity)mc.field_71439_g);
            }
        }
        this.resetLook = true;
        thirdPersonView = false;
    }

    private void resetPlayerPos(PlayerEntity thePlayer) {
        if (rcEntity != null) {
            MessageHandler.HANDLER.sendToServer((Object)new MessageCanTeleportPlayer(rcEntity.func_145782_y(), false));
        }
        MessageHandler.HANDLER.sendToServer((Object)new MessageTeleportPlayer(thePlayer.func_145782_y(), this.posX, this.posY, this.posZ));
        this.canResetPos = false;
    }

    public void drawCompass(Minecraft mc, int i, int j, float renderTicks) {
        int color = 0xCCFF33;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int x = 256;
        int y = 256;
        float compassRotation = -TickHandler.rcEntity.field_70126_B - (TickHandler.rcEntity.field_70177_z - TickHandler.rcEntity.field_70126_B) * renderTicks;
        float arrowDirc = (this.prevLookYaw + (this.lookYaw - this.prevLookYaw) * renderTicks) * 180.0f / (float)Math.PI + 180.0f;
        float scale = 0.1f;
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationCompass);
        GL11.glTranslatef((float)((float)i / 2.0f), (float)j, (float)0.0f);
        GL11.glRotatef((float)compassRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor3f((float)red, (float)green, (float)blue);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-x + 1), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-x + 1), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationArrow);
        GL11.glTranslatef((float)((float)i / 2.0f), (float)j, (float)0.0f);
        GL11.glRotatef((float)(arrowDirc + compassRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor3f((float)red, (float)green, (float)blue);
        Tessellator tessellator2 = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer2 = tessellator2.func_178180_c();
        vertexbuffer2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer2.func_181662_b((double)(-x + 1), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)(-x + 1), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator2.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void drawRemoteScreen(Minecraft mc, int i, int j, float renderTicks) {
        int x = 417;
        int y = 233;
        float scale = 0.115f;
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationRemoteScreen);
        GL11.glTranslatef((float)(5.0f + (float)x * scale), (float)((float)(j - 5) - (float)y * scale), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-x + 1), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-x + 1), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationRemoteScreen);
        GL11.glTranslatef((float)((float)(i - 5) - (float)x * scale), (float)((float)(j - 5) - (float)y * scale), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Tessellator tessellator2 = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer2 = tessellator2.func_178180_c();
        vertexbuffer2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer2.func_181662_b((double)(-x + 1), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer2.func_181662_b((double)(-x + 1), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void drawRemoteScreenText(Minecraft mc, int i, int j, float renderTicks) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String speed = String.format("%.1f", Float.valueOf(TickHandler.rcEntity.forwardVelocity));
        String height = String.format("%.1f", Float.valueOf(TickHandler.rcEntity.altitude));
        String range = String.format("%.1f", Math.sqrt(rcEntity.func_70092_e(this.posX, this.posY, this.posZ)));
        mc.field_71466_p.func_211126_b("Speed: " + speed + "m/s", (float)(i - 92), (float)(j - 51), 0x66CCFF);
        mc.field_71466_p.func_211126_b("Height: " + height + "m", (float)(i - 92), (float)(j - 36), 0x66CCFF);
        mc.field_71466_p.func_211126_b("Range: " + range + "m", (float)(i - 92), (float)(j - 21), 0x66CCFF);
        String throttle = String.format("%.0f", Float.valueOf(TickHandler.rcEntity.power));
        String type = "N/A";
        int wCount = TickHandler.rcEntity.physicsWorld.getWeaponCount();
        if (rcEntity instanceof EntityF22 || rcEntity instanceof EntitySubmarine) {
            if (TickHandler.rcEntity.weaponsMode) {
                type = "";
                mc.field_71466_p.func_211126_b("Weapon Qty:", 13.0f, (float)(j - 21), 0x66CCFF);
                mc.field_71466_p.func_211126_b(wCount + "M", 75.0f, (float)(j - 21), 0x66CCFF);
            }
            if (wCount != 0 && TickHandler.rcEntity.weaponsMode) {
                mc.field_71466_p.func_211126_b("Armed", 55.0f, (float)(j - 36), 0xFF3333);
            } else if (TickHandler.rcEntity.weaponsMode && this.endTime - this.counter <= 500L) {
                mc.field_71466_p.func_211126_b("Loading", 55.0f, (float)(j - 36), 0xFFCC00);
            } else if (TickHandler.rcEntity.weaponsMode && this.endTime - this.counter > 1000L) {
                this.counter = this.endTime;
            } else if (!TickHandler.rcEntity.weaponsMode) {
                type = "";
                mc.field_71466_p.func_211126_b("Safe", 55.0f, (float)(j - 36), 0x66CC00);
            }
        }
        mc.field_71466_p.func_211126_b("Power: " + throttle + "%", 13.0f, (float)(j - 51), 0x66CCFF);
        mc.field_71466_p.func_211126_b("Weapon: " + type, 13.0f, (float)(j - 36), 0x66CCFF);
        GL11.glPopMatrix();
    }

    private void drawCrosshair(Minecraft mc, int i, int j) {
        int x = 8;
        int y = 8;
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationCrosshair);
        GL11.glTranslatef((float)((float)i / 2.0f + 0.5f), (float)((float)(j / 2) + 0.5f), (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-x), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-x), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void drawBattery(Minecraft mc, int i, int j) {
        float x = 16.0f;
        float y = 8.0f;
        float pScale = 1.0f;
        if (TickHandler.rcEntity.entityInventory.func_70301_a(2).func_77973_b() instanceof ItemBattery) {
            ItemBattery itemBattery = (ItemBattery)TickHandler.rcEntity.entityInventory.func_70301_a(2).func_77973_b();
            pScale = (float)itemBattery.getDurabilityForDisplay(TickHandler.rcEntity.entityInventory.func_70301_a(2));
        }
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationBattery);
        GL11.glTranslatef((float)((float)i - 121.0f), (float)((float)j - 12.0f), (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-x), (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)(-y), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-x), (double)(-y), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(this.textureLocationBatteryBar);
        GL11.glTranslatef((float)((float)i - 121.0f), (float)((float)j - 12.0f), (float)0.0f);
        if (pScale <= 0.5f) {
            GL11.glColor4f((float)0.0f, (float)0.9f, (float)0.1f, (float)0.5f);
        } else if (pScale <= 0.75f) {
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.0f, (float)0.5f);
        } else {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        }
        tessellator = Tessellator.func_178181_a();
        vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-x) + 3.75 + 25.5 * (double)pScale, (double)y, 0.0).func_187315_a((double)pScale * 0.796875 + 0.1171875, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x - 2.75, (double)y, 0.0).func_187315_a(0.9140625, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x - 2.75, (double)(-y), 0.0).func_187315_a(0.9140625, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-x) + 3.75 + 25.5 * (double)pScale, (double)(-y), 0.0).func_187315_a((double)pScale * 0.796875 + 0.1171875, 0.0).func_181675_d();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void drawChat(Minecraft mc, int i, int j) {
        GL11.glTranslatef((float)0.0f, (float)((float)j - 83.0f), (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71456_v.func_146158_b().func_146230_a(mc.field_71456_v.func_73834_c());
        GL11.glDisable((int)3042);
    }
}

