/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.utils;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import fr.mcnanotech.kevin_68.thespotlightmod.TheSpotLightMod;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumSaveCategory;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumTSMProperty;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.TSMKey;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketData;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketRegenerateFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;

public class TSMJsonManager {
    public static void generateNewFiles(int dimID, BlockPos pos) {
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + ".json");
        File fileTL = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + "_TL.json");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (file.exists()) {
            TSMJsonManager.deleteFile(dimID, pos);
        }
        if (fileTL.exists()) {
            TSMJsonManager.deleteFile(dimID, pos);
        }
        JsonObject json = new JsonObject();
        json.addProperty("DimID", (Number)dimID);
        json.addProperty("X", (Number)pos.func_177958_n());
        json.addProperty("Y", (Number)pos.func_177956_o());
        json.addProperty("Z", (Number)pos.func_177952_p());
        json.addProperty("ModeBeam", Boolean.valueOf(true));
        json.addProperty("Redstone", Boolean.valueOf(true));
        block9: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            List catPath = new ArrayList<String>();
            EnumSaveCategory cat = prop.saveCat;
            while (cat != null) {
                catPath.add(cat.saveName);
                cat = cat.parent;
            }
            catPath = Lists.reverse(catPath);
            JsonObject obj = json;
            for (String s : catPath) {
                if (!obj.has(s)) {
                    obj.add(s, (JsonElement)new JsonObject());
                }
                obj = obj.get(s).getAsJsonObject();
            }
            switch (prop.type) {
                case BOOLEAN: {
                    obj.addProperty(prop.saveName, (Boolean)prop.def);
                    continue block9;
                }
                case FLOAT: 
                case SHORT: {
                    obj.addProperty(prop.saveName, (Number)prop.def);
                    continue block9;
                }
                case STRING: {
                    obj.addProperty(prop.saveName, (String)prop.def);
                    continue block9;
                }
                default: {
                    System.out.println("Invalid or Missing type should not happen");
                }
            }
        }
        JsonObject timeline = new JsonObject();
        JsonObject calculated = new JsonObject();
        block12: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            if (!prop.timelinable || !prop.type.smoothable) continue;
            switch (prop.type) {
                case SHORT: {
                    Short[] emptyTabS = new Short[1200];
                    for (int i = 0; i < 1200; ++i) {
                        emptyTabS[i] = 0;
                    }
                    TSMJsonManager.getObjFromTabS(calculated, prop.saveNameTL, emptyTabS);
                    continue block12;
                }
                case FLOAT: {
                    Float[] emptyTabF = new Float[1200];
                    for (int i = 0; i < 1200; ++i) {
                        emptyTabF[i] = Float.valueOf(0.0f);
                    }
                    TSMJsonManager.getObjFromTabF(calculated, prop.saveNameTL, emptyTabF);
                    continue block12;
                }
                default: {
                    System.out.println("Again, missing or invalid type");
                }
            }
        }
        timeline.add("Calculated", (JsonElement)calculated);
        timeline.add("Keys", (JsonElement)TSMJsonManager.getJsonFromTSMKeys(new TSMKey[120]));
        TSMJsonManager.write(file, json);
        TSMJsonManager.write(fileTL, timeline);
    }

    public static void deleteFile(int dimID, BlockPos pos) {
        try {
            File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
            File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + ".json");
            File fileTL = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + "_TL.json");
            file.delete();
            fileTL.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean updateTileData(int dimID, BlockPos pos, TileEntitySpotLight tile) {
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + ".json");
        JsonObject json = TSMJsonManager.read(file);
        return TSMJsonManager.updateTileData(tile, json);
    }

    public static boolean updateTileData(TileEntitySpotLight tile, String data) {
        if (data.equals("null")) {
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonObject json = (JsonObject)parser.parse(data);
        return TSMJsonManager.updateTileData(tile, json);
    }

    private static boolean updateTileData(TileEntitySpotLight tile, JsonObject json) {
        try {
            if (json.has("ModeBeam")) {
                tile.isBeam = json.get("ModeBeam").getAsBoolean();
            }
            if (json.has("Redstone")) {
                tile.redstone = json.get("Redstone").getAsBoolean();
            }
            for (EnumTSMProperty prop : EnumTSMProperty.values()) {
                List parents = new ArrayList<EnumSaveCategory>();
                EnumSaveCategory current = prop.saveCat;
                while (current != null) {
                    parents.add(current);
                    current = current.parent;
                }
                parents = Lists.reverse(parents);
                JsonObject curJobj = json;
                for (EnumSaveCategory cat : parents) {
                    if (curJobj.has(cat.saveName)) {
                        curJobj = curJobj.get(cat.saveName).getAsJsonObject();
                        continue;
                    }
                    tile.setProperty(prop, prop.def);
                }
                if (curJobj.has(prop.saveName)) {
                    try {
                        switch (prop.type) {
                            case BOOLEAN: {
                                tile.setProperty(prop, curJobj.get(prop.saveName).getAsBoolean());
                                break;
                            }
                            case FLOAT: {
                                tile.setProperty(prop, Float.valueOf(curJobj.get(prop.saveName).getAsFloat()));
                                break;
                            }
                            case SHORT: {
                                tile.setProperty(prop, curJobj.get(prop.saveName).getAsShort());
                                break;
                            }
                            case STRING: {
                                tile.setProperty(prop, curJobj.get(prop.saveName).getAsString());
                                break;
                            }
                            default: {
                                System.out.println("And again another missing type");
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Invalid value in json for: " + prop.name() + " using default");
                        tile.setProperty(prop, prop.def);
                    }
                    continue;
                }
                tile.setProperty(prop, prop.def);
            }
            tile.markForUpdate();
            return true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            try {
                if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                    TSMJsonManager.deleteFile(tile.dimensionID, tile.func_174877_v());
                    TSMJsonManager.generateNewFiles(tile.dimensionID, tile.func_174877_v());
                } else {
                    TheSpotLightMod.network.sendToServer((IMessage)new PacketRegenerateFile(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), tile.dimensionID));
                }
            }
            catch (NullPointerException fatal) {
                fatal.printStackTrace();
                TheSpotLightMod.log.error("This should not happen");
            }
            return false;
        }
    }

    public static void updateJsonData(int dimID, BlockPos pos, String data) {
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + ".json");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        TSMJsonManager.write(file, data);
    }

    public static String getDataFromJson(int dimID, BlockPos pos) {
        JsonObject json;
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + ".json");
        if (!folder.exists()) {
            folder.mkdirs();
            TSMJsonManager.generateNewFiles(dimID, pos);
        }
        if ((json = TSMJsonManager.read(file)) != null) {
            return TSMJsonManager.read(file).toString();
        }
        return null;
    }

    public static JsonObject getDataFromTile(TileEntitySpotLight tile) {
        JsonObject json = new JsonObject();
        json.addProperty("DimID", (Number)tile.dimensionID);
        json.addProperty("X", (Number)tile.func_174877_v().func_177958_n());
        json.addProperty("Y", (Number)tile.func_174877_v().func_177956_o());
        json.addProperty("Z", (Number)tile.func_174877_v().func_177952_p());
        json.addProperty("ModeBeam", Boolean.valueOf(tile.isBeam));
        json.addProperty("Redstone", Boolean.valueOf(tile.redstone));
        block6: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            List catPath = new ArrayList<String>();
            EnumSaveCategory cat = prop.saveCat;
            while (cat != null) {
                catPath.add(cat.saveName);
                cat = cat.parent;
            }
            catPath = Lists.reverse(catPath);
            JsonObject obj = json;
            for (String s : catPath) {
                if (!obj.has(s)) {
                    obj.add(s, (JsonElement)new JsonObject());
                }
                obj = obj.get(s).getAsJsonObject();
            }
            switch (prop.type) {
                case BOOLEAN: {
                    obj.addProperty(prop.saveName, Boolean.valueOf(tile.getBoolean(prop)));
                    continue block6;
                }
                case FLOAT: {
                    obj.addProperty(prop.saveName, (Number)Float.valueOf(tile.getFloat(prop)));
                    continue block6;
                }
                case SHORT: {
                    obj.addProperty(prop.saveName, (Number)tile.getShort(prop));
                    continue block6;
                }
                case STRING: {
                    obj.addProperty(prop.saveName, tile.getString(prop));
                    continue block6;
                }
                default: {
                    System.out.println("Invalid or Missing type should not happen");
                }
            }
        }
        return json;
    }

    public static void saveConfig(ItemStack stack, TileEntitySpotLight tile) {
        String configName = String.valueOf(System.currentTimeMillis());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ConfigName", configName);
        stack.func_77982_d(tag);
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", "configs").getPath());
        File file = new File(folder, configName + ".json");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        JsonObject obj = TSMJsonManager.getDataFromTile(tile);
        obj.add("Timeline", (JsonElement)TSMJsonManager.getTlDataFromTile(tile));
        TSMJsonManager.write(file, obj);
    }

    public static void loadConfig(ItemStack stack, TileEntitySpotLight tile) {
        String configName = stack.func_77978_p().func_74779_i("ConfigName");
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", "configs").getPath());
        File file = new File(folder, configName + ".json");
        JsonObject json = TSMJsonManager.read(file);
        json.addProperty("DimID", (Number)tile.dimensionID);
        JsonObject obj = json.get("Timeline").getAsJsonObject();
        TSMJsonManager.updateTileData(tile, json);
        TSMJsonManager.updateTileTimeline(tile, obj);
        TheSpotLightMod.network.sendToAll((IMessage)new PacketData(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), TSMJsonManager.getDataFromTile(tile).toString()));
    }

    public static void deleteConfig(ItemStack stack) {
        String configName = stack.func_77978_p().func_74779_i("ConfigName");
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", "configs").getPath());
        File file = new File(folder, configName + ".json");
        file.delete();
    }

    public static boolean updateTileTimeline(int dimID, BlockPos pos, TileEntitySpotLight tile) {
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File fileTL = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + "_TL.json");
        JsonObject json = TSMJsonManager.read(fileTL);
        return TSMJsonManager.updateTileTimeline(tile, json);
    }

    public static boolean updateTileTimeline(TileEntitySpotLight tile, String data) {
        if (data.equals("null")) {
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonObject json = (JsonObject)parser.parse(data);
        return TSMJsonManager.updateTileTimeline(tile, json);
    }

    private static boolean updateTileTimeline(TileEntitySpotLight tile, JsonObject json) {
        try {
            JsonArray keys = json.get("Keys").getAsJsonArray();
            TSMJsonManager.getKeysFromObj(tile, keys);
            JsonObject calculated = (JsonObject)json.get("Calculated");
            block8: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
                if (!prop.timelinable || !prop.type.smoothable) continue;
                switch (prop.type) {
                    case SHORT: {
                        tile.setTimelineProperty(prop, TSMJsonManager.getTabFromObjS(calculated, prop.saveNameTL));
                        continue block8;
                    }
                    case FLOAT: {
                        tile.setTimelineProperty(prop, TSMJsonManager.getTabFromObjF(calculated, prop.saveNameTL));
                        continue block8;
                    }
                    default: {
                        System.out.println("Again, missing or invalid type");
                    }
                }
            }
            return true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            try {
                if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                    TSMJsonManager.deleteFile(json.get("DimID").getAsInt(), new BlockPos(json.get("X").getAsInt(), json.get("Y").getAsInt(), json.get("Z").getAsInt()));
                    TSMJsonManager.generateNewFiles(json.get("DimID").getAsInt(), new BlockPos(json.get("X").getAsInt(), json.get("Y").getAsInt(), json.get("Z").getAsInt()));
                } else {
                    TheSpotLightMod.network.sendToServer((IMessage)new PacketRegenerateFile(json.get("X").getAsInt(), json.get("Y").getAsInt(), json.get("Z").getAsInt(), json.get("DimID").getAsInt()));
                }
            }
            catch (NullPointerException fatal) {
                TheSpotLightMod.log.error("Missing an entry, please delete the file. If this happend when you where connected to a server please contact the server's operator");
            }
            return false;
        }
    }

    public static void updateTlJsonData(int dimID, BlockPos pos, String data) {
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + "_TL.json");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        TSMJsonManager.write(file, data);
    }

    public static String getTlDataFromJson(int dimID, BlockPos pos) {
        JsonObject json;
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), new File("SpotLights", String.valueOf(dimID)).getPath());
        File file = new File(folder, pos.func_177958_n() + "_" + pos.func_177956_o() + "_" + pos.func_177952_p() + "_TL.json");
        if (!folder.exists()) {
            folder.mkdirs();
            TSMJsonManager.generateNewFiles(dimID, pos);
        }
        if ((json = TSMJsonManager.read(file)) != null) {
            return TSMJsonManager.read(file).toString();
        }
        return null;
    }

    public static JsonObject getTlDataFromTile(TileEntitySpotLight tile) {
        JsonObject json = new JsonObject();
        JsonObject calculated = new JsonObject();
        block4: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            if (!prop.timelinable || !prop.type.smoothable) continue;
            switch (prop.type) {
                case SHORT: {
                    TSMJsonManager.getObjFromTabS(calculated, prop.saveNameTL, tile.getTimelineShort(prop));
                    continue block4;
                }
                case FLOAT: {
                    TSMJsonManager.getObjFromTabF(calculated, prop.saveNameTL, tile.getTimelineFloat(prop));
                    continue block4;
                }
                default: {
                    System.out.println("Again, missing or invalid type");
                }
            }
        }
        json.add("Calculated", (JsonElement)calculated);
        json.add("Keys", (JsonElement)TSMJsonManager.getJsonFromTSMKeys(tile.getKeys()));
        return json;
    }

    private static JsonArray getJsonFromTSMKeys(TSMKey[] keys) {
        JsonArray obj = new JsonArray();
        for (TSMKey key : keys) {
            if (key == null) continue;
            JsonObject o = new JsonObject();
            o.addProperty("Time", (Number)key.time);
            block7: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
                if (!prop.timelinable) continue;
                switch (prop.type) {
                    case BOOLEAN: {
                        o.addProperty(prop.saveNameTL, Boolean.valueOf(key.getB(prop)));
                        continue block7;
                    }
                    case FLOAT: {
                        o.addProperty(prop.saveNameTL, (Number)Float.valueOf(key.getF(prop)));
                        continue block7;
                    }
                    case SHORT: {
                        o.addProperty(prop.saveNameTL, (Number)key.getS(prop));
                        continue block7;
                    }
                    case STRING: {
                        o.addProperty(prop.saveNameTL, key.getStr(prop));
                        continue block7;
                    }
                    default: {
                        System.out.println("Yet another missing type");
                    }
                }
            }
            obj.add((JsonElement)o);
        }
        return obj;
    }

    private static void getKeysFromObj(TileEntitySpotLight tile, JsonArray keys) {
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject obj = keys.get(i).getAsJsonObject();
            HashMap<EnumTSMProperty, Object> properties = new HashMap<EnumTSMProperty, Object>();
            for (EnumTSMProperty prop : EnumTSMProperty.values()) {
                if (!prop.timelinable) continue;
                if (obj.has(prop.saveNameTL)) {
                    try {
                        switch (prop.type) {
                            case BOOLEAN: {
                                properties.put(prop, obj.get(prop.saveNameTL).getAsBoolean());
                                break;
                            }
                            case FLOAT: {
                                properties.put(prop, Float.valueOf(obj.get(prop.saveNameTL).getAsFloat()));
                                break;
                            }
                            case SHORT: {
                                properties.put(prop, obj.get(prop.saveNameTL).getAsShort());
                                break;
                            }
                            case STRING: {
                                properties.put(prop, obj.get(prop.saveNameTL).getAsString());
                                break;
                            }
                            default: {
                                System.out.println("Yet another missing type again");
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Invalid value in timeline json for: " + prop.name() + " using default");
                        properties.put(prop, prop.def);
                    }
                    continue;
                }
                properties.put(prop, prop.def);
            }
            TSMKey key = new TSMKey(obj.get("Time").getAsShort(), properties);
            tile.setKey(obj.get("Time").getAsShort(), key);
        }
    }

    private static void getObjFromTabS(JsonObject obj, String name, Short[] tab) {
        int i;
        String str = "";
        boolean sames = true;
        short prev = tab[0];
        for (i = 1; i < tab.length; ++i) {
            sames &= tab[i] == prev;
            prev = tab[i];
        }
        if (sames) {
            str = "" + tab[0];
            obj.addProperty(name, str);
        } else {
            for (i = 0; i < tab.length; ++i) {
                str = str + ":" + tab[i];
            }
            str = str.substring(1);
            obj.addProperty(name, str);
        }
    }

    private static void getObjFromTabF(JsonObject obj, String name, Float[] tab) {
        int i;
        String str = "";
        boolean sames = true;
        float prev = tab[0].floatValue();
        for (i = 1; i < tab.length; ++i) {
            sames &= tab[i].floatValue() == prev;
            prev = tab[i].floatValue();
        }
        if (sames) {
            str = "" + tab[0];
            obj.addProperty(name, str);
        } else {
            for (i = 0; i < tab.length; ++i) {
                str = str + ":" + (tab[i].floatValue() < 1.0f ? String.valueOf(tab[i]).replace("0.", "") : Float.valueOf(1.0f));
            }
            str = str.substring(1);
            obj.addProperty(name, str);
        }
    }

    private static Short[] getTabFromObjS(JsonObject calculated, String name) {
        String str = calculated.get(name).getAsString();
        Short[] tab = new Short[1200];
        if (str.contains(":")) {
            String[] strs = str.split(":");
            for (int i = 0; i < strs.length; ++i) {
                tab[i] = StringUtils.isNumeric((CharSequence)strs[i]) ? Short.valueOf(strs[i]) : Short.valueOf((short)0);
            }
            return tab;
        }
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = StringUtils.isNumeric((CharSequence)str) ? Short.valueOf(str) : (short)0;
        }
        return tab;
    }

    private static Float[] getTabFromObjF(JsonObject calculated, String name) {
        String decimalPattern = "([0-9]*)\\.([0-9]*)";
        String str = calculated.get(name).getAsString();
        Float[] tab = new Float[1200];
        if (str.contains(":")) {
            String[] strs = str.split(":");
            for (int i = 0; i < strs.length; ++i) {
                tab[i] = Pattern.matches(decimalPattern, strs[i]) ? Float.valueOf(strs[i]) : (StringUtils.isNumeric((CharSequence)strs[i]) ? Float.valueOf("0." + strs[i]) : Float.valueOf(0.0f));
            }
            return tab;
        }
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = Float.valueOf(Pattern.matches(decimalPattern, str) ? Float.valueOf(str).floatValue() : 0.0f);
        }
        return tab;
    }

    private static void write(File dir, JsonObject obj) {
        TSMJsonManager.write(dir, obj.toString());
    }

    private static void write(File dir, String obj) {
        try {
            JsonParser parser = new JsonParser();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonElement el = parser.parse(obj);
            String jsonString = gson.toJson(el);
            FileWriter file = new FileWriter(dir);
            file.write(jsonString);
            file.flush();
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static JsonObject read(File dir) {
        JsonParser parser = new JsonParser();
        try {
            JsonElement json = parser.parse((Reader)new FileReader(dir));
            if (json.isJsonNull()) {
                return null;
            }
            return json.getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            TSMJsonManager.generateNewFiles(Integer.valueOf(new File(dir.getParent()).getName()), new BlockPos(Integer.valueOf(dir.getName().replace(".json", "").split("_")[0]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[1]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[2]).intValue()));
        }
        catch (JsonParseException e) {
            TheSpotLightMod.log.error("File is not a JSON, generating a new one");
            TSMJsonManager.deleteFile(Integer.valueOf(new File(dir.getParent()).getName()), new BlockPos(Integer.valueOf(dir.getName().replace(".json", "").split("_")[0]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[1]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[2]).intValue()));
            TSMJsonManager.generateNewFiles(Integer.valueOf(new File(dir.getParent()).getName()), new BlockPos(Integer.valueOf(dir.getName().replace(".json", "").split("_")[0]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[1]).intValue(), Integer.valueOf(dir.getName().replace(".json", "").split("_")[2]).intValue()));
        }
        return null;
    }

    public static String compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        String outStr = out.toString("ISO-8859-1");
        return outStr;
    }

    public static String decompress(String str) throws IOException {
        String line;
        if (str == null || str.length() == 0) {
            return str;
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(str.getBytes("ISO-8859-1")));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "ISO-8859-1"));
        String outStr = "";
        while ((line = bf.readLine()) != null) {
            outStr = outStr + line;
        }
        return outStr;
    }

    public static HashMap<Integer, List<JsonObject>> getAll() {
        return null;
    }
}

