/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod;

import fr.mcnanotech.kevin_68.thespotlightmod.TSMNetwork;
import fr.mcnanotech.kevin_68.thespotlightmod.TSMObjects;
import fr.mcnanotech.kevin_68.thespotlightmod.TheSpotLightMod;
import fr.mcnanotech.kevin_68.thespotlightmod.container.ContainerSpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumPropVecBehaviour;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumTSMProperty;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumTSMType;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.BeamVec;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.TSMKey;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.TSMVec3;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketRequestData;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketRequestTLData;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketTLData;
import fr.mcnanotech.kevin_68.thespotlightmod.utils.TSMJsonManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.Level;

public class TileEntitySpotLight
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public boolean updated = false;
    public boolean updating = false;
    public boolean timelineUpdated = false;
    public boolean timelineUpdating = false;
    public boolean isActive;
    public boolean isBeam;
    public boolean helpMode;
    public boolean redstone;
    public boolean locked;
    public UUID lockerUUID;
    private ITextComponent customName;
    private Map<EnumTSMProperty, Object> properties = this.initProperties();
    private Map<EnumTSMProperty, Object[]> timelineProperties = this.initTimeLineProperties();
    private Map<EnumTSMProperty, Object> previousProperties = this.initPrevProperties();
    public short time;
    public boolean timelineEnabled;
    public boolean timelineSmooth;
    private TSMKey[] tsmKeys = new TSMKey[120];
    public BeamVec[] bVec = null;
    public List<BeamVec[]> beams = new ArrayList<BeamVec[]>();

    public TileEntitySpotLight() {
        this(TSMObjects.TILE_TSM);
    }

    public TileEntitySpotLight(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void setKey(short keyTime, TSMKey key) {
        this.tsmKeys[keyTime] = key;
        if (!this.field_145850_b.field_72995_K) {
            this.processTimelineValues();
        }
        this.markForUpdate();
    }

    public TSMKey getKey(short keyTime) {
        return this.tsmKeys[keyTime];
    }

    public TSMKey[] getKeys() {
        return this.tsmKeys;
    }

    public boolean hasKey() {
        for (int i = 0; i < this.tsmKeys.length; ++i) {
            if (this.tsmKeys[i] == null) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        try {
            if (!this.updated) {
                if (!this.field_145850_b.field_72995_K) {
                    this.updated = TSMJsonManager.updateTileData(this.field_174879_c, this);
                } else if (!this.updating) {
                    this.updating = true;
                    TSMNetwork.CHANNEL.sendToServer((Object)new PacketRequestData(this.field_174879_c));
                }
            }
            if (!this.timelineUpdated) {
                if (!this.field_145850_b.field_72995_K) {
                    this.timelineUpdated = TSMJsonManager.updateTileTimeline((ServerWorld)this.field_145850_b, this.field_174879_c, this);
                } else if (!this.timelineUpdating) {
                    this.timelineUpdating = true;
                    TSMNetwork.CHANNEL.sendToServer((Object)new PacketRequestTLData(this.field_174879_c));
                }
            }
            if (this.field_145850_b.func_175640_z(this.field_174879_c) || !this.redstone) {
                if (this.field_145850_b.field_72995_K) {
                    this.isActive = true;
                    if (this.bVec != null) {
                        boolean flag = false;
                        block12: for (Map.Entry<EnumTSMProperty, Object> ent : this.properties.entrySet()) {
                            switch (ent.getKey().vecBehaviour) {
                                case NONE: {
                                    continue block12;
                                }
                                case WHEN_ACTIVE: {
                                    if (!this.getBoolean(ent.getKey())) continue block12;
                                    flag = true;
                                    break block12;
                                }
                                case VALUE_CHANGED: {
                                    if (this.previousProperties.get((Object)ent.getKey()).equals(ent.getValue())) continue block12;
                                    flag = true;
                                    break block12;
                                }
                                default: {
                                    System.out.println("???? someone added an enum, this is not good");
                                    continue block12;
                                }
                            }
                        }
                        if (flag) {
                            block13: for (Map.Entry<EnumTSMProperty, Object> ent : this.properties.entrySet()) {
                                if (ent.getKey().vecBehaviour == EnumPropVecBehaviour.NONE) continue;
                                switch (ent.getKey().type) {
                                    case FLOAT: {
                                        this.previousProperties.put(ent.getKey(), Float.valueOf(((Float)this.properties.get((Object)ent.getKey())).floatValue()));
                                        continue block13;
                                    }
                                    case SHORT: {
                                        this.previousProperties.put(ent.getKey(), ((Number)this.properties.get((Object)ent.getKey())).shortValue());
                                        continue block13;
                                    }
                                    case BOOLEAN: {
                                        this.previousProperties.put(ent.getKey(), (boolean)((Boolean)this.properties.get((Object)ent.getKey())));
                                        continue block13;
                                    }
                                }
                                System.out.println("Invalid type");
                            }
                            this.bVec = this.process();
                        }
                    } else {
                        this.bVec = this.process();
                    }
                }
                if (this.timelineEnabled) {
                    this.runTimeLine();
                }
            } else {
                this.isActive = false;
            }
        }
        catch (Exception e) {
            TheSpotLightMod.LOGGER.warn("Failed to tick");
            TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
        }
    }

    public void markForUpdate() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    private void runTimeLine() {
        block19: {
            block20: {
                this.time = this.time == 1199 ? (short)0 : (short)(this.time + 1);
                if (!this.field_145850_b.field_72995_K) break block19;
                if (!this.timelineSmooth) break block20;
                TSMKey k = this.tsmKeys[(this.time - this.time % 10) / 10];
                block16: for (Map.Entry<EnumTSMProperty, Object> ent : this.properties.entrySet()) {
                    if (!ent.getKey().timelinable) continue;
                    if (ent.getKey().type.smoothable) {
                        switch (ent.getKey().type) {
                            case FLOAT: {
                                this.properties.put(ent.getKey(), Float.valueOf(((Float)this.timelineProperties.get((Object)ent.getKey())[this.time]).floatValue()));
                                continue block16;
                            }
                            case SHORT: {
                                this.properties.put(ent.getKey(), ((Number)this.timelineProperties.get((Object)ent.getKey())[this.time]).shortValue());
                                continue block16;
                            }
                        }
                        System.out.println("Invalid type");
                        continue;
                    }
                    if (k == null) continue;
                    switch (ent.getKey().type) {
                        case FLOAT: {
                            this.properties.put(ent.getKey(), Float.valueOf(k.getF(ent.getKey())));
                            break;
                        }
                        case SHORT: {
                            this.properties.put(ent.getKey(), k.getS(ent.getKey()));
                            break;
                        }
                        case BOOLEAN: {
                            this.properties.put(ent.getKey(), k.getB(ent.getKey()));
                            break;
                        }
                        case STRING: {
                            this.properties.put(ent.getKey(), k.getStr(ent.getKey()));
                        }
                    }
                }
                break block19;
            }
            TSMKey k = this.tsmKeys[(this.time - this.time % 10) / 10];
            if (k == null) break block19;
            for (Map.Entry<EnumTSMProperty, Object> ent : this.properties.entrySet()) {
                if (!ent.getKey().timelinable) continue;
                switch (ent.getKey().type) {
                    case FLOAT: {
                        this.properties.put(ent.getKey(), Float.valueOf(k.getF(ent.getKey())));
                        break;
                    }
                    case SHORT: {
                        this.properties.put(ent.getKey(), k.getS(ent.getKey()));
                        break;
                    }
                    case BOOLEAN: {
                        this.properties.put(ent.getKey(), k.getB(ent.getKey()));
                        break;
                    }
                    case STRING: {
                        this.properties.put(ent.getKey(), k.getStr(ent.getKey()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processTimelineValues() {
        ArrayList<Integer> keysTime = new ArrayList<Integer>();
        ArrayList<Integer> timeBetwinKeys = new ArrayList<Integer>();
        for (int i = 0; i < this.tsmKeys.length; ++i) {
            TSMKey entry = this.tsmKeys[i];
            if (entry == null) continue;
            keysTime.add(i * 10);
        }
        if (!keysTime.isEmpty() && keysTime.size() > 1) {
            for (int j = 0; j < keysTime.size() - 1; ++j) {
                timeBetwinKeys.add((Integer)keysTime.get(j + 1) - (Integer)keysTime.get(j));
            }
            timeBetwinKeys.add(1200 - (Integer)keysTime.get(keysTime.size() - 1) + (Integer)keysTime.get(0));
            for (int k = 0; k < keysTime.size() - 1; ++k) {
                TSMKey start = this.tsmKeys[((Integer)keysTime.get(k) - (Integer)keysTime.get(k) % 10) / 10];
                TSMKey end = this.tsmKeys[((Integer)keysTime.get(k + 1) - (Integer)keysTime.get(k + 1) % 10) / 10];
                for (Map.Entry<EnumTSMProperty, Object[]> ent : this.timelineProperties.entrySet()) {
                    if (!ent.getKey().timelinable || !ent.getKey().type.smoothable) continue;
                    Number[] values = null;
                    switch (ent.getKey().type) {
                        case SHORT: {
                            values = this.calculateValuesS((Short[])ent.getValue(), start.getS(ent.getKey()), end.getS(ent.getKey()), (Integer)keysTime.get(k), (Integer)timeBetwinKeys.get(k), false);
                            break;
                        }
                        case FLOAT: {
                            values = this.calculateValuesF((Float[])ent.getValue(), start.getF(ent.getKey()), end.getF(ent.getKey()), (Integer)keysTime.get(k), (Integer)timeBetwinKeys.get(k), false);
                            break;
                        }
                        default: {
                            System.out.println("Someone forgot a type, please contact the author and copy/paste this line: " + ent.getKey().type.name());
                        }
                    }
                    this.timelineProperties.put(ent.getKey(), values);
                }
            }
            TSMKey start = this.tsmKeys[((Integer)keysTime.get(keysTime.size() - 1) - (Integer)keysTime.get(keysTime.size() - 1) % 10) / 10];
            TSMKey end = this.tsmKeys[((Integer)keysTime.get(0) - (Integer)keysTime.get(0) % 10) / 10];
            for (Map.Entry entry : this.timelineProperties.entrySet()) {
                if (!((EnumTSMProperty)((Object)entry.getKey())).timelinable || !((EnumTSMProperty)((Object)entry.getKey())).type.smoothable) continue;
                Number[] values = null;
                switch (((EnumTSMProperty)((Object)entry.getKey())).type) {
                    case SHORT: {
                        values = this.calculateValuesS((Short[])entry.getValue(), start.getS((EnumTSMProperty)((Object)entry.getKey())), end.getS((EnumTSMProperty)((Object)entry.getKey())), (Integer)keysTime.get(keysTime.size() - 1), (Integer)timeBetwinKeys.get(keysTime.size() - 1), true);
                        break;
                    }
                    case FLOAT: {
                        values = this.calculateValuesF((Float[])entry.getValue(), start.getF((EnumTSMProperty)((Object)entry.getKey())), end.getF((EnumTSMProperty)((Object)entry.getKey())), (Integer)keysTime.get(keysTime.size() - 1), (Integer)timeBetwinKeys.get(keysTime.size() - 1), true);
                        break;
                    }
                    default: {
                        System.out.println("(1) Someone forgot a type, please contact the author and copy/paste this line: " + ((EnumTSMProperty)((Object)entry.getKey())).type.name());
                    }
                }
                this.timelineProperties.put((EnumTSMProperty)((Object)entry.getKey()), values);
            }
        } else if (keysTime.size() == 1) {
            block19: for (Map.Entry<EnumTSMProperty, Object[]> ent : this.timelineProperties.entrySet()) {
                if (!ent.getKey().timelinable || !ent.getKey().type.smoothable) continue;
                switch (ent.getKey().type) {
                    case SHORT: {
                        void var6_15;
                        Short[] valS = new Short[1200];
                        boolean bl = false;
                        while (var6_15 < 1200) {
                            valS[var6_15] = this.getShort(ent.getKey());
                            ++var6_15;
                        }
                        this.timelineProperties.put(ent.getKey(), valS);
                        continue block19;
                    }
                    case FLOAT: {
                        Float[] floatArray = new Float[1200];
                        for (int i = 0; i < 1200; ++i) {
                            floatArray[i] = Float.valueOf(this.getFloat(ent.getKey()));
                        }
                        this.timelineProperties.put(ent.getKey(), floatArray);
                        continue block19;
                    }
                }
                System.out.println("(2) Someone forgot a type, please contact the author and copy/paste this line: " + ent.getKey().type.name());
            }
        }
        String strData = TSMJsonManager.getTlDataFromTile(this).toString();
        TSMJsonManager.updateTlJsonData((ServerWorld)this.field_145850_b, this.field_174879_c, strData);
        try {
            TSMNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PacketTLData(this.field_174879_c, TSMJsonManager.compress(strData)));
        }
        catch (IOException e) {
            TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
        }
    }

    private Short[] calculateValuesS(Short[] tab, short valStart, short valEnd, int timeStart, int timeLenght, boolean last) {
        float perTick = (float)(valEnd - valStart) / (float)timeLenght;
        if (!last) {
            for (int l = timeStart; l < timeStart + timeLenght; ++l) {
                tab[l] = (short)((float)valStart + perTick * (float)(l - timeStart));
            }
        } else {
            for (int m = timeStart; m < 1200; ++m) {
                tab[m] = (short)((float)valStart + perTick * (float)(m - timeStart));
            }
            int firstKeyTime = timeStart + timeLenght - 1200;
            for (int n = 0; n < firstKeyTime; ++n) {
                tab[n] = (short)((float)tab[1199].shortValue() + perTick * (float)n);
            }
        }
        return tab;
    }

    private Float[] calculateValuesF(Float[] tab, float valStart, float valEnd, int timeStart, int timeLenght, boolean last) {
        float perTick = (valEnd - valStart) / (float)timeLenght;
        if (!last) {
            for (int l = timeStart; l < timeStart + timeLenght; ++l) {
                tab[l] = Float.valueOf((float)((int)((valStart + perTick * (float)(l - timeStart)) * 1000.0f)) / 1000.0f);
            }
        } else {
            for (int m = timeStart; m < 1200; ++m) {
                tab[m] = Float.valueOf((float)((int)((valStart + perTick * (float)(m - timeStart)) * 1000.0f)) / 1000.0f);
            }
            int firstKeyTime = timeStart + timeLenght - 1200;
            for (int n = 0; n < firstKeyTime; ++n) {
                tab[n] = Float.valueOf((float)((int)((tab[1199].floatValue() + perTick * (float)n) * 1000.0f)) / 1000.0f);
            }
        }
        return tab;
    }

    private BeamVec[] process() {
        float angleY;
        float angleX;
        double[] sizes = new double[]{Math.sqrt(Math.pow((double)this.getShort(EnumTSMProperty.BEAM_SIZE) / 200.0, 2.0) / 2.0), Math.sqrt(Math.pow((double)this.getShort(EnumTSMProperty.BEAM_SEC_SIZE) / 200.0, 2.0) / 2.0)};
        float timer = (float)this.func_145831_w().func_82737_E() * 0.00125f;
        float f = this.getBoolean(EnumTSMProperty.BEAM_R_AUTO_X) ? timer * (float)this.getShort(EnumTSMProperty.BEAM_R_SPEED_X) * (this.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_X) ? -1.0f : 1.0f) : (angleX = (float)Math.toRadians(this.getShort(EnumTSMProperty.BEAM_ANGLE_X)));
        float f2 = this.getBoolean(EnumTSMProperty.BEAM_R_AUTO_Y) ? timer * (float)this.getShort(EnumTSMProperty.BEAM_R_SPEED_Y) * (this.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_Y) ? -1.0f : 1.0f) : (angleY = (float)Math.toRadians(this.getShort(EnumTSMProperty.BEAM_ANGLE_Y)));
        float angleZ = this.getBoolean(EnumTSMProperty.BEAM_R_AUTO_Z) ? timer * (float)this.getShort(EnumTSMProperty.BEAM_R_SPEED_Z) * (this.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_Z) ? -1.0f : 1.0f) : (float)Math.toRadians(this.getShort(EnumTSMProperty.BEAM_ANGLE_Z));
        BeamVec[] vecs = new BeamVec[4];
        for (int j = 0; j < 4; ++j) {
            TSMVec3[] v = new TSMVec3[this.getShort(EnumTSMProperty.BEAM_SIDE) + 2];
            TSMVec3 e = null;
            double angle = Math.PI * 2 / (double)(this.getShort(EnumTSMProperty.BEAM_SIDE) + 2);
            for (int i = 0; i < this.getShort(EnumTSMProperty.BEAM_SIDE) + 2; ++i) {
                v[i] = new TSMVec3(Math.sqrt(2.0 * Math.pow(sizes[j / 2], 2.0)) * Math.cos(angle * (double)i + Math.PI / (double)(this.getShort(EnumTSMProperty.BEAM_SIDE) + 2)), 0.0, Math.sqrt(2.0 * Math.pow(sizes[j / 2], 2.0)) * Math.sin(angle * (double)i + Math.PI / (double)(this.getShort(EnumTSMProperty.BEAM_SIDE) + 2)));
                v[i].rotateAroundX(angleX);
                v[i].rotateAroundY(angleY);
                v[i].rotateAroundZ(angleZ);
            }
            e = new TSMVec3(0.0, (j % 2 == 0 ? 1 : -1) * this.getShort(EnumTSMProperty.BEAM_HEIGHT), 0.0);
            e.rotateAroundX(angleX);
            e.rotateAroundY(angleY);
            e.rotateAroundZ(angleZ);
            vecs[j] = new BeamVec(v, e);
        }
        return vecs;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 786432.0;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("Time", this.time);
        compound.func_74757_a("TimelineEnabled", this.timelineEnabled);
        compound.func_74757_a("TimelineSmooth", this.timelineSmooth);
        compound.func_74757_a("Locked", this.locked);
        if (this.lockerUUID != null) {
            compound.func_186854_a("LockerUUID", this.lockerUUID);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.slots);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.time = compound.func_74765_d("Time");
        this.timelineEnabled = compound.func_74767_n("TimelineEnabled");
        this.timelineSmooth = compound.func_74767_n("TimelineSmooth");
        this.locked = compound.func_74767_n("Locked");
        if (compound.func_150297_b("LockerUUID", 8)) {
            this.lockerUUID = UUID.fromString(compound.func_74779_i("LockerUUID"));
        }
        if (compound.func_186855_b("LockerUUID")) {
            this.lockerUUID = compound.func_186857_a("LockerUUID");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.slots);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.slots, (int)index, (int)amount);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.slots, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.slots.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_174889_b(PlayerEntity playerIn) {
    }

    public void func_174886_c(PlayerEntity playerIn) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent("container.spotlight", new Object[0]);
    }

    public void craftConfig() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (!this.func_70301_a(0).func_190926_b() && this.func_70301_a(1).func_190926_b()) {
                this.func_70298_a(0, 1);
                stack = new ItemStack((IItemProvider)TSMObjects.CONFIG_SAVER_FULL);
                TSMJsonManager.saveConfig(stack, this);
                this.func_70299_a(1, stack);
            }
            if (!this.func_70301_a(2).func_190926_b() && this.func_70301_a(3).func_190926_b()) {
                stack = this.func_70301_a(2).func_77946_l();
                this.func_70298_a(2, 1);
                TSMJsonManager.loadConfig(stack, this);
                this.func_70299_a(3, stack);
            }
            if (!this.func_70301_a(4).func_190926_b() && this.func_70301_a(5).func_190926_b()) {
                TSMJsonManager.deleteConfig(this.func_70301_a(4));
                this.func_70298_a(4, 1);
                stack = new ItemStack((IItemProvider)TSMObjects.CONFIG_SAVER);
                this.func_70299_a(5, stack);
            }
        }
        this.markForUpdate();
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.slots) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private Map<EnumTSMProperty, Object> initProperties() {
        HashMap<EnumTSMProperty, Object> map = new HashMap<EnumTSMProperty, Object>();
        for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            map.put(prop, prop.def);
        }
        return map;
    }

    private Map<EnumTSMProperty, Object[]> initTimeLineProperties() {
        HashMap<EnumTSMProperty, Object[]> map = new HashMap<EnumTSMProperty, Object[]>();
        block4: for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            if (!prop.timelinable || !prop.type.smoothable) continue;
            switch (prop.type) {
                case SHORT: {
                    Short[] emptyTabS = new Short[1200];
                    for (int i = 0; i < 1200; ++i) {
                        emptyTabS[i] = 0;
                    }
                    map.put(prop, emptyTabS);
                    continue block4;
                }
                case FLOAT: {
                    Float[] emptyTabF = new Float[1200];
                    for (int i = 0; i < 1200; ++i) {
                        emptyTabF[i] = Float.valueOf(0.0f);
                    }
                    map.put(prop, emptyTabF);
                    continue block4;
                }
                default: {
                    System.out.println("Invalid type");
                }
            }
        }
        return map;
    }

    private Map<EnumTSMProperty, Object> initPrevProperties() {
        HashMap<EnumTSMProperty, Object> map = new HashMap<EnumTSMProperty, Object>();
        for (EnumTSMProperty prop : EnumTSMProperty.values()) {
            if (prop.vecBehaviour == EnumPropVecBehaviour.NONE) continue;
            map.put(prop, prop.def);
        }
        return map;
    }

    public void setProperty(EnumTSMProperty prop, Object obj) {
        this.properties.put(prop, obj);
    }

    public void setTimelineProperty(EnumTSMProperty prop, Object[] objs) {
        if (objs.length == 1200) {
            this.timelineProperties.put(prop, objs);
        } else {
            System.out.println("Invalid timeline array size: " + objs.length + "/1200");
        }
    }

    public Map<EnumTSMProperty, Object> cloneProperties() {
        HashMap<EnumTSMProperty, Object> copy = new HashMap<EnumTSMProperty, Object>();
        for (Map.Entry<EnumTSMProperty, Object> ent : this.properties.entrySet()) {
            copy.put(ent.getKey(), ent.getValue());
        }
        return copy;
    }

    public short getShort(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.SHORT) {
            return ((Number)this.properties.get((Object)prop)).shortValue();
        }
        System.out.println("Invalid use for property: " + prop.name());
        return 0;
    }

    public float getFloat(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.FLOAT) {
            return ((Float)this.properties.get((Object)prop)).floatValue();
        }
        System.out.println("Invalid use for property: " + prop.name());
        return 0.0f;
    }

    public boolean getBoolean(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.BOOLEAN) {
            return (Boolean)this.properties.get((Object)prop);
        }
        System.out.println("Invalid use for property: " + prop.name());
        return false;
    }

    public String getString(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.STRING) {
            return ((String)this.properties.get((Object)prop)).substring(0);
        }
        System.out.println("Invalid use for property: " + prop.name());
        return null;
    }

    public Short[] getTimelineShort(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.SHORT && prop.timelinable && prop.type.smoothable) {
            return (Short[])this.timelineProperties.get((Object)prop);
        }
        System.out.println("Invalid use for timeline property: " + prop.name());
        return null;
    }

    public Float[] getTimelineFloat(EnumTSMProperty prop) {
        if (prop.type == EnumTSMType.FLOAT && prop.timelinable && prop.type.smoothable) {
            return (Float[])this.timelineProperties.get((Object)prop);
        }
        System.out.println("Invalid use for timeline property: " + prop.name());
        return null;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity Playerentity) {
        return new ContainerSpotLight(windowId, playerInventory, this);
    }
}

