/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.client;

import com.mojang.blaze3d.platform.GlStateManager;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.client.ModelSpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.client.text3d.Model3DTextDefault;
import fr.mcnanotech.kevin_68.thespotlightmod.client.text3d.Text3D;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumTSMProperty;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.BeamVec;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.TSMVec3;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySpotLightRender
extends TileEntityRenderer<TileEntitySpotLight> {
    private ModelSpotLight model = new ModelSpotLight();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thespotlightmod", "textures/block/spotlight.png");
    private static final ResourceLocation DEFAULT_BEAM = new ResourceLocation("textures/entity/beacon_beam.png");
    private static final Text3D TXT3D = new Text3D(Model3DTextDefault.instance);

    public void render(TileEntitySpotLight tile, double x, double y, double z, float partialTick, int destroyStage) {
        float renderTick = (float)tile.func_145831_w().func_82737_E() + partialTick;
        float timer = (float)this.func_178459_a().func_82737_E() * 0.00125f;
        float angleX = this.getAngleValue(tile, timer, EnumTSMProperty.BEAM_R_AUTO_X, EnumTSMProperty.BEAM_R_SPEED_X, EnumTSMProperty.BEAM_R_REVERSE_X, EnumTSMProperty.BEAM_ANGLE_X);
        float angleY = this.getAngleValue(tile, timer, EnumTSMProperty.BEAM_R_AUTO_Y, EnumTSMProperty.BEAM_R_SPEED_Y, EnumTSMProperty.BEAM_R_REVERSE_Y, EnumTSMProperty.BEAM_ANGLE_Y);
        float angleZ = this.getAngleValue(tile, timer, EnumTSMProperty.BEAM_R_AUTO_Z, EnumTSMProperty.BEAM_R_SPEED_Z, EnumTSMProperty.BEAM_R_REVERSE_Z, EnumTSMProperty.BEAM_ANGLE_Z);
        if (!tile.isBeam) {
            angleX = 0.0f;
            angleY = this.getAngleValue(tile, timer, EnumTSMProperty.TEXT_R_AUTO_Y, EnumTSMProperty.TEXT_R_SPEED_Y, EnumTSMProperty.TEXT_R_REVERSE_Y, EnumTSMProperty.TEXT_ANGLE_Y);
            angleZ = 0.0f;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        this.func_147499_a(TEXTURE);
        this.model.setRotation(-angleX, angleY, -angleZ);
        GlStateManager.scaled((double)1.2f, (double)1.2f, (double)1.2f);
        this.model.render(0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.disableFog();
        if (tile.isActive) {
            if (tile.isBeam) {
                this.renderBeam(tile, x, y, z, renderTick);
            } else {
                this.renderText(tile, x, y, z, angleY);
            }
        }
        GlStateManager.enableFog();
        GlStateManager.alphaFunc((int)516, (float)0.5f);
    }

    public boolean isGlobalRenderer(TileEntitySpotLight tile) {
        return true;
    }

    private float getAngleValue(TileEntitySpotLight tile, float timer, EnumTSMProperty auto, EnumTSMProperty speed, EnumTSMProperty reverse, EnumTSMProperty angle) {
        if (tile.getBoolean(auto)) {
            return timer * (float)tile.getShort(speed) * (tile.getBoolean(reverse) ? -1.0f : 1.0f);
        }
        return (float)Math.toRadians(tile.getShort(angle));
    }

    private void renderBeam(TileEntitySpotLight tile, double x, double y, double z, float renderTick) {
        ItemStack s2;
        Tessellator tess = Tessellator.func_178181_a();
        ItemStack s = tile.func_70301_a(6);
        if (!s.func_190926_b()) {
            this.func_147499_a(this.getResourceLocationStack(s) != null ? this.getResourceLocationStack(s) : MissingTextureSprite.func_195675_b());
        } else {
            this.func_147499_a(DEFAULT_BEAM);
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float f3 = -renderTick * 0.2f - (float)MathHelper.func_76141_d((float)(-renderTick * 0.1f));
        double t2 = -1.0f - f3 * (tile.getFloat(EnumTSMProperty.BEAM_SPEED) - 2.0f);
        double t3 = tile.bVec[0].getLenVec().norm() * (0.5 / Math.sqrt(Math.pow((double)tile.getShort(EnumTSMProperty.BEAM_SIZE) / 200.0, 2.0) / 2.0)) + t2;
        double t4 = tile.bVec[1].getLenVec().norm() * (0.5 / Math.sqrt(Math.pow((double)tile.getShort(EnumTSMProperty.BEAM_SIZE) / 200.0, 2.0) / 2.0)) + t2;
        float r = (float)tile.getShort(EnumTSMProperty.BEAM_RED) / 255.0f;
        float g = (float)tile.getShort(EnumTSMProperty.BEAM_GREEN) / 255.0f;
        float b = (float)tile.getShort(EnumTSMProperty.BEAM_BLUE) / 255.0f;
        float a = tile.getFloat(EnumTSMProperty.BEAM_ALPHA);
        if (a < 0.8f) {
            GlStateManager.depthMask((boolean)false);
        } else {
            GlStateManager.depthMask((boolean)true);
        }
        this.drawBeam(tess, x, y, z, t2, t3, tile.bVec[0], r, g, b, a);
        if (tile.getBoolean(EnumTSMProperty.BEAM_DOUBLE)) {
            this.drawBeam(tess, x, y, z, t2, t4, tile.bVec[1], r, g, b, a);
        }
        if (!(s2 = tile.func_70301_a(7)).func_190926_b()) {
            this.func_147499_a(this.getResourceLocationStack(s2) != null ? this.getResourceLocationStack(s2) : MissingTextureSprite.func_195675_b());
        } else {
            this.func_147499_a(DEFAULT_BEAM);
        }
        if (tile.getBoolean(EnumTSMProperty.BEAM_SEC_ENABLED)) {
            float sR = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_RED) / 255.0f;
            float sG = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_GREEN) / 255.0f;
            float sB = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_BLUE) / 255.0f;
            float sA = tile.getFloat(EnumTSMProperty.BEAM_SEC_ALPHA);
            if (sA < 0.8f) {
                GlStateManager.depthMask((boolean)false);
            } else {
                GlStateManager.depthMask((boolean)true);
            }
            this.drawBeam(tess, x, y, z, t2, t3, tile.bVec[2], sR, sG, sB, sA);
            if (tile.getBoolean(EnumTSMProperty.BEAM_DOUBLE)) {
                this.drawBeam(tess, x, y, z, t2, t4, tile.bVec[3], sR, sG, sB, sA);
            }
        }
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    private void renderText(TileEntitySpotLight tile, double x, double y, double z, float angleY) {
        GL11.glPushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        short tscale = tile.getShort(EnumTSMProperty.TEXT_SCALE);
        if (tile.getBoolean(EnumTSMProperty.TEXT_3D)) {
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)-0.2f, (float)0.0f);
            GlStateManager.rotatef((float)((float)Math.toDegrees(angleY)), (float)0.0f, (float)1.0f, (float)0.0f);
            float f21 = 0.011111112f;
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f21));
            GlStateManager.translatef((float)0.0f, (float)((float)(8 + tile.getShort(EnumTSMProperty.TEXT_HEIGHT)) / 10.0f), (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)(((float)tscale * 0.8f + 1.0f) / 30.0f), (float)0.0f);
            if (tile.getShort(EnumTSMProperty.TEXT_HEIGHT) < 0) {
                GlStateManager.translatef((float)0.0f, (float)(-(26.0f + (float)tscale * 0.45f) / 20.0f), (float)0.0f);
            }
            GlStateManager.scaled((double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)));
            GlStateManager.disableLighting();
            TXT3D.renderTextAlignedCenter(tile.getBoolean(EnumTSMProperty.TEXT_TRANSLATING) ? this.getTranslatingText(tile.getString(EnumTSMProperty.TEXT), tile) : tile.getString(EnumTSMProperty.TEXT), (float)tile.getShort(EnumTSMProperty.TEXT_RED) / 255.0f, (float)tile.getShort(EnumTSMProperty.TEXT_GREEN) / 255.0f, (float)tile.getShort(EnumTSMProperty.TEXT_BLUE) / 255.0f);
            GlStateManager.enableLighting();
        } else {
            GlStateManager.scaled((double)0.9, (double)0.9, (double)0.9);
            GlStateManager.rotatef((float)((float)Math.toDegrees(angleY)), (float)0.0f, (float)1.0f, (float)0.0f);
            FontRenderer fontRenderer = this.func_147498_b();
            float f21 = 0.011111112f;
            GlStateManager.scaled((double)(f21 * 5.0f), (double)(-f21 * 5.0f), (double)(f21 * 5.0f));
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f21));
            GlStateManager.disableLighting();
            GlStateManager.translatef((float)0.0f, (float)((float)(-tile.getShort(EnumTSMProperty.TEXT_HEIGHT)) * 2.0f), (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)((float)tscale * 0.8f + 1.0f), (float)0.0f);
            if (tile.getShort(EnumTSMProperty.TEXT_HEIGHT) < 0) {
                GlStateManager.translatef((float)0.0f, (float)(26.0f + (float)tscale * 0.45f), (float)0.0f);
            }
            GlStateManager.scaled((double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)));
            String text = (tile.getBoolean(EnumTSMProperty.TEXT_BOLD) ? TextFormatting.BOLD : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_STRIKE) ? TextFormatting.STRIKETHROUGH : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_UNDERLINE) ? TextFormatting.UNDERLINE : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_ITALIC) ? TextFormatting.ITALIC : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_OBFUSCATED) ? TextFormatting.OBFUSCATED : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_TRANSLATING) ? this.getTranslatingText(tile.getString(EnumTSMProperty.TEXT), tile) : tile.getString(EnumTSMProperty.TEXT));
            int color = tile.getShort(EnumTSMProperty.TEXT_RED) * 65536 + tile.getShort(EnumTSMProperty.TEXT_GREEN) * 256 + tile.getShort(EnumTSMProperty.TEXT_BLUE);
            if (tile.getBoolean(EnumTSMProperty.TEXT_SHADOW)) {
                fontRenderer.func_175063_a(text, (float)(-fontRenderer.func_78256_a(text)) / 2.0f, -20.0f, color);
            } else {
                fontRenderer.func_211126_b(text, (float)(-fontRenderer.func_78256_a(text)) / 2.0f, -20.0f, color);
            }
            GlStateManager.enableLighting();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public void drawBeam(Tessellator tess, double x, double y, double z, double t2, double t3, BeamVec vec, float red, float green, float blue, float alpha) {
        BufferBuilder bufferBuilder = tess.func_178180_c();
        TSMVec3[] v = vec.getVecs();
        TSMVec3 e = vec.getLenVec();
        for (int i = 0; i < v.length; ++i) {
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b(x + 0.5 + v[i].xCoord, y + 0.5 + v[i].yCoord, z + 0.5 + v[i].zCoord).func_187315_a(1.0, t3).func_181666_a(red, green, blue, alpha).func_181675_d();
            bufferBuilder.func_181662_b(x + 0.5 + v[i].xCoord + e.xCoord, y + 0.5 + v[i].yCoord + e.yCoord, z + 0.5 + v[i].zCoord + e.zCoord).func_187315_a(1.0, t2).func_181666_a(red, green, blue, alpha).func_181675_d();
            bufferBuilder.func_181662_b(x + 0.5 + v[i == v.length - 1 ? 0 : i + 1].xCoord + e.xCoord, y + 0.5 + v[i == v.length - 1 ? 0 : i + 1].yCoord + e.yCoord, z + 0.5 + v[i == v.length - 1 ? 0 : i + 1].zCoord + e.zCoord).func_187315_a(0.0, t2).func_181666_a(red, green, blue, alpha).func_181675_d();
            bufferBuilder.func_181662_b(x + 0.5 + v[i == v.length - 1 ? 0 : i + 1].xCoord, y + 0.5 + v[i == v.length - 1 ? 0 : i + 1].yCoord, z + 0.5 + v[i == v.length - 1 ? 0 : i + 1].zCoord).func_187315_a(0.0, t3).func_181666_a(red, green, blue, alpha).func_181675_d();
            tess.func_78381_a();
        }
    }

    private ResourceLocation getResourceLocationStack(ItemStack stack) {
        TextureAtlasSprite sprite = null;
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        sprite = b != Blocks.field_150350_a ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(b.func_176223_P()) : Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199309_a(stack);
        if (sprite == null) {
            return null;
        }
        ResourceLocation rl = sprite.func_195668_m();
        return new ResourceLocation(rl.func_110624_b(), "textures/" + rl.func_110623_a() + ".png");
    }

    private String getTranslatingText(String str, TileEntitySpotLight tile) {
        if (str != null && str.length() > 1) {
            int t = (int)((float)tile.func_145831_w().func_82737_E() * ((float)(tile.getShort(EnumTSMProperty.TEXT_TRANSLATE_SPEED) + 1) / 100.0f) % (float)str.length());
            if (tile.getBoolean(EnumTSMProperty.TEXT_T_REVERSE)) {
                t = str.length() - t;
            }
            return str.substring(t) + str.substring(0, t);
        }
        return str;
    }
}

