/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.client.gui.buttons;

import fr.mcnanotech.kevin_68.thespotlightmod.client.gui.buttons.TSMButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ButtonToggle
extends TSMButton {
    private ResourceLocation buttonTex = new ResourceLocation("textures/gui/widgets.png");
    private String textNotActive;
    private String textActive;
    private int yTex = 46;
    private boolean useHoverState = true;
    private boolean otherTextureWhenActive = true;
    private boolean doNotChangeTextColor = false;
    private boolean activeState;

    public ButtonToggle(int x, int y, int width, int height, String text, boolean active, Button.IPressable onPress, String helpText) {
        super(x, y, width, height, text, onPress, helpText);
        this.activeState = active;
        this.textActive = this.textNotActive = text;
    }

    public void setTexts(String active, String notActive) {
        this.textActive = active;
        this.textNotActive = notActive;
    }

    public void setCustomTexture(ResourceLocation loc, int textureY) {
        this.yTex = textureY;
        this.buttonTex = loc;
    }

    public void shouldUseHoverState(boolean should) {
        this.useHoverState = should;
    }

    public void shouldChangeTextureOnToggle(boolean should) {
        this.otherTextureWhenActive = should;
    }

    public void changeTextColorWhenNotActive(boolean change) {
        this.doNotChangeTextColor = change;
    }

    public void onPress() {
        this.toggle();
        this.onPress.onPress((Button)this);
    }

    public void toggle() {
        this.activeState = !this.activeState;
    }

    public void setActiveState(boolean b) {
        this.activeState = b;
    }

    public boolean isActive() {
        return this.activeState;
    }

    public int getYImage(boolean hovered) {
        return this.getYImage(hovered, true);
    }

    public int getYImage(boolean getYImage, boolean otherActive) {
        int b0 = 1;
        if ((this.isActive() || this.active) && otherActive) {
            b0 = 1;
        }
        if (getYImage) {
            b0 = 2;
        }
        return b0;
    }

    public void shouldNotChangeTextColor(boolean b) {
        this.doNotChangeTextColor = b;
    }

    public void render(int x, int y, float partialTicks) {
        if (this.visible) {
            String str;
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(this.buttonTex);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
            int k = this.getYImage(this.isHovered, this.otherTextureWhenActive);
            this.blit(this.x, this.y, 0, this.yTex + (this.useHoverState ? k * 20 : 0), this.width / 2, this.height);
            this.blit(this.x + this.width / 2, this.y, 200 - this.width / 2, this.yTex + (this.useHoverState ? k * 20 : 0), this.width / 2, this.height);
            this.renderBg(mc, x, y);
            int l = 0xE0E0E0;
            if (!this.active) {
                l = -6250336;
            } else if (this.isHovered) {
                l = 0xFFFFA0;
            }
            if (!this.isActive()) {
                l = this.doNotChangeTextColor ? 0xE0E0E0 : 0x606060;
                str = this.textNotActive;
            } else {
                str = this.textActive;
            }
            this.drawCenteredString(fontrenderer, str, this.x + this.width / 2, this.y + (this.height - 8) / 2, l);
        }
    }
}

