/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.container;

import fr.mcnanotech.kevin_68.thespotlightmod.TSMObjects;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerSpotLight
extends Container {
    protected TileEntitySpotLight tileSpotlight;
    private List<Slot> configSlots = new ArrayList<Slot>();
    private List<Slot> textureSlots = new ArrayList<Slot>();
    private List<Slot> playerSlots = new ArrayList<Slot>();

    public ContainerSpotLight(int windowId, TileEntitySpotLight inventory, PlayerInventory playerInventory, int invX, int invY) {
        super(TSMObjects.CONTAINER_SPOTLIGHT, windowId);
        this.tileSpotlight = inventory;
        this.bindPlayerInventory(playerInventory, invX, invY);
        this.configSlots.add(this.func_75146_a(new SlotInputItem((IInventory)inventory, 0, 40, 30, TSMObjects.CONFIG_SAVER)));
        this.configSlots.add(this.func_75146_a(new SlotOuput((IInventory)inventory, 1, 40, 80)));
        this.configSlots.add(this.func_75146_a(new SlotInputItem((IInventory)inventory, 2, 80, 30, TSMObjects.CONFIG_SAVER_FULL)));
        this.configSlots.add(this.func_75146_a(new SlotOuput((IInventory)inventory, 3, 80, 80)));
        this.configSlots.add(this.func_75146_a(new SlotInputItem((IInventory)inventory, 4, 120, 30, TSMObjects.CONFIG_SAVER_FULL)));
        this.configSlots.add(this.func_75146_a(new SlotOuput((IInventory)inventory, 5, 120, 80)));
        this.textureSlots.add(this.func_75146_a(new TSMSlot((IInventory)inventory, 6, 40, 80)));
        this.textureSlots.add(this.func_75146_a(new TSMSlot((IInventory)inventory, 7, 120, 80)));
    }

    public ContainerSpotLight(int windowId, PlayerInventory playerInventory, TileEntitySpotLight inventory) {
        this(windowId, inventory, playerInventory, 8, 142);
    }

    public ContainerSpotLight(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(windowId, playerInventory, (TileEntitySpotLight)playerInventory.field_70458_d.field_70170_p.func_175625_s(buffer.func_179259_c()));
    }

    public void showConfigSlot(boolean show) {
        this.configSlots.forEach(s -> ((TSMSlot)((Object)s)).enable(show));
    }

    public void showTextureSlot(boolean show) {
        this.textureSlots.forEach(s -> ((TSMSlot)((Object)s)).enable(show));
    }

    public void showPlayerSlot(boolean show) {
        this.playerSlots.forEach(s -> ((TSMSlot)((Object)s)).enable(show));
    }

    public void changePlayerInventoryPos(int x, int y) {
        for (int i = 0; i < this.playerSlots.size(); ++i) {
            Slot s = this.playerSlots.get(i);
            s.field_75223_e = x + i * 18;
            s.field_75221_f = y;
        }
    }

    public void resetSlot() {
        this.showConfigSlot(false);
        this.showTextureSlot(false);
        this.showPlayerSlot(true);
        this.changePlayerInventoryPos(8, 142);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.tileSpotlight.func_70300_a(player);
    }

    protected void bindPlayerInventory(PlayerInventory inventoryPlayer, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.playerSlots.add(this.func_75146_a(new TSMSlot((IInventory)inventoryPlayer, i, x + i * 18, y, true)));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (slotId >= 15 && slotId < 17) {
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (dragType == 0) {
                if (!stack.func_190926_b()) {
                    ItemStack stack2 = stack.func_77946_l();
                    stack2.func_190920_e(1);
                    slot.func_75209_a(1);
                    slot.func_75215_d(stack2);
                } else {
                    slot.func_75209_a(1);
                }
            } else if (dragType == 1) {
                slot.func_75209_a(1);
            }
            return stack;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tileSpotlight.craftConfig();
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        if (slotId >= 15 && slotId < 17) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotId < this.tileSpotlight.func_70302_i_() ? !this.func_75135_a(itemstack1, this.tileSpotlight.func_70302_i_() - 2, this.field_75151_b.size() - 2, true) : !this.func_75135_a(itemstack1, 0, this.tileSpotlight.func_70302_i_() - 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public TileEntitySpotLight getSpotlight() {
        return this.tileSpotlight;
    }

    private static class SlotInputItem
    extends TSMSlot {
        private final Item acceptedItem;

        public SlotInputItem(IInventory inventoryIn, int index, int xPosition, int yPosition, Item item) {
            super(inventoryIn, index, xPosition, yPosition);
            this.acceptedItem = item;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() == this.acceptedItem;
        }
    }

    private static class SlotOuput
    extends TSMSlot {
        public SlotOuput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    private static class TSMSlot
    extends Slot {
        private boolean enabled;

        public TSMSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, boolean enabled) {
            super(inventoryIn, index, xPosition, yPosition);
            this.enabled = enabled;
        }

        public TSMSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            this(inventoryIn, index, xPosition, yPosition, false);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_111238_b() {
            return this.enabled;
        }

        public void enable(boolean enable) {
            this.enabled = enable;
        }
    }
}

