/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.packets;

import fr.mcnanotech.kevin_68.thespotlightmod.TheSpotLightMod;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.utils.TSMJsonManager;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketData {
    private BlockPos pos;
    private String data;

    public PacketData(BlockPos pos, String data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(PacketData packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_180714_a(packet.data);
    }

    public static PacketData decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        return new PacketData(pos, s);
    }

    public static void handle(PacketData packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.pos);
            if (te instanceof TileEntitySpotLight) {
                TileEntitySpotLight tile = (TileEntitySpotLight)te;
                try {
                    String jsonData = TSMJsonManager.decompress(packet.data);
                    tile.updated = TSMJsonManager.updateTileData(tile, jsonData);
                }
                catch (IOException e) {
                    TheSpotLightMod.LOGGER.debug("Fail to decompress data");
                    TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
                }
                tile.updating = false;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

