/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.packets;

import fr.mcnanotech.kevin_68.thespotlightmod.TheSpotLightMod;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.utils.TSMJsonManager;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketTLData {
    private BlockPos pos;
    private String data;

    public PacketTLData(BlockPos pos, String data) {
        this.pos = pos;
        this.data = data;
    }

    public static PacketTLData decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        String data = buffer.func_150789_c(Short.MAX_VALUE);
        return new PacketTLData(pos, data);
    }

    public static void encode(PacketTLData packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_180714_a(packet.data);
    }

    public static void handle(PacketTLData packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntitySpotLight tile = (TileEntitySpotLight)Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.pos);
            try {
                tile.timelineUpdated = TSMJsonManager.updateTileTimeline(tile, TSMJsonManager.decompress(packet.data));
            }
            catch (IOException e) {
                TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
            }
            tile.timelineUpdating = false;
        });
        ctx.get().setPacketHandled(true);
    }
}

