/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.packets;

import fr.mcnanotech.kevin_68.thespotlightmod.TSMNetwork;
import fr.mcnanotech.kevin_68.thespotlightmod.TheSpotLightMod;
import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.packets.PacketTLData;
import fr.mcnanotech.kevin_68.thespotlightmod.utils.TSMJsonManager;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.Level;

public class PacketUpdateTLData {
    private BlockPos pos;
    private String newData;

    public PacketUpdateTLData(BlockPos pos, String newData, boolean alreadyCompressed) {
        this.pos = pos;
        if (alreadyCompressed) {
            this.newData = newData;
        } else {
            try {
                this.newData = TSMJsonManager.compress(newData);
            }
            catch (IOException e) {
                TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
            }
        }
    }

    public PacketUpdateTLData(BlockPos pos, String newData) {
        this(pos, newData, false);
    }

    public static PacketUpdateTLData decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        String newData = buffer.func_150789_c(Short.MAX_VALUE);
        return new PacketUpdateTLData(pos, newData, true);
    }

    public static void encode(PacketUpdateTLData packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_180714_a(packet.newData);
    }

    public static void handle(PacketUpdateTLData packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                TileEntitySpotLight te = (TileEntitySpotLight)((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_175625_s(packet.pos);
                te.timelineUpdated = false;
                TSMJsonManager.updateTlJsonData(((NetworkEvent.Context)ctx.get()).getSender().func_71121_q(), packet.pos, TSMJsonManager.decompress(packet.newData));
                TSMNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PacketTLData(packet.pos, packet.newData));
            }
            catch (IOException e) {
                TheSpotLightMod.LOGGER.catching(Level.WARN, (Throwable)e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

