/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.LongSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.clothconfig2.impl.EasingMethods;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ClothConfigInitializer
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ClothConfig");
    private static EasingMethod easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
    private static long scrollDuration = 600L;
    private static double scrollStep = 19.0;
    private static double bounceBackMultiplier = 0.24;

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration) {
        if (ClothConfigInitializer.getBounceBackMultiplier() >= 0.0) {
            target[0] = ClothConfigInitializer.clamp(target[0], maxScroll);
            if (target[0] < 0.0) {
                target[0] = target[0] - target[0] * (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0;
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0 - (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0) + maxScroll;
            }
        } else {
            target[0] = ClothConfigInitializer.clamp(target[0], maxScroll, 0.0);
        }
        if (!Precision.almostEquals(scroll, target[0], (double)0.001f)) {
            return ClothConfigInitializer.expoEase(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration * (double)delta * 3.0, 1.0));
        }
        return target[0];
    }

    public static double expoEase(double start, double end, double amount) {
        return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
    }

    public static double clamp(double v, double maxScroll) {
        return ClothConfigInitializer.clamp(v, maxScroll, 200.0);
    }

    public static double clamp(double v, double maxScroll, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)(maxScroll + clampExtension));
    }

    public static EasingMethod getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return scrollDuration;
    }

    public static double getScrollStep() {
        return scrollStep;
    }

    public static double getBounceBackMultiplier() {
        return bounceBackMultiplier;
    }

    private static void loadConfig() {
        File file = new File(FabricLoader.getInstance().getConfigDirectory(), "cloth-config2/config.properties");
        try {
            file.getParentFile().mkdirs();
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
            if (!file.exists()) {
                ClothConfigInitializer.saveConfig();
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String easing = properties.getProperty("easingMethod1", "LINEAR");
            for (EasingMethod value : EasingMethods.getMethods()) {
                if (!value.toString().equalsIgnoreCase(easing)) continue;
                easingMethod = value;
                break;
            }
            scrollDuration = Long.parseLong(properties.getProperty("scrollDuration1", "600"));
            scrollStep = Double.parseDouble(properties.getProperty("scrollStep1", "19"));
            bounceBackMultiplier = Double.parseDouble(properties.getProperty("bounceBackMultiplier2", "0.24"));
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ClothConfigInitializer.saveConfig();
    }

    private static void saveConfig() {
        File file = new File(FabricLoader.getInstance().getConfigDirectory(), "cloth-config2/config.properties");
        try {
            FileWriter writer = new FileWriter(file, false);
            Properties properties = new Properties();
            properties.setProperty("easingMethod1", easingMethod.toString());
            properties.setProperty("scrollDuration1", scrollDuration + "");
            properties.setProperty("scrollStep1", scrollStep + "");
            properties.setProperty("bounceBackMultiplier2", bounceBackMultiplier + "");
            properties.store(writer, null);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
        }
    }

    public void onInitializeClient() {
        ClothConfigInitializer.loadConfig();
        if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            try {
                Class<?> clazz = Class.forName("io.github.prospector.modmenu.api.ModMenuApi");
                Method method = clazz.getMethod("addConfigOverride", String.class, Runnable.class);
                method.invoke(null, "cloth-config2", () -> {
                    try {
                        class_310.method_1551().method_1507(ClothConfigInitializer.getConfigBuilderWithDemo().build());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("[ClothConfig] Failed to add test config override for ModMenu!", (Throwable)e);
            }
        }
    }

    public static ConfigBuilder getConfigBuilder() {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle("title.cloth-config.config");
        builder.setDefaultBackgroundTexture(new class_2960("minecraft:textures/block/oak_planks.png"));
        ConfigCategory scrolling = builder.getOrCreateCategory("category.cloth-config.scrolling");
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        AbstractConfigListEntry easingMethodEntry = entryBuilder.startDropdownMenu("Easing Method", DropdownMenuBuilder.TopCellElementBuilder.of(easingMethod, str -> {
            for (EasingMethod m : EasingMethods.getMethods()) {
                if (!m.toString().equals(str)) continue;
                return m;
            }
            return null;
        })).setDefaultValue(EasingMethod.EasingMethodImpl.LINEAR).setSaveConsumer(o -> {
            easingMethod = o;
        }).setSelections(EasingMethods.getMethods()).build();
        LongSliderEntry scrollDurationEntry = entryBuilder.startLongSlider("option.cloth-config.scrollDuration", scrollDuration, 0L, 5000L).setTextGetter(integer -> integer <= 0L ? "Value: Disabled" : (integer > 1500L ? String.format("Value: %.1fs", Float.valueOf((float)integer.longValue() / 1000.0f)) : "Value: " + integer + "ms")).setDefaultValue(600L).setSaveConsumer(i -> {
            scrollDuration = i;
        }).build();
        DoubleListEntry scrollStepEntry = entryBuilder.startDoubleField("option.cloth-config.scrollStep", scrollStep).setDefaultValue(19.0).setSaveConsumer(i -> {
            scrollStep = i;
        }).build();
        LongSliderEntry bounceMultiplierEntry = entryBuilder.startLongSlider("option.cloth-config.bounceBackMultiplier", (long)(bounceBackMultiplier * 1000.0), -10L, 750L).setTextGetter(integer -> integer < 0L ? "Value: Disabled" : String.format("Value: %s", (double)integer.longValue() / 1000.0)).setDefaultValue(240L).setSaveConsumer(i -> {
            bounceBackMultiplier = (double)i.longValue() / 1000.0;
        }).build();
        scrolling.addEntry(new TooltipListEntry<Object>(class_1074.method_4662((String)"option.cloth-config.setDefaultSmoothScroll", (Object[])new Object[0]), null, (DropdownBoxEntry)easingMethodEntry, scrollDurationEntry, scrollStepEntry, bounceMultiplierEntry){
            final int width = 220;
            private final class_339 buttonWidget;
            private final List<class_339> children;
            final /* synthetic */ DropdownBoxEntry val$easingMethodEntry;
            final /* synthetic */ LongSliderEntry val$scrollDurationEntry;
            final /* synthetic */ DoubleListEntry val$scrollStepEntry;
            final /* synthetic */ LongSliderEntry val$bounceMultiplierEntry;
            {
                this.val$easingMethodEntry = dropdownBoxEntry;
                this.val$scrollDurationEntry = longSliderEntry;
                this.val$scrollStepEntry = doubleListEntry;
                this.val$bounceMultiplierEntry = longSliderEntry2;
                super(fieldName, tooltipSupplier);
                this.width = 220;
                this.buttonWidget = new class_4264(0, 0, 0, 20, this.getFieldName()){

                    public void onPress() {
                        val$easingMethodEntry.getSelectionElement().getTopRenderer().setValue(EasingMethod.EasingMethodImpl.LINEAR);
                        val$scrollDurationEntry.setValue(600L);
                        val$scrollStepEntry.setValue("19.0");
                        val$bounceMultiplierEntry.setValue(240L);
                        this.getScreen().setEdited(true, this.isRequiresRestart());
                    }
                };
                this.children = ImmutableList.of((Object)this.buttonWidget);
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public Optional<Object> getDefaultValue() {
                return Optional.empty();
            }

            @Override
            public void save() {
            }

            public List<? extends class_364> children() {
                return this.children;
            }

            @Override
            public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                class_1041 window = class_310.method_1551().method_22683();
                this.buttonWidget.active = this.isEditable();
                this.buttonWidget.y = y;
                this.buttonWidget.x = x + entryWidth / 2 - 110;
                this.buttonWidget.setWidth(220);
                this.buttonWidget.render(mouseX, mouseY, delta);
            }
        });
        scrolling.addEntry(new TooltipListEntry<Object>(class_1074.method_4662((String)"option.cloth-config.disableSmoothScroll", (Object[])new Object[0]), null, (DropdownBoxEntry)easingMethodEntry, scrollDurationEntry, scrollStepEntry, bounceMultiplierEntry){
            final int width = 220;
            private final class_339 buttonWidget;
            private final List<class_339> children;
            final /* synthetic */ DropdownBoxEntry val$easingMethodEntry;
            final /* synthetic */ LongSliderEntry val$scrollDurationEntry;
            final /* synthetic */ DoubleListEntry val$scrollStepEntry;
            final /* synthetic */ LongSliderEntry val$bounceMultiplierEntry;
            {
                this.val$easingMethodEntry = dropdownBoxEntry;
                this.val$scrollDurationEntry = longSliderEntry;
                this.val$scrollStepEntry = doubleListEntry;
                this.val$bounceMultiplierEntry = longSliderEntry2;
                super(fieldName, tooltipSupplier);
                this.width = 220;
                this.buttonWidget = new class_4264(0, 0, 0, 20, this.getFieldName()){

                    public void onPress() {
                        val$easingMethodEntry.getSelectionElement().getTopRenderer().setValue(EasingMethod.EasingMethodImpl.NONE);
                        val$scrollDurationEntry.setValue(0L);
                        val$scrollStepEntry.setValue("16.0");
                        val$bounceMultiplierEntry.setValue(-10L);
                        this.getScreen().setEdited(true, this.isRequiresRestart());
                    }
                };
                this.children = ImmutableList.of((Object)this.buttonWidget);
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public Optional<Object> getDefaultValue() {
                return Optional.empty();
            }

            @Override
            public void save() {
            }

            public List<? extends class_364> children() {
                return this.children;
            }

            @Override
            public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                class_1041 window = class_310.method_1551().method_22683();
                this.buttonWidget.active = this.isEditable();
                this.buttonWidget.y = y;
                this.buttonWidget.x = x + entryWidth / 2 - 110;
                this.buttonWidget.setWidth(220);
                this.buttonWidget.render(mouseX, mouseY, delta);
            }
        });
        scrolling.addEntry(easingMethodEntry);
        scrolling.addEntry(scrollDurationEntry);
        scrolling.addEntry(scrollStepEntry);
        scrolling.addEntry(bounceMultiplierEntry);
        builder.setSavingRunnable(ClothConfigInitializer::saveConfig);
        builder.transparentBackground();
        return builder;
    }

    public static ConfigBuilder getConfigBuilderWithDemo() {
        ConfigBuilder builder = ClothConfigInitializer.getConfigBuilder();
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory testing = builder.getOrCreateCategory("category.cloth-config.testing");
        testing.addEntry(entryBuilder.startKeyCodeField("Cool Key", class_3675.field_16237).setDefaultValue(class_3675.field_16237).build());
        testing.addEntry(entryBuilder.startModifierKeyCodeField("Cool Modifier Key", ModifierKeyCode.of(class_3675.class_307.field_1668.method_1447(79), Modifier.of(false, true, false))).setDefaultValue(ModifierKeyCode.of(class_3675.class_307.field_1668.method_1447(79), Modifier.of(false, true, false))).build());
        testing.addEntry(entryBuilder.startDoubleList("A list of Doubles", Arrays.asList(1.0, 2.0, 3.0)).setDefaultValue(Arrays.asList(1.0, 2.0, 3.0)).build());
        testing.addEntry(entryBuilder.startLongList("A list of Longs", Arrays.asList(1L, 2L, 3L)).setDefaultValue(Arrays.asList(1L, 2L, 3L)).build());
        testing.addEntry(entryBuilder.startStrList("A list of Strings", Arrays.asList("abc", "xyz")).setDefaultValue(Arrays.asList("abc", "xyz")).build());
        SubCategoryBuilder colors = entryBuilder.startSubCategory("Colors").setExpanded(true);
        colors.add(entryBuilder.startColorField("A color field", 65535).setDefaultValue(65535).build());
        colors.add(entryBuilder.startColorField("An alpha color field", -16711681).setDefaultValue(-16711681).setAlphaMode(true).build());
        colors.add(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        testing.addEntry(colors.build());
        return builder;
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }
}

