/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.QueuedTooltip;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.math.api.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ClothConfigScreen
extends class_437 {
    private static final class_2960 CONFIG_TEX = new class_2960("cloth-config2", "textures/gui/cloth_config.png");
    private final List<QueuedTooltip> queuedTooltips = Lists.newArrayList();
    public int nextTabIndex;
    public int selectedTabIndex;
    public double tabsScrollVelocity = 0.0;
    public double tabsScrollProgress;
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry>> listWidget;
    private KeyCodeEntry focusedBinding;
    private final class_437 parent;
    private final LinkedHashMap<String, List<AbstractConfigEntry>> tabbedEntries;
    private final List<class_3545<String, Integer>> tabs;
    private boolean edited;
    private boolean requiresRestart;
    private final boolean confirmSave;
    private class_339 quitButton;
    private class_339 saveButton;
    private class_339 applyButton;
    private class_339 buttonLeftTab;
    private class_339 buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private final String title;
    private double tabsMaximumScrolled = -1.0;
    private final boolean displayErrors;
    private final List<ClothConfigTabButton> tabButtons;
    private boolean smoothScrollingTabs = true;
    private boolean smoothScrollingList;
    private final class_2960 defaultBackgroundLocation;
    private final Map<String, class_2960> categoryBackgroundLocation;
    private boolean transparentBackground = false;
    private boolean editable = true;
    private @Nullable String defaultFallbackCategory = null;
    private boolean alwaysShowTabs = false;
    private ModifierKeyCode startedKeyCode = null;

    @Deprecated
    public ClothConfigScreen(class_437 parent, String title, Map<String, List<class_3545<String, Object>>> o, boolean confirmSave, boolean displayErrors, boolean smoothScrollingList, class_2960 defaultBackgroundLocation, Map<String, class_2960> categoryBackgroundLocation) {
        super((class_2561)new class_2585(""));
        this.parent = parent;
        this.title = title;
        this.tabbedEntries = Maps.newLinkedHashMap();
        this.smoothScrollingList = smoothScrollingList;
        this.defaultBackgroundLocation = defaultBackgroundLocation;
        o.forEach((tab, pairs) -> {
            ArrayList list = Lists.newArrayList();
            for (class_3545 pair : pairs) {
                if (pair.method_15441() instanceof AbstractConfigListEntry) {
                    list.add((AbstractConfigListEntry)((Object)((Object)pair.method_15441())));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported Type (" + (String)pair.method_15442() + "): " + pair.method_15441().getClass().getSimpleName());
            }
            list.forEach(entry -> entry.setScreen(this));
            this.tabbedEntries.put((String)tab, list);
        });
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.tabs = this.tabbedEntries.keySet().stream().map(s -> new class_3545(s, (Object)(textRenderer.method_1727(class_1074.method_4662((String)s, (Object[])new Object[0])) + 8))).collect(Collectors.toList());
        this.nextTabIndex = 0;
        this.selectedTabIndex = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            class_3545<String, Integer> pair = this.tabs.get(i);
            if (!((String)pair.method_15442()).equals(this.getFallbackCategory())) continue;
            this.nextTabIndex = i;
            this.selectedTabIndex = i;
            break;
        }
        this.confirmSave = confirmSave;
        this.edited = false;
        this.requiresRestart = false;
        this.tabsScrollProgress = 0.0;
        this.tabButtons = Lists.newArrayList();
        this.displayErrors = displayErrors;
        this.categoryBackgroundLocation = categoryBackgroundLocation;
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.tabs.size() > 1;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @Deprecated
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground && class_310.method_1551().field_1687 != null;
    }

    @Deprecated
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public String getFallbackCategory() {
        if (this.defaultFallbackCategory != null) {
            return this.defaultFallbackCategory;
        }
        return (String)this.tabs.get(0).method_15442();
    }

    @Deprecated
    public void setFallbackCategory(@Nullable String defaultFallbackCategory) {
        this.defaultFallbackCategory = defaultFallbackCategory;
        for (int i = 0; i < this.tabs.size(); ++i) {
            class_3545<String, Integer> pair = this.tabs.get(i);
            if (!((String)pair.method_15442()).equals(this.getFallbackCategory())) continue;
            this.nextTabIndex = i;
            this.selectedTabIndex = i;
            break;
        }
    }

    public void tick() {
        super.tick();
        for (class_364 child : this.children()) {
            if (!(child instanceof class_3000)) continue;
            ((class_3000)child).method_16896();
        }
    }

    public class_2960 getBackgroundLocation() {
        if (this.categoryBackgroundLocation.containsKey(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex))) {
            return this.categoryBackgroundLocation.get(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex));
        }
        return this.defaultBackgroundLocation;
    }

    public boolean isSmoothScrollingList() {
        return this.smoothScrollingList;
    }

    @Deprecated
    public void setSmoothScrollingList(boolean smoothScrollingList) {
        this.smoothScrollingList = smoothScrollingList;
    }

    public boolean isSmoothScrollingTabs() {
        return this.smoothScrollingTabs;
    }

    @Deprecated
    public void setSmoothScrollingTabs(boolean smoothScrolling) {
        this.smoothScrollingTabs = smoothScrolling;
    }

    public boolean isEdited() {
        return this.edited;
    }

    @Deprecated
    public void setEdited(boolean edited) {
        this.edited = edited;
        this.quitButton.setMessage(edited ? class_1074.method_4662((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]));
        this.saveButton.active = edited;
    }

    public void setEdited(boolean edited, boolean requiresRestart) {
        this.setEdited(edited);
        if (!this.requiresRestart && requiresRestart) {
            this.requiresRestart = requiresRestart;
        }
    }

    public void saveAll(boolean openOtherScreens) {
        for (List entries : Lists.newArrayList(this.tabbedEntries.values())) {
            for (AbstractConfigEntry entry : entries) {
                entry.save();
            }
        }
        this.save();
        this.setEdited(false);
        if (openOtherScreens) {
            if (this.requiresRestart) {
                this.minecraft.method_1507((class_437)new ClothRequiresRestartScreen(this.parent));
            } else {
                this.minecraft.method_1507(this.parent);
            }
        }
        this.requiresRestart = false;
    }

    protected void init() {
        super.init();
        this.children.clear();
        this.tabButtons.clear();
        if (this.listWidget != null) {
            this.tabbedEntries.put((String)this.tabs.get(this.selectedTabIndex).method_15442(), this.listWidget.children());
        }
        this.selectedTabIndex = this.nextTabIndex;
        this.listWidget = new ListWidget(this.minecraft, this.width, this.height, this.isShowingTabs() ? 70 : 30, this.height - 32, this.getBackgroundLocation());
        this.children.add(this.listWidget);
        this.listWidget.setSmoothScrolling(this.smoothScrollingList);
        if (this.tabbedEntries.size() > this.selectedTabIndex) {
            ((List)Lists.newArrayList(this.tabbedEntries.values()).get(this.selectedTabIndex)).forEach(entry -> this.listWidget.children().add((AbstractConfigEntry)((Object)entry)));
        }
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 3);
        this.quitButton = new class_4185(this.width / 2 - buttonWidths / 2 - buttonWidths - 6, this.height - 26, buttonWidths, 20, this.edited ? class_1074.method_4662((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]), widget -> {
            if (this.confirmSave && this.edited) {
                this.minecraft.method_1507((class_437)new class_410((BooleanConsumer)new QuitSaveConsumer(), (class_2561)new class_2588("text.cloth-config.quit_config", new Object[0]), (class_2561)new class_2588("text.cloth-config.quit_config_sure", new Object[0]), class_1074.method_4662((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0])));
            } else {
                this.minecraft.method_1507(this.parent);
            }
        });
        this.addButton(this.quitButton);
        this.saveButton = new class_4264(this.width / 2 + buttonWidths / 2 + 6, this.height - 26, buttonWidths, 20, ""){

            public void onPress() {
                ClothConfigScreen.this.saveAll(true);
            }

            public void render(int int_1, int int_2, float float_1) {
                boolean hasErrors = false;
                if (ClothConfigScreen.this.displayErrors) {
                    for (List entries : Lists.newArrayList(ClothConfigScreen.this.tabbedEntries.values())) {
                        for (AbstractConfigEntry entry : entries) {
                            if (!entry.getConfigError().isPresent()) continue;
                            hasErrors = true;
                            break;
                        }
                        if (!hasErrors) continue;
                        break;
                    }
                }
                this.active = ClothConfigScreen.this.edited && !hasErrors;
                this.setMessage(ClothConfigScreen.this.displayErrors && hasErrors ? class_1074.method_4662((String)"text.cloth-config.error_cannot_save", (Object[])new Object[0]) : class_1074.method_4662((String)"text.cloth-config.save_and_done", (Object[])new Object[0]));
                super.render(int_1, int_2, float_1);
            }
        };
        this.addButton(this.saveButton);
        this.applyButton = new class_4264(this.width / 2 - buttonWidths / 2, this.height - 26, buttonWidths, 20, class_1074.method_4662((String)"text.cloth-config.apply", (Object[])new Object[0])){

            public void onPress() {
                if (ClothConfigScreen.this.requiresRestart) {
                    ClothConfigScreen.this.minecraft.method_1507((class_437)new ClothRequiresRestartScreen(ClothConfigScreen.this));
                }
                ClothConfigScreen.this.saveAll(false);
            }

            public void render(int int_1, int int_2, float float_1) {
                this.active = ((ClothConfigScreen)ClothConfigScreen.this).saveButton.active;
                super.render(int_1, int_2, float_1);
            }
        };
        this.addButton(this.applyButton);
        this.saveButton.active = this.edited;
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.width, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.width - 18, 41, 18, 24);
            this.buttonLeftTab = new class_4264(4, 44, 12, 18, ""){

                public void onPress() {
                    ClothConfigScreen.this.tabsScrollProgress = -2.147483648E9;
                    ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                    ClothConfigScreen.this.clampTabsScrolled();
                }

                public void renderButton(int int_1, int int_2, float float_1) {
                    ClothConfigScreen.this.minecraft.method_1531().method_22813(CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                    int int_3 = this.getYImage(this.isHovered());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.blit(this.x, this.y, 12, 18 * int_3, this.width, this.height);
                }
            };
            this.children.add(this.buttonLeftTab);
            int j = 0;
            for (class_3545<String, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.method_15441(), 20, class_1074.method_4662((String)((String)tab.method_15442()), (Object[])new Object[0])));
                ++j;
            }
            this.children.addAll(this.tabButtons);
            this.buttonRightTab = new class_4264(this.width - 16, 44, 12, 18, ""){

                public void onPress() {
                    ClothConfigScreen.this.tabsScrollProgress = 2.147483647E9;
                    ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                    ClothConfigScreen.this.clampTabsScrolled();
                }

                public void renderButton(int int_1, int int_2, float float_1) {
                    ClothConfigScreen.this.minecraft.method_1531().method_22813(CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                    int int_3 = this.getYImage(this.isHovered());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.blit(this.x, this.y, 0, 18 * int_3, this.width, this.height);
                }
            };
            this.children.add(this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.tabsBounds.contains(double_1, double_2) && !this.tabsLeftBounds.contains(double_1, double_2) && !this.tabsRightBounds.contains(double_1, double_2) && double_3 != 0.0) {
            if (double_3 < 0.0) {
                this.tabsScrollVelocity += 16.0;
            }
            if (double_3 > 0.0) {
                this.tabsScrollVelocity -= 16.0;
            }
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            AtomicDouble d = new AtomicDouble();
            this.tabs.forEach(pair -> d.addAndGet((double)((Integer)pair.method_15441() + 2)));
            this.tabsMaximumScrolled = d.get();
        }
        return this.tabsMaximumScrolled + 8.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
        this.tabsScrollVelocity = 0.0;
    }

    public void clampTabsScrolled() {
        int xx = 0;
        for (ClothConfigTabButton tabButton : this.tabButtons) {
            xx += tabButton.getWidth() + 2;
        }
        this.tabsScrollProgress = xx > this.width - 40 ? class_3532.method_15350((double)this.tabsScrollProgress, (double)0.0, (double)(this.getTabsMaximumScrolled() - (double)this.width + 40.0)) : 0.0;
    }

    public void render(int int_1, int int_2, float float_1) {
        if (this.isShowingTabs()) {
            if (this.smoothScrollingTabs) {
                double change = this.tabsScrollVelocity * (double)0.2f;
                if (change != 0.0) {
                    if (change > 0.0 && change < 0.2) {
                        change = 0.2;
                    } else if (change < 0.0 && change > -0.2) {
                        change = -0.2;
                    }
                    this.tabsScrollProgress += change;
                    this.tabsScrollVelocity -= change;
                    if (change > 0.0 == this.tabsScrollVelocity < 0.0) {
                        this.tabsScrollVelocity = 0.0;
                    }
                    this.clampTabsScrolled();
                }
            } else {
                this.tabsScrollProgress += this.tabsScrollVelocity;
                this.tabsScrollVelocity = 0.0;
                this.clampTabsScrolled();
            }
            int xx = 24 - (int)this.tabsScrollProgress;
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.x = xx;
                xx += tabButton.getWidth() + 2;
            }
            this.buttonLeftTab.active = this.tabsScrollProgress > 0.0;
            boolean bl = this.buttonRightTab.active = this.tabsScrollProgress < this.getTabsMaximumScrolled() - (double)this.width + 40.0;
        }
        if (this.isTransparentBackground()) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.renderDirtBackground(0);
        }
        this.listWidget.render(int_1, int_2, float_1);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (Object child : this.listWidget.children()) {
            ((AbstractConfigEntry)((Object)child)).lateRender(int_1, int_2, float_1);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.isShowingTabs()) {
            this.drawCenteredString(this.minecraft.field_1772, this.title, this.width / 2, 18, -1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            ScissorsHandler.INSTANCE.scissor(onlyInnerTabBounds);
            if (this.isTransparentBackground()) {
                this.fillGradient(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(onlyInnerTabBounds, 32, 32, 32, 255, 255);
            }
            this.tabButtons.forEach(widget -> widget.render(int_1, int_2, float_1));
            this.drawTabsShades(0, this.isTransparentBackground() ? 120 : 255);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.buttonLeftTab.render(int_1, int_2, float_1);
            this.buttonRightTab.render(int_1, int_2, float_1);
        } else {
            this.drawCenteredString(this.minecraft.field_1772, this.title, this.width / 2, 12, -1);
        }
        if (this.displayErrors && this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.tabbedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                this.minecraft.method_1531().method_22813(CONFIG_TEX);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String text = "\u00a7c" + (errors.size() == 1 ? (String)errors.get(0) : class_1074.method_4662((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.minecraft.field_1772.method_1727(text);
                    this.minecraft.field_1772.getClass();
                    this.fillGradient(8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                this.blit(10, 10, 0, 54, 3, 11);
                this.drawString(this.minecraft.field_1772, text, 18, 12, -1);
            }
        } else if (!this.isEditable()) {
            this.minecraft.method_1531().method_22813(CONFIG_TEX);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = "\u00a7c" + class_1074.method_4662((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int stringWidth = this.minecraft.field_1772.method_1727(text);
                this.minecraft.field_1772.getClass();
                this.fillGradient(8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
            }
            this.blit(10, 10, 0, 54, 3, 11);
            this.drawString(this.minecraft.field_1772, text, 18, 12, -1);
        }
        super.render(int_1, int_2, float_1);
        this.queuedTooltips.forEach(queuedTooltip -> this.renderTooltip(queuedTooltip.getText(), queuedTooltip.getX(), queuedTooltip.getY()));
        this.queuedTooltips.clear();
    }

    public void queueTooltip(QueuedTooltip queuedTooltip) {
        this.queuedTooltips.add(queuedTooltip);
    }

    private void drawTabsShades(int lightColor, int darkColor) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22912((double)(this.tabsBounds.getMinX() + 20), (double)(this.tabsBounds.getMinY() + 4), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMaxX() - 20), (double)(this.tabsBounds.getMinY() + 4), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMaxX() - 20), (double)this.tabsBounds.getMinY(), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMinX() + 20), (double)this.tabsBounds.getMinY(), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, darkColor).method_1344();
        tessellator.method_1350();
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22912((double)(this.tabsBounds.getMinX() + 20), (double)this.tabsBounds.getMaxY(), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMaxX() - 20), (double)this.tabsBounds.getMaxY(), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMaxX() - 20), (double)(this.tabsBounds.getMaxY() - 4), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22912((double)(this.tabsBounds.getMinX() + 20), (double)(this.tabsBounds.getMaxY() - 4), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, lightColor).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    protected void overlayBackground(Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        if (this.isTransparentBackground()) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        this.minecraft.method_1531().method_22813(this.getBackgroundLocation());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22912((double)rect.getMinX(), (double)rect.getMaxY(), 0.0).method_22913((float)rect.getMinX() / 32.0f, (float)rect.getMaxY() / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)rect.getMaxX(), (double)rect.getMaxY(), 0.0).method_22913((float)rect.getMaxX() / 32.0f, (float)rect.getMaxY() / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)rect.getMaxX(), (double)rect.getMinY(), 0.0).method_22913((float)rect.getMaxX() / 32.0f, (float)rect.getMinY() / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        buffer.method_22912((double)rect.getMinX(), (double)rect.getMinY(), 0.0).method_22913((float)rect.getMinX() / 32.0f, (float)rect.getMinY() / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public KeyCodeEntry getFocusedBinding() {
        return this.focusedBinding;
    }

    public void setFocusedBinding(KeyCodeEntry focusedBinding) {
        this.focusedBinding = focusedBinding;
        if (focusedBinding != null) {
            this.startedKeyCode = this.focusedBinding.getValue();
            this.startedKeyCode.setKeyCodeAndModifier(class_3675.field_16237, Modifier.none());
        } else {
            this.startedKeyCode = null;
        }
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && !this.startedKeyCode.isUnknown() && this.focusedBinding.isAllowMouse()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.mouseReleased(double_1, double_2, int_1);
    }

    public boolean method_16803(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowKey()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.method_16803(int_1, int_2, int_3);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowMouse()) {
            if (this.startedKeyCode.isUnknown()) {
                this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
            } else if (this.focusedBinding.isAllowModifiers() && this.startedKeyCode.getType() == class_3675.class_307.field_1668) {
                int code = this.startedKeyCode.getKeyCode().method_1444();
                if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
                if (code == 344 || code == 340) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
                if (code == 342 || code == 346) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
            }
            return true;
        }
        if (this.focusedBinding != null) {
            return true;
        }
        return super.mouseClicked(double_1, double_2, int_1);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && (this.focusedBinding.isAllowKey() || int_1 == 256)) {
            if (int_1 != 256) {
                if (this.startedKeyCode.isUnknown()) {
                    this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                } else if (this.focusedBinding.isAllowModifiers()) {
                    if (this.startedKeyCode.getType() == class_3675.class_307.field_1668) {
                        int code = this.startedKeyCode.getKeyCode().method_1444();
                        if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                    }
                    if (class_310.field_1703 ? int_1 == 343 || int_1 == 347 : int_1 == 341 || int_1 == 345) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                        return true;
                    }
                    if (int_1 == 344 || int_1 == 340) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                        return true;
                    }
                    if (int_1 == 342 || int_1 == 346) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.focusedBinding.setValue(ModifierKeyCode.unknown());
                this.setFocusedBinding(null);
            }
            return true;
        }
        if (this.focusedBinding != null && int_1 != 256) {
            return true;
        }
        if (int_1 == 256 && this.shouldCloseOnEsc()) {
            if (this.confirmSave && this.edited) {
                this.minecraft.method_1507((class_437)new class_410((BooleanConsumer)new QuitSaveConsumer(), (class_2561)new class_2588("text.cloth-config.quit_config", new Object[0]), (class_2561)new class_2588("text.cloth-config.quit_config_sure", new Object[0]), class_1074.method_4662((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0])));
            } else {
                this.minecraft.method_1507(this.parent);
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public void save() {
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Deprecated
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        public ListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.visible = false;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        public ClothConfigScreen getScreen() {
            return ClothConfigScreen.this;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 36;
        }

        protected final void clearStuff() {
            this.clearItems();
        }

        @Override
        protected void renderItem(R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)((Object)item)).updateSelected(this.getFocused() == item);
            }
            super.renderItem(item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            this.updateScrollingState(double_1, double_2, int_1);
            if (!this.isMouseOver(double_1, double_2)) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.children()) {
                if (!entry.mouseClicked(double_1, double_2, int_1)) continue;
                this.setFocused(entry);
                this.setDragging(true);
                return true;
            }
            if (int_1 == 0) {
                this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        protected void renderBackBackground(class_287 buffer, class_289 tessellator) {
            if (!ClothConfigScreen.this.isTransparentBackground()) {
                super.renderBackBackground(buffer, tessellator);
            } else {
                this.fillGradient(this.left, this.top, this.right, this.bottom, 0x68000000, 0x68000000);
            }
        }

        @Override
        protected void renderHoleBackground(int int_1, int int_2, int int_3, int int_4) {
            if (!ClothConfigScreen.this.isTransparentBackground()) {
                super.renderHoleBackground(int_1, int_2, int_3, int_4);
            }
        }
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                ClothConfigScreen.this.minecraft.method_1507((class_437)ClothConfigScreen.this);
            } else {
                ClothConfigScreen.this.minecraft.method_1507(ClothConfigScreen.this.parent);
            }
        }
    }
}

