/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.QueuedTooltip;
import me.shedaniel.math.api.Point;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    private @Nullable Supplier<Optional<String[]>> tooltipSupplier;

    @Deprecated
    public TooltipListEntry(String fieldName, @Nullable Supplier<Optional<String[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, false);
    }

    @Deprecated
    public TooltipListEntry(String fieldName, @Nullable Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, requiresRestart);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Optional<String[]> tooltip;
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip()).isPresent() && tooltip.get().length > 0) {
            this.getScreen().queueTooltip(QueuedTooltip.create(new Point(mouseX, mouseY), tooltip.get()));
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        return mouseX >= x && mouseY >= y && mouseX <= x + entryWidth && mouseY <= y + entryHeight && this.getParent().isMouseOver(mouseX, mouseY);
    }

    public Optional<String[]> getTooltip() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get();
        }
        return Optional.empty();
    }

    public @Nullable Supplier<Optional<String[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }
}

