/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import thut.core.common.network.TileUpdate;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;

public class ControllerBlock
extends Block {
    public static final BooleanProperty CALLED = BooleanProperty.func_177716_a((String)"called");
    public static final BooleanProperty MASKED = BooleanProperty.func_177716_a((String)"masked");
    public static final BooleanProperty CURRENT = BooleanProperty.func_177716_a((String)"current");

    public ControllerBlock(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)CALLED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)MASKED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CURRENT, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ControllerTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CALLED});
        builder.func_206894_a(new IProperty[]{CURRENT});
        builder.func_206894_a(new IProperty[]{MASKED});
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)blockAccess.func_175625_s(pos);
        boolean here = (Boolean)blockState.func_177229_b((IProperty)CURRENT);
        boolean called = (Boolean)blockState.func_177229_b((IProperty)CALLED);
        if (te.isSideOn(side = side.func_176734_d())) {
            if (te.isCallPanel(side)) {
                return called ? 15 : 0;
            }
            if (te.isFloorDisplay(side)) {
                return here ? 15 : 0;
            }
            return here ? 5 : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)blockAccess.func_175625_s(pos);
        boolean here = (Boolean)blockState.func_177229_b((IProperty)CURRENT);
        boolean called = (Boolean)blockState.func_177229_b((IProperty)CALLED);
        if (te.isSideOn(side = side.func_176734_d())) {
            if (te.isCallPanel(side)) {
                return called ? 15 : 0;
            }
            if (te.isFloorDisplay(side)) {
                return here ? 15 : 0;
            }
        }
        return 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)world.func_175625_s(pos);
        side = side.func_176734_d();
        boolean called = (Boolean)state.func_177229_b((IProperty)CALLED);
        return te.isCallPanel(side) && !called;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        boolean linkerOrStick;
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        Direction side = hit.func_216354_b();
        boolean bl = linkerOrStick = heldItem.func_77973_b() == Items.field_151055_y || heldItem.func_77973_b() == TechCore.LINKER;
        if (linkerOrStick && playerIn.func_225608_bj_()) {
            ControllerTile te = (ControllerTile)worldIn.func_175625_s(pos);
            if (te == null) {
                return ActionResultType.PASS;
            }
            if (te.isSideOn(side)) {
                te.setSide(side, false);
                if (!te.func_145831_w().field_72995_K) {
                    TileUpdate.sendUpdate((TileEntity)te);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        ControllerTile te = (ControllerTile)worldIn.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (!linkerOrStick && side == Direction.DOWN) {
            if (heldItem.func_77973_b() instanceof BlockItem) {
                BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(playerIn, handIn, hit));
                te.copiedState = ((BlockItem)heldItem.func_77973_b()).func_179223_d().func_196258_a(context);
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)MASKED, (Comparable)Boolean.valueOf(true)));
                if (!te.func_145831_w().field_72995_K) {
                    TileUpdate.sendUpdate((TileEntity)te);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (!te.isSideOn(side) || heldItem.func_77973_b() == Items.field_151055_y) {
            if (linkerOrStick) {
                if (!worldIn.field_72995_K) {
                    te.setSide(side, !te.isSideOn(side));
                    if (worldIn instanceof ServerWorld) {
                        te.sendUpdate((ServerPlayerEntity)playerIn);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (te.isSideOn(side)) {
            if (heldItem.func_77973_b() == TechCore.LINKER) {
                if (!(worldIn.field_72995_K || te.isEditMode(side) || te.isFloorDisplay(side))) {
                    te.setSidePage(side, (te.getSidePage(side) + 1) % 8);
                    if (playerIn instanceof ServerPlayerEntity) {
                        te.sendUpdate((ServerPlayerEntity)playerIn);
                    }
                    TileUpdate.sendUpdate((TileEntity)te);
                }
                return ActionResultType.SUCCESS;
            }
            if (!playerIn.func_225608_bj_()) {
                float hitX = (float)hit.func_216347_e().field_72450_a;
                float hitY = (float)hit.func_216347_e().field_72448_b;
                float hitZ = (float)hit.func_216347_e().field_72449_c;
                return te.doButtonClick((LivingEntity)playerIn, side, hitX, hitY, hitZ) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        if (playerIn.func_225608_bj_() && handIn == Hand.MAIN_HAND && playerIn instanceof ServerPlayerEntity) {
            boolean sideOn = !te.isSideOn(side);
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.side." + (sideOn ? "on" : "off"), new Object[0]));
            if (sideOn) {
                boolean call = te.isCallPanel(side);
                boolean edit = te.isEditMode(side);
                boolean display = te.isFloorDisplay(side);
                if (edit) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.side.edit", new Object[0]));
                } else if (call) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.side.call", new Object[0]));
                } else if (display) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.side.display", new Object[0]));
                } else {
                    int page = te.getSidePage(side);
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.side.page", new Object[]{page}));
                }
            }
        }
        return ActionResultType.PASS;
    }
}

