/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import net.minecraftforge.eventbus.api.Event;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.maths.Vector3;
import thut.core.common.network.TileUpdate;
import thut.tech.common.blocks.lift.ControllerBlock;
import thut.tech.common.blocks.lift.ControllerUpdate;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.network.PacketLift;

public class ControllerTile
extends TileEntity
implements ITickableTileEntity {
    public static TileEntityType<? extends TileEntity> TYPE;
    public int power = 0;
    public int prevPower = 1;
    private EntityLift lift;
    public BlockState copiedState = null;
    boolean listNull = false;
    List<Entity> list = new ArrayList<Entity>();
    Vector3 here;
    public ControllerTile rootNode;
    public Vector<ControllerTile> connected = new Vector();
    Direction sourceSide;
    boolean loaded = false;
    public int floor = 0;
    public UUID liftID = null;
    UUID empty = new UUID(0L, 0L);
    private byte[] sides = new byte[6];
    private byte[] sidePages = new byte[6];
    int tries = 0;
    public boolean toClear = false;
    public boolean first = true;
    public boolean read = false;
    public boolean redstone = true;
    public boolean powered = false;
    public boolean[] callFaces = new boolean[6];
    public boolean[] editFace = new boolean[6];
    public boolean[] floorDisplay = new boolean[6];
    private int tick = 0;

    public ControllerTile() {
        super(TYPE);
    }

    public ControllerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void buttonPress(int button, boolean callPanel) {
        if (callPanel && this.getLift() != null) {
            this.getLift().call(this.floor);
        } else if (button != 0 && button <= this.getLift().maxFloors() && this.getLift() != null && this.getLift().hasFloor(button)) {
            if (button != this.floor && this.getLift().getCurrentFloor() == this.floor) {
                this.getLift().setCurrentFloor(-1);
            }
            this.getLift().call(button);
        }
    }

    public boolean checkSides() {
        List check = this.field_145850_b.func_217357_a(EntityLift.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - 1.0, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 - 1.0, (double)this.func_174877_v().func_177958_n() + 0.5 + 1.0, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5 + 1.0));
        if (check != null && check.size() > 0) {
            this.setLift((EntityLift)((Object)check.get(0)));
            this.liftID = this.getLift().func_110124_au();
        }
        return check != null && !check.isEmpty();
    }

    public String connectionInfo() {
        String ret = "";
        return "";
    }

    public boolean doButtonClick(LivingEntity clicker, Direction side, float hitX, float hitY, float hitZ) {
        boolean valid;
        int button = this.getButtonFromClick(side, hitX, hitY, hitZ);
        boolean bl = valid = this.getLift() != null && this.getLift().hasFloor(button);
        if (!this.isSideOn(side)) {
            return false;
        }
        if (this.isEditMode(side)) {
            if (!this.func_145831_w().field_72995_K) {
                String message = "msg.callPanel";
                switch (button) {
                    case 1: {
                        this.callFaces[side.ordinal()] = !this.isCallPanel(side);
                        this.floorDisplay[side.ordinal()] = false;
                        clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{this.isCallPanel(side)}));
                        break;
                    }
                    case 2: {
                        this.floorDisplay[side.ordinal()] = !this.isFloorDisplay(side);
                        this.callFaces[side.ordinal()] = false;
                        message = "msg.floorDisplay";
                        clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{this.isFloorDisplay(side)}));
                        break;
                    }
                    case 13: {
                        if (this.getLift() == null) break;
                        this.setLift(null);
                        break;
                    }
                    case 16: {
                        this.editFace[side.ordinal()] = false;
                        message = "msg.editMode";
                        clicker.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[]{false}));
                    }
                }
                if (clicker instanceof ServerPlayerEntity) {
                    this.sendUpdate((ServerPlayerEntity)clicker);
                }
            }
            return true;
        }
        if (this.isFloorDisplay(side)) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            boolean callPanel = this.isCallPanel(side);
            PacketLift.sendButtonPress(this.getLift(), this.func_174877_v(), button, callPanel);
        }
        if (clicker instanceof ServerPlayerEntity) {
            this.sendUpdate((ServerPlayerEntity)clicker);
        }
        return valid;
    }

    public int getButtonFromClick(Direction side, double x, double y, double z) {
        int ret = 0;
        x -= (double)this.func_174877_v().func_177958_n();
        y -= (double)this.func_174877_v().func_177956_o();
        z -= (double)this.func_174877_v().func_177952_p();
        x %= 1.0;
        y %= 1.0;
        z %= 1.0;
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        int page = this.getSidePage(side);
        switch (side.func_176745_a()) {
            case 0: {
                return 0 + 16 * page;
            }
            case 1: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 2: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 3: {
                ret = 1 + (int)(x * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 4: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)(z * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 5: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
        }
        return 0 + 16 * page;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = IForgeTileEntity.INFINITE_EXTENT_AABB;
        return bb;
    }

    public int getSidePage(Direction side) {
        if (this.isEditMode(side)) {
            return 0;
        }
        return this.sidePages[side.func_176745_a()];
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        return this.func_189515_b(tag);
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public boolean isSideOn(Direction side) {
        boolean state = true;
        byte byte0 = this.sides[side.func_176745_a()];
        return (byte0 & 1) != 0;
    }

    public boolean isCallPanel(Direction side) {
        return this.callFaces[side.func_176745_a()];
    }

    public boolean isFloorDisplay(Direction side) {
        return this.floorDisplay[side.func_176745_a()];
    }

    public boolean isEditMode(Direction side) {
        return this.editFace[side.func_176745_a()];
    }

    public void func_145839_a(CompoundNBT par1) {
        super.func_145839_a(par1);
        this.floor = par1.func_74762_e("floor");
        this.lift = null;
        this.liftID = new UUID(par1.func_74763_f("idMost"), par1.func_74763_f("idLess"));
        this.sides = par1.func_74770_j("sides");
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.callFaces[face.ordinal()] = par1.func_74767_n(face + "Call");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.editFace[face.ordinal()] = par1.func_74767_n(face + "Edit");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.floorDisplay[face.ordinal()] = par1.func_74767_n(face + "Display");
        }
        if (this.sides.length != 6) {
            this.sides = new byte[6];
        }
        this.sidePages = par1.func_74770_j("sidePages");
        if (this.sidePages.length != 6) {
            this.sidePages = new byte[6];
        }
        if (par1.func_74764_b("state")) {
            CompoundNBT state = par1.func_74775_l("state");
            this.copiedState = NBTUtil.func_190008_d((CompoundNBT)state);
        }
    }

    public void sendUpdate(ServerPlayerEntity player) {
        if (this.field_145850_b instanceof IBlockEntityWorld) {
            return;
        }
        TileUpdate.sendUpdate((TileEntity)this);
    }

    public void setFloor(int floor) {
        if (this.getLift() == null) {
            return;
        }
        if (this.getLift().setFoor(this, floor)) {
            this.floor = floor;
            this.func_70296_d();
        }
    }

    public void setLift(EntityLift lift) {
        if (lift == null && this.lift != null) {
            this.lift.setFoor(null, this.floor);
        }
        this.lift = lift;
        this.liftID = lift != null ? lift.func_110124_au() : null;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileUpdate.sendUpdate((TileEntity)this);
        }
    }

    public void setSide(Direction side, boolean flag) {
        boolean state = true;
        byte byte0 = this.sides[side.func_176745_a()];
        if (side.func_176745_a() < 2) {
            return;
        }
        this.sides[side.func_176745_a()] = flag ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFFFFFFFE);
        this.func_70296_d();
    }

    public void setSidePage(Direction side, int page) {
        this.sidePages[side.func_176745_a()] = (byte)page;
    }

    public void setWorldObj(World worldIn) {
        IBlockEntity blockEntity;
        this.field_145850_b = worldIn;
        if (worldIn instanceof IBlockEntityWorld && (blockEntity = ((IBlockEntityWorld)worldIn).getBlockEntity()) instanceof EntityLift) {
            this.setLift((EntityLift)blockEntity);
        }
    }

    public void func_73660_a() {
        if (this.here == null) {
            this.here = Vector3.getNewVector();
        }
        this.here.set((Object)this);
        EntityLift lift = this.getLift();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.field_145850_b instanceof IBlockEntityWorld) {
            return;
        }
        if (!(this.floor <= 0 || lift != null && lift.func_70089_S())) {
            this.setLift(null);
            lift = null;
            this.floor = 0;
        }
        if (lift == null && this.tick++ % 50 == 0) {
            for (Direction side : Direction.values()) {
                ControllerTile te;
                TileEntity t = this.here.getTileEntity((IBlockReader)this.field_145850_b, side);
                this.here.getBlock((IBlockReader)this.field_145850_b, side);
                if (!(t instanceof ControllerTile) || (te = (ControllerTile)t).getLift() == null) continue;
                lift = te.getLift();
                this.setLift(lift);
                this.floor = te.floor;
                this.func_70296_d();
                break;
            }
        }
        if (lift == null) {
            return;
        }
        if (this.floor > 0) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean current = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CURRENT);
            boolean called = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CALLED);
            int yWhenLiftHere = this.getLift().getFloorPos(this.floor);
            if ((int)Math.round(this.getLift().field_70163_u) == yWhenLiftHere) {
                lift.setCurrentFloor(this.floor);
            } else if (this.getLift().getCurrentFloor() == this.floor) {
                lift.setCurrentFloor(-1);
            }
            if (!this.field_145850_b.field_72995_K) {
                boolean shouldBeCalled;
                boolean shouldBeCurrent = lift.func_180425_c().func_177956_o() == yWhenLiftHere;
                boolean bl = shouldBeCalled = lift.getCalled() && lift.getDestY() == (float)yWhenLiftHere;
                if (current && !shouldBeCurrent) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)ControllerBlock.CURRENT, (Comparable)Boolean.valueOf(false)));
                } else if (!current && shouldBeCurrent) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)ControllerBlock.CURRENT, (Comparable)Boolean.valueOf(true)));
                }
                if (called && !shouldBeCalled) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)ControllerBlock.CALLED, (Comparable)Boolean.valueOf(false)));
                } else if (!called && shouldBeCalled) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)ControllerBlock.CALLED, (Comparable)Boolean.valueOf(true)));
                }
                current = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CURRENT);
                called = (Boolean)state.func_177229_b((IProperty)ControllerBlock.CALLED);
                if (!current && !called) {
                    for (Direction facing : Direction.values()) {
                        int power;
                        if (!this.isCallPanel(facing) || (power = this.field_145850_b.func_175651_c(this.func_174877_v(), facing.func_176734_d())) <= 0) continue;
                        lift.call(this.floor);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new ControllerUpdate(this));
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT par1) {
        super.func_189515_b(par1);
        par1.func_74768_a("floor", this.floor);
        par1.func_74773_a("sides", this.sides);
        par1.func_74773_a("sidePages", this.sidePages);
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Call", this.callFaces[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Edit", this.editFace[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.func_74757_a(face + "Display", this.floorDisplay[face.ordinal()]);
        }
        if (this.lift != null) {
            this.liftID = this.lift.func_110124_au();
        }
        if (this.liftID != null) {
            par1.func_74772_a("idLess", this.liftID.getLeastSignificantBits());
            par1.func_74772_a("idMost", this.liftID.getMostSignificantBits());
        }
        if (this.copiedState != null) {
            CompoundNBT state = NBTUtil.func_190009_a((BlockState)this.copiedState);
            par1.func_218657_a("state", (INBT)state);
        }
        return par1;
    }

    public EntityLift getLift() {
        if (this.liftID == null) {
            return null;
        }
        if (this.lift == null) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.func_145831_w());
            if (this.lift == null) {
                this.setLift(null);
            } else {
                this.setLift(this.lift);
                if (this.floor > 0 && !this.getLift().hasFloor(this.floor)) {
                    this.setFloor(this.floor);
                }
            }
        }
        return this.lift;
    }
}

