/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.core.common.ThutCore;
import thut.core.common.network.EntityUpdate;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.entity.LiftInteractHandler;

public class EntityLift
extends BlockEntityBase {
    public static final EntityType<EntityLift> TYPE = new BlockEntityBase.BlockEntityType(EntityLift::new);
    static final DataParameter<Integer> DESTINATIONFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Float> DESTINATIONYDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONXDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONZDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Integer> CURRENTFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Boolean> CALLEDDW = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187198_h);
    static final DataParameter<Float> SPEEDUP = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> SPEEDDOWN = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> SPEEDSIDE = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> ACCEL = EntityDataManager.func_187226_a(EntityLift.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    public IEnergyStorage energy = null;
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    private final int[] floors = new int[128];
    private final int[] hasFloors = new int[128];
    private final Vector3f velocity = new Vector3f();
    private Vec3d motion = new Vec3d(0.0, 0.0, 0.0);
    EntitySize field_213325_aI;

    public static EntityLift getLiftFromUUID(UUID liftID, World world) {
        Entity e;
        if (world instanceof ServerWorld && (e = ((ServerWorld)world).func_217461_a(liftID)) instanceof EntityLift) {
            return (EntityLift)e;
        }
        return LiftTracker.liftMap.get(liftID);
    }

    public EntityLift(EntityType<EntityLift> type, World par1World) {
        super(type, par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
    }

    public void accelerate() {
        this.field_70177_z = 0.0f;
        if (this.isServerWorld() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
            this.setDestX((float)this.field_70165_t);
            this.setCalled(false);
        } else {
            this.toMoveX = (double)this.getDestX() != this.field_70165_t;
            this.toMoveY = (double)this.getDestY() != this.field_70163_u;
            boolean bl = this.toMoveZ = (double)this.getDestZ() != this.field_70161_v;
        }
        if (!(this.toMoveX || this.toMoveY || this.toMoveZ)) {
            this.setCalled(false);
        }
        if (!this.toMoveX) {
            this.velocity.x = (float)((double)this.velocity.x * 0.5);
        }
        if (!this.toMoveZ) {
            this.velocity.z = (float)((double)this.velocity.z * 0.5);
        }
        if (!this.toMoveY) {
            this.velocity.y = (float)((double)this.velocity.y * 0.5);
        }
        if (this.getCalled()) {
            double speedDown = this.getSpeedDown();
            double speedHoriz = this.getSpeedHoriz();
            double speedUp = this.getSpeedUp();
            if (this.toMoveY) {
                float destY = this.getDestY();
                if (Math.abs((double)destY - this.field_70163_u) < 0.01) {
                    this.func_70107_b(this.field_70165_t, destY, this.field_70161_v);
                    this.toMoveY = false;
                    this.velocity.y = 0.0f;
                } else {
                    double dy = this.getSpeed(this.field_70163_u, destY, this.velocity.y, speedUp, speedDown);
                    this.velocity.y = (float)dy;
                }
            }
            if (this.toMoveX) {
                float destX = this.getDestX();
                if (Math.abs((double)destX - this.field_70165_t) < 0.01) {
                    this.func_70107_b(destX, this.field_70163_u, this.field_70161_v);
                    this.toMoveX = false;
                    this.velocity.x = 0.0f;
                } else {
                    double dx = this.getSpeed(this.field_70165_t, destX, this.velocity.x, speedHoriz, speedHoriz);
                    this.velocity.x = (float)dx;
                }
            }
            if (this.toMoveZ) {
                float destZ = this.getDestZ();
                if (Math.abs((double)destZ - this.field_70161_v) < 0.01) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, destZ);
                    this.toMoveZ = false;
                    this.velocity.z = 0.0f;
                } else {
                    double dz = this.getSpeed(this.field_70161_v, destZ, this.velocity.z, speedHoriz, speedHoriz);
                    this.velocity.z = (float)dz;
                }
            }
        }
        this.func_213293_j(this.velocity.x, this.velocity.y, this.velocity.z);
    }

    public void func_226288_n_(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.field_70170_p.func_212866_a_((int)Math.floor(this.field_70165_t) >> 4, (int)Math.floor(this.field_70161_v) >> 4);
        }
    }

    public Vec3d func_213322_ci() {
        return this.motion;
    }

    public void func_213317_d(Vec3d vec) {
        this.motion = vec;
    }

    public void call(int floor) {
        if (floor > 0 && floor <= this.floors.length) {
            if (!this.isServerWorld()) {
                return;
            }
            if (this.hasFloor(floor)) {
                this.callYValue(this.getFloorPos(floor));
                this.setDestinationFloor(floor);
                ThutCore.LOGGER.debug("Lift Called to floor: " + floor);
            }
        } else {
            ThutCore.LOGGER.error("Set floor out of range!");
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    protected boolean checkAccelerationConditions() {
        return this.consumePower();
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.getCalled()) {
            return true;
        }
        if (this.energy == null) {
            this.energy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        }
        if (this.energy == null) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = Vector3.getNewVector().set((Object)this.boundMax.func_177973_b((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        int energyCost = (int)(Math.abs((double)this.getDestY() - this.field_70163_u) * (double)ENERGYCOST * volume * 0.01);
        int canExtract = this.energy.extractEnergy(energyCost = Math.max(energyCost, 1), true);
        if (canExtract == energyCost) {
            power = true;
            this.energy.extractEnergy(energyCost, false);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY((float)this.field_70163_u);
            this.setCalled(false);
            this.toMoveY = false;
        }
        return power;
    }

    protected BlockEntityInteractHandler createInteractHandler() {
        return new LiftInteractHandler(this);
    }

    public void doMotion() {
        if (!this.toMoveX) {
            this.velocity.x = 0.0f;
        }
        if (!this.toMoveY) {
            this.velocity.y = 0.0f;
        }
        if (!this.toMoveZ) {
            this.velocity.z = 0.0f;
        }
        this.func_213293_j(this.velocity.x, this.velocity.y, this.velocity.z);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public boolean getCalled() {
        return (Boolean)this.field_70180_af.func_187225_a(CALLEDDW);
    }

    public int getCurrentFloor() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONFLOORDW);
    }

    public float getDestX() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONXDW)).floatValue();
    }

    public float getDestY() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONYDW)).floatValue();
    }

    public float getDestZ() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONZDW)).floatValue();
    }

    public float getSpeedUp() {
        return ((Float)this.field_70180_af.func_187225_a(SPEEDUP)).floatValue();
    }

    public float getSpeedDown() {
        return ((Float)this.field_70180_af.func_187225_a(SPEEDDOWN)).floatValue();
    }

    public float getSpeedHoriz() {
        return ((Float)this.field_70180_af.func_187225_a(SPEEDSIDE)).floatValue();
    }

    public float getAccel() {
        return ((Float)this.field_70180_af.func_187225_a(ACCEL)).floatValue();
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.field_213325_aI == null) {
            this.field_213325_aI = EntitySize.func_220311_c((float)(1 + this.getMax().func_177958_n() - this.getMin().func_177958_n()), (float)this.getMax().func_177956_o());
        }
        return this.field_213325_aI;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        LiftTracker.liftMap.put(this.func_110124_au(), this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        LiftTracker.liftMap.remove(this.func_110124_au(), (Object)this);
    }

    protected void onGridAlign() {
        this.setCalled(false);
    }

    protected void preColliderTick() {
    }

    public void func_70037_a(CompoundNBT arg0) {
        super.func_70037_a(arg0);
        CompoundNBT tag = arg0.func_74775_l("floors");
        for (int i = 0; i < this.hasFloors.length; ++i) {
            int num;
            if (!tag.func_74764_b("" + i)) continue;
            int floor = tag.func_74762_e("" + i);
            this.hasFloors[i] = num = tag.func_74762_e("_" + i);
            this.floors[i] = floor;
        }
        if (arg0.func_186855_b("owner")) {
            this.owner = arg0.func_186857_a("owner");
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATIONFLOORDW, (Object)0);
        this.field_70180_af.func_187214_a(DESTINATIONYDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONXDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONZDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENTFLOORDW, (Object)-1);
        this.field_70180_af.func_187214_a(CALLEDDW, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(SPEEDUP, (Object)Float.valueOf((float)TechCore.config.LiftSpeedUp));
        this.field_70180_af.func_187214_a(SPEEDDOWN, (Object)Float.valueOf((float)TechCore.config.LiftSpeedDown));
        this.field_70180_af.func_187214_a(SPEEDSIDE, (Object)Float.valueOf((float)TechCore.config.LiftSpeedSideways));
        this.field_70180_af.func_187214_a(ACCEL, (Object)Float.valueOf((float)TechCore.config.LiftAcceleration));
    }

    private void setCalled(boolean called) {
        this.field_70180_af.func_187227_b(CALLEDDW, (Object)called);
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_187227_b(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_187227_b(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestX(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestY(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestZ(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.setCalled(true);
    }

    public boolean setFoor(ControllerTile te, int floor) {
        if (--floor < 0 || floor >= this.floors.length) {
            return false;
        }
        if (te != null) {
            int prev;
            boolean changed = false;
            if (this.hasFloors[floor] <= 0) {
                this.floors[floor] = te.func_174877_v().func_177956_o() - 2;
            }
            int n = floor;
            this.hasFloors[n] = this.hasFloors[n] + 1;
            changed = true;
            if (changed && (prev = te.floor - 1) != -1 && prev != floor && this.hasFloors[prev] > 0) {
                int n2 = prev;
                this.hasFloors[n2] = this.hasFloors[n2] - 1;
            }
        } else if (this.hasFloors[floor] > 0) {
            int n = floor;
            this.hasFloors[n] = this.hasFloors[n] - 1;
            if (this.hasFloors[floor] <= 0) {
                this.floors[floor] = 0;
            }
        }
        if (this.isServerWorld()) {
            EntityUpdate.sendEntityUpdate((Entity)this);
        }
        return true;
    }

    public void setFloorPos(int floor, int posY) {
        if (--floor >= 0 && floor < this.floors.length) {
            this.floors[floor] = posY;
        }
        ThutCore.LOGGER.error("Set floor out of range!");
    }

    public int getFloorPos(int floor) {
        if (--floor >= 0 && floor < this.floors.length) {
            return this.floors[floor];
        }
        ThutCore.LOGGER.error("Requested floor out of range!");
        return 0;
    }

    public boolean hasFloor(int floor) {
        if (--floor >= 0 && floor < this.hasFloors.length) {
            return this.hasFloors[floor] > 0;
        }
        ThutCore.LOGGER.error("Checked floor out of range!");
        return false;
    }

    public int maxFloors() {
        return this.hasFloors.length;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public void setSize(EntitySize size) {
        this.field_213325_aI = size;
    }

    public void setTiles(TileEntity[][][] tiles) {
        super.setTiles(tiles);
        TileEntity[][][] tileEntityArray = tiles;
        int n = tileEntityArray.length;
        for (int i = 0; i < n; ++i) {
            TileEntity[][] tileArrArr;
            TileEntity[][] tileEntityArray2 = tileArrArr = tileEntityArray[i];
            int n2 = tileEntityArray2.length;
            for (int j = 0; j < n2; ++j) {
                TileEntity[] tileArr;
                for (TileEntity tile : tileArr = tileEntityArray2[j]) {
                    if (!(tile instanceof ControllerTile)) continue;
                    ((ControllerTile)tile).setLift(this);
                    ((ControllerTile)tile).setWorldObj((World)this.getFakeWorld());
                }
            }
        }
    }

    public void func_213281_b(CompoundNBT arg0) {
        super.func_213281_b(arg0);
        CompoundNBT tag = new CompoundNBT();
        for (int i = 0; i < this.hasFloors.length; ++i) {
            if (this.hasFloors[i] <= 0) continue;
            tag.func_74768_a("" + i, this.floors[i]);
            tag.func_74768_a("_" + i, this.hasFloors[i]);
        }
        arg0.func_218657_a("floors", (INBT)tag);
        if (this.owner != null) {
            arg0.func_186854_a("owner", this.owner);
        }
    }

    public static class LiftTracker {
        protected static final Map<UUID, EntityLift> liftMap = Maps.newHashMap();
    }
}

