/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.compat.cct;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thut.core.common.ThutCore;
import thut.tech.common.blocks.lift.ControllerTile;

public class Peripherals {
    private static boolean reged = false;

    public static void register() {
        if (!reged) {
            reged = true;
            ThutCore.LOGGER.info("Registering CC Peripheral!");
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new ElevatorPeripheralProvider());
        }
    }

    public static class ElevatorPeripheralProvider
    implements IPeripheralProvider {
        public IPeripheral getPeripheral(World world, BlockPos pos, Direction side) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ControllerTile) {
                return new ElevatorPeripheral((ControllerTile)tile);
            }
            return null;
        }
    }

    public static class ElevatorPeripheral
    implements IPeripheral {
        public static String[] METHODS = new String[]{"move_by", "goto_floor", "find", "has"};
        private final ControllerTile tile;

        public ElevatorPeripheral(ControllerTile tile) {
            this.tile = tile;
        }

        public String getType() {
            return "lift";
        }

        public String[] getMethodNames() {
            return METHODS;
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            if (method != 3 && this.tile.getLift() == null) {
                throw new LuaException("No Elevator Linked!");
            }
            switch (method) {
                case 0: {
                    if (arguments.length != 2) {
                        throw new LuaException("Arguments: [x|y|z] [distance]");
                    }
                    String dir = ArgumentHelper.getString((Object[])arguments, (int)0);
                    int dist = ArgumentHelper.getInt((Object[])arguments, (int)1);
                    if (dir.equalsIgnoreCase("x")) {
                        this.tile.getLift().setDestX((float)(this.tile.getLift().field_70165_t + (double)dist));
                    }
                    if (dir.equalsIgnoreCase("y")) {
                        this.tile.getLift().setDestY((float)(this.tile.getLift().field_70163_u + (double)dist));
                    }
                    if (!dir.equalsIgnoreCase("z")) break;
                    this.tile.getLift().setDestZ((float)(this.tile.getLift().field_70161_v + (double)dist));
                    break;
                }
                case 1: {
                    if (arguments.length != 1) {
                        throw new LuaException("Arguments: [floor]");
                    }
                    int dist = ArgumentHelper.getInt((Object[])arguments, (int)0);
                    if (dist < 0) {
                        dist = 64 - dist;
                    }
                    if (dist - 1 >= this.tile.getLift().maxFloors()) {
                        throw new LuaException("Floor not in range");
                    }
                    if (!this.tile.getLift().hasFloor(dist)) {
                        throw new LuaException("Floor not found.");
                    }
                    this.tile.getLift().call(dist);
                    break;
                }
                case 2: {
                    return new Object[]{this.tile.getLift().field_70165_t, this.tile.getLift().field_70163_u, this.tile.getLift().field_70161_v};
                }
                case 3: {
                    return new Object[]{this.tile.liftID != null};
                }
            }
            return null;
        }

        public boolean equals(IPeripheral other) {
            return other instanceof ElevatorPeripheral && ((ElevatorPeripheral)other).tile == this.tile;
        }
    }
}

