/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EntityLift;

public class ControllerRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private static final ResourceLocation overlay = new ResourceLocation("thuttech:textures/blocks/overlay.png");
    private static final ResourceLocation overlay_1 = new ResourceLocation("thuttech:textures/blocks/overlay_1.png");
    private static final ResourceLocation font = new ResourceLocation("thuttech:textures/blocks/font.png");
    private static final ResourceLocation call = new ResourceLocation("thuttech:textures/blocks/overlay_call.png");
    private static final ResourceLocation disp = new ResourceLocation("thuttech:textures/blocks/overlay_display.png");
    private static final ResourceLocation exit = new ResourceLocation("thuttech:textures/blocks/overlay_exit.png");
    private static final ResourceLocation unlink = new ResourceLocation("thuttech:textures/blocks/overlay_unlink.png");
    private static final RenderState.TransparencyState TRANSP = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend());
    private static final RenderState.AlphaState ALPHA = new RenderState.AlphaState(0.003921569f);
    private static final RenderState.WriteMaskState MASK = new RenderState.WriteMaskState(true, true);
    private static RenderType NUMBERS = ControllerRenderer.makeType(font);
    private static final RenderType OVERLAY_1 = ControllerRenderer.makeType(overlay_1);
    private static final RenderType OVERLAY = ControllerRenderer.makeType(overlay);
    private static final RenderType CALL = ControllerRenderer.makeType(call);
    private static final RenderType DISP = ControllerRenderer.makeType(disp);
    private static final RenderType EXIT = ControllerRenderer.makeType(exit);
    private static final RenderType UNLINK = ControllerRenderer.makeType(unlink);

    private static void render(RenderType type, MatrixStack mat, IRenderTypeBuffer buff, float x1, float y1, float x2, float y2, float r, float g, float b, float a, float[] uvs) {
        ControllerRenderer.render(type, mat, buff, x1, y1, x2, y2, r, g, b, a, uvs[0], uvs[1], uvs[2], uvs[3]);
    }

    private static void render(RenderType type, MatrixStack mat, IRenderTypeBuffer buff, float x1, float y1, float x2, float y2, float r, float g, float b, float a, float u1, float u2, float v1, float v2) {
        IVertexBuilder buffer = buff.getBuffer(type);
        Matrix4f o = mat.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(o, x2, y2, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_181675_d();
        buffer.func_227888_a_(o, x2, y1, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_181675_d();
        buffer.func_227888_a_(o, x1, y1, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_181675_d();
        buffer.func_227888_a_(o, x1, y2, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_181675_d();
    }

    private static RenderType.State getState(ResourceLocation texture) {
        return RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, true)).func_228726_a_(TRANSP).func_228727_a_(MASK).func_228713_a_(ALPHA).func_228728_a_(false);
    }

    public static RenderType makeType(ResourceLocation tex) {
        return RenderType.func_228633_a_((String)tex.toString(), (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)ControllerRenderer.getState(tex));
    }

    public ControllerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void drawEditOverlay(MatrixStack mat, IRenderTypeBuffer buff, ControllerTile monitor, Direction side) {
        Color colour = monitor.callFaces[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(mat, buff, monitor, 1, colour, side, 0, 0.0f, CALL);
        colour = monitor.floorDisplay[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(mat, buff, monitor, 2, colour, side, 0, 0.0f, DISP);
        colour = monitor.getLift() != null ? new Color(255, 255, 255, 255) : new Color(0, 0, 0, 0);
        this.drawOverLay(mat, buff, monitor, 13, colour, side, 0, 0.0f, UNLINK);
        colour = new Color(255, 255, 255, 255);
        this.drawOverLay(mat, buff, monitor, 16, colour, side, 0, 0.0f, EXIT);
    }

    public void drawFloorNumbers(MatrixStack mat, IRenderTypeBuffer buffer, int page) {
        for (int floor = 1; floor <= 16; ++floor) {
            this.drawNumber(mat, buffer, floor + page * 16, floor);
        }
    }

    private void drawNumber(MatrixStack mat, IRenderTypeBuffer buffer, int number, int floor) {
        this.drawNumber(mat, buffer, number, floor, false);
    }

    private void drawNumber(MatrixStack mat, IRenderTypeBuffer buffer, int number, int floor, boolean wide) {
        boolean minus;
        mat.func_227860_a_();
        --floor;
        float dz = -0.006f;
        boolean bl = minus = number >= 64;
        if (minus) {
            number -= 64;
        }
        double x = (double)(3 - floor & 3) / 4.0;
        double y = (3.0 - (double)(floor >> 2)) / 4.0;
        if (wide) {
            x += -0.25;
        }
        int actFloor = number;
        float[] uvs = this.locationFromNumber(actFloor % 10);
        float[] uvs1 = this.locationFromNumber(actFloor / 10);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 1.0f;
        if (actFloor > 8) {
            mat.func_227861_a_(x + 0.01, y + 0.06, (double)-0.006f);
            float dx = minus ? -0.03f : 0.0f;
            float dy = -0.0f;
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f + dx, 0.0f, 0.15f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.1f + dx, 0.0f, 0.25f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs1);
            if (minus) {
                uvs = this.locationFromNumber(-3);
                dx = 0.135f;
                dy = -0.0175f;
                ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f + dx, 0.0f, 0.15f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            }
        } else {
            mat.func_227861_a_(x + 0.05, y + 0.06, (double)-0.006f);
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f, 0.0f, 0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            if (minus) {
                uvs = this.locationFromNumber(-3);
                float dx = 0.075f;
                ControllerRenderer.render(NUMBERS, mat, buffer, 0.075f, 0.0f, 0.22500001f, 0.15f, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            }
        }
        mat.func_227865_b_();
    }

    public void drawOverLay(MatrixStack mat, IRenderTypeBuffer buffer, ControllerTile monitor, int floor, Color colour, Direction side, int order, float shift, RenderType type) {
        if (floor > 0 && floor < 17) {
            mat.func_227860_a_();
            float dz = -0.001f * (float)(1 + order);
            double x = (double)(3 - --floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            float r = (float)colour.getRed() / 255.0f;
            float g = (float)colour.getGreen() / 255.0f;
            float b = (float)colour.getBlue() / 255.0f;
            float a = (float)colour.getAlpha() / 255.0f;
            mat.func_227861_a_(x, y, (double)dz);
            ControllerRenderer.render(type, mat, buffer, 0.0f, 0.0f, 0.25f + shift, 0.25f, r, g, b, a, 0.0f, 1.0f, 0.0f, 1.0f);
            mat.func_227865_b_();
        }
    }

    public void drawOverLay(MatrixStack mat, IRenderTypeBuffer buffer, ControllerTile monitor, int floor, Color colour, Direction side, boolean wide, int order) {
        if (!wide) {
            floor -= monitor.getSidePage(side) * 16;
        }
        RenderType type = wide ? OVERLAY_1 : OVERLAY;
        this.drawOverLay(mat, buffer, monitor, floor, colour, side, order, wide ? 0.25f : 0.0f, type);
    }

    public float[] locationFromNumber(int number) {
        float[] ret = new float[4];
        int index = 16 + number;
        int dx = index % 10;
        int dz = index / 10;
        ret[0] = (float)dx / 10.0f;
        ret[2] = (float)dz / 10.0f;
        ret[1] = (float)(1 + dx) / 10.0f;
        ret[3] = (float)(1 + dz) / 10.0f;
        return ret;
    }

    public void func_225616_a_(T tileentity, float partialTicks, MatrixStack mat, IRenderTypeBuffer buff, int combinedLightIn, int combinedOverlayIn) {
        BlockState copied;
        ControllerTile monitor = (ControllerTile)((Object)tileentity);
        int calledFloor = 0;
        int currentFloor = 0;
        boolean hasLinker = Screen.func_231173_s_();
        hasLinker = hasLinker && (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == TechCore.LINKER || Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() == TechCore.LINKER);
        EntityLift lift = monitor.getLift();
        if (lift != null) {
            calledFloor = lift.getCalled() ? lift.getDestinationFloor() : -1;
            currentFloor = lift.getCurrentFloor();
        }
        if ((copied = monitor.copiedState) != null) {
            BlockPos pos;
            mat.func_227860_a_();
            World world = monitor.func_145831_w();
            BlockPos randPos = pos = monitor.func_174877_v();
            if (world instanceof IBlockEntityWorld) {
                IBlockEntityWorld w = (IBlockEntityWorld)world;
                world = w.getWorld();
                randPos = BlockPos.field_177992_a;
            }
            IModelData data = Minecraft.func_71410_x().func_175602_ab().func_184389_a(copied).getModelData((IBlockDisplayReader)world, pos, copied, (IModelData)EmptyModelData.INSTANCE);
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)copied, (RenderType)type)) continue;
                BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
                IBakedModel model = blockRenderer.func_184389_a(copied);
                blockRenderer.func_175019_b().renderModel((IBlockDisplayReader)world, model, copied, pos, mat, buff.getBuffer(type), false, new Random(), copied.func_209533_a(randPos), combinedOverlayIn, data);
            }
            mat.func_227865_b_();
        }
        for (int i = 0; i < 6; ++i) {
            Color colour;
            Direction dir = Direction.func_82600_a((int)i);
            if (!monitor.isSideOn(dir)) continue;
            mat.func_227860_a_();
            float f = dir.func_185119_l();
            mat.func_227861_a_(0.5, 0.5, 0.5);
            mat.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(f + 180.0f));
            mat.func_227861_a_(-0.5, -0.5, -0.5);
            int a = 64;
            if (monitor.isEditMode(dir)) {
                this.drawEditOverlay(mat, buff, monitor, dir);
            } else if (monitor.isFloorDisplay(dir)) {
                colour = new Color(255, 255, 255, 255);
                mat.func_227861_a_(-0.5, -0.095, 0.0);
                this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 0);
                mat.func_227860_a_();
                mat.func_227861_a_(0.4, 0.0, 0.0);
                this.drawNumber(mat, buff, currentFloor, 1, true);
                mat.func_227865_b_();
            } else if (monitor.isCallPanel(dir)) {
                colour = new Color(255, 255, 255, 255);
                mat.func_227861_a_(-0.5, -0.095, 0.0);
                this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 0);
                if (calledFloor == monitor.floor) {
                    colour = new Color(255, 255, 0, a);
                    this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 1);
                } else if (currentFloor == monitor.floor) {
                    colour = new Color(0, 128, 255, a);
                    this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 2);
                }
                mat.func_227860_a_();
                mat.func_227861_a_(0.4, 0.0, 0.0);
                this.drawNumber(mat, buff, monitor.floor, 1, true);
                mat.func_227865_b_();
            } else {
                int page = monitor.getSidePage(dir);
                int pageShift = page * 16;
                if (lift == null) {
                    this.drawFloorNumbers(mat, buff, monitor.getSidePage(dir));
                    Color colour2 = new Color(255, 255, 255, 255);
                    for (int j = pageShift + 1; j <= 16 + pageShift; ++j) {
                        this.drawOverLay(mat, buff, monitor, j, colour2, dir, false, 0);
                    }
                    this.drawFloorNumbers(mat, buff, page);
                    mat.func_227865_b_();
                    continue;
                }
                Color mapped = new Color(255, 255, 255, 220);
                Color unmapped = new Color(255, 255, 255, 64);
                for (int floor = 1; floor <= 16; ++floor) {
                    int realFloor = floor + pageShift;
                    boolean hasFloor = lift.hasFloor(realFloor);
                    if (hasFloor) {
                        this.drawNumber(mat, buff, realFloor, floor);
                        this.drawOverLay(mat, buff, monitor, realFloor, mapped, dir, false, 0);
                        continue;
                    }
                    if (!hasLinker) continue;
                    this.drawNumber(mat, buff, realFloor, floor);
                    this.drawOverLay(mat, buff, monitor, realFloor, unmapped, dir, false, 0);
                }
                a = 128;
                Color colour3 = new Color(0, 255, 0, a);
                this.drawOverLay(mat, buff, monitor, monitor.floor, colour3, dir, false, 0);
                colour3 = new Color(255, 255, 0, a);
                this.drawOverLay(mat, buff, monitor, monitor.getLift().getDestinationFloor(), colour3, dir, false, 0);
                colour3 = new Color(0, 128, 255, a);
                this.drawOverLay(mat, buff, monitor, monitor.getLift().getCurrentFloor(), colour3, dir, false, 0);
            }
            mat.func_227865_b_();
        }
    }
}

