/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.core.common.ThutCore;
import thut.tech.common.TechCore;
import thut.tech.common.entity.EntityLift;

public class LiftInteractHandler
extends BlockEntityInteractHandler {
    public static boolean DROPSPARTS = true;
    final EntityLift lift;

    public LiftInteractHandler(EntityLift lift) {
        super((IBlockEntity)lift);
        this.lift = lift;
    }

    public ActionResultType interactInternal(PlayerEntity player, BlockPos pos, ItemStack stack, Hand hand) {
        return ActionResultType.PASS;
    }

    public ActionResultType processInitialInteract(PlayerEntity player, @Nullable ItemStack stack, Hand hand) {
        boolean shouldKillLiftOwned;
        boolean isElevatorItemOrStick = stack.func_77973_b() == Items.field_151055_y || stack.func_77973_b() == TechCore.LIFT;
        boolean isLinker = stack.func_77973_b() == TechCore.LINKER;
        boolean canEdit = this.lift.owner != null && player.func_110124_au().equals(this.lift.owner) || player.field_71075_bZ.field_75098_d;
        boolean shouldLinkLift = player.func_225608_bj_() && isLinker && canEdit;
        boolean shouldKillLiftUnowned = this.lift.owner == null;
        boolean shouldDisplayOwner = isLinker && canEdit;
        boolean bl = shouldKillLiftOwned = player.func_225608_bj_() && isElevatorItemOrStick && canEdit;
        if (shouldKillLiftUnowned) {
            ThutCore.LOGGER.error("Killing unowned Lift: " + (Object)((Object)this.lift));
            if (!this.lift.func_130014_f_().field_72995_K) {
                String message = "msg.lift.killed";
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.killed"), Util.field_240973_b_);
                if (DROPSPARTS) {
                    BlockPos max = this.lift.boundMax;
                    BlockPos min = this.lift.boundMin;
                    int dw = Math.max(max.func_177958_n() - min.func_177958_n(), max.func_177952_p() - min.func_177952_p());
                    int num = (dw + 1) * (max.func_177956_o() - min.func_177956_o() + 1);
                    stack = new ItemStack((IItemProvider)TechCore.LIFT);
                    stack.func_190920_e(num);
                    player.func_146097_a(stack, false, true);
                }
                this.lift.func_70106_y();
            }
            return ActionResultType.SUCCESS;
        }
        if (shouldLinkLift) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new CompoundNBT());
            }
            stack.func_77978_p().func_74778_a("lift", this.lift.func_189512_bd());
            String message = "msg.liftSet";
            if (!this.lift.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.liftSet"), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        if (shouldDisplayOwner) {
            if (!this.lift.func_130014_f_().field_72995_K && this.lift.owner != null) {
                PlayerEntity ownerentity = this.lift.func_130014_f_().func_217371_b(this.lift.owner);
                String message = "msg.lift.owner";
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.owner", new Object[]{ownerentity.func_200200_C_()}), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        if (shouldKillLiftOwned) {
            if (!this.lift.func_130014_f_().field_72995_K) {
                String message = "msg.lift.killed";
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.lift.killed"), Util.field_240973_b_);
                if (DROPSPARTS) {
                    BlockPos max = this.lift.boundMax;
                    BlockPos min = this.lift.boundMin;
                    int dw = Math.max(max.func_177958_n() - min.func_177958_n(), max.func_177952_p() - min.func_177952_p());
                    int num = (dw + 1) * (max.func_177956_o() - min.func_177956_o() + 1);
                    stack = new ItemStack((IItemProvider)TechCore.LIFT);
                    stack.func_190920_e(num);
                    player.func_146097_a(stack, false, true);
                }
                this.lift.func_70106_y();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

