/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api;

import java.util.Comparator;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Title {
    public static final Title NULL_TITLE = new Title("null", Rarity.COMMON);
    private String key;
    private String modid;
    private String langKey;
    private Rarity rarity;

    public Title() {
    }

    public Title(String key, Rarity rarity) {
        this.key = key;
        int colonIndex = key.indexOf(":");
        if (colonIndex == -1) {
            this.modid = "titles";
            this.langKey = key;
        } else {
            this.modid = key.substring(0, colonIndex);
            this.langKey = "title." + key.replaceAll("[\\s]", "_").replaceAll("[\\W]", ".");
        }
        this.rarity = rarity;
    }

    public String getKey() {
        return this.key;
    }

    public String getModid() {
        return this.modid;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public boolean isNull() {
        return this.equals(NULL_TITLE);
    }

    public ITextComponent getComponent(boolean isMasculine) {
        String modifiedLangKey = this.getLangKey();
        if (!isMasculine && ClientLanguageMap.func_74808_a().func_230506_b_(this.getLangKey() + ".f")) {
            modifiedLangKey = modifiedLangKey + ".f";
        }
        return new TranslationTextComponent(modifiedLangKey).func_240699_a_(this.getRarity().field_77937_e);
    }

    public String toString() {
        return String.format("(%s:%s, %s)", this.getModid(), this.getKey(), this.getRarity());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Title)) {
            return false;
        }
        Title temp = (Title)o;
        return this.getKey().equals(temp.key) && this.getRarity().equals((Object)temp.rarity);
    }

    public static class RarityComparator
    implements Comparator<Title> {
        @Override
        public int compare(Title o1, Title o2) {
            if (o1.rarity.ordinal() > o2.rarity.ordinal()) {
                return 1;
            }
            if (o1.rarity.ordinal() < o2.rarity.ordinal()) {
                return -1;
            }
            return 0;
        }
    }
}

