/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.gui;

import aurilux.titles.api.Title;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.api.capability.ITitles;
import aurilux.titles.client.Keybinds;
import aurilux.titles.client.gui.button.SimpleButtonOverride;
import aurilux.titles.client.gui.button.TitleButton;
import aurilux.titles.client.gui.button.ToggleImageButton;
import aurilux.titles.common.network.PacketHandler;
import aurilux.titles.common.network.messages.PacketSyncGenderSetting;
import aurilux.titles.common.network.messages.PacketSyncSelectedTitle;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiTitleSelection
extends Screen {
    private final ResourceLocation bgTexture = new ResourceLocation("titles", "textures/gui/title_selection.png");
    private final int NUM_COLS = 2;
    private final int NUM_ROWS = 6;
    protected final int MAX_PER_PAGE = 12;
    protected int page;
    protected int maxPages;
    private final int xSize = 308;
    private final int ySize = 218;
    protected int guiLeft;
    protected int guiTop;
    protected final int buttonHeight = 20;
    protected int leftOffset;
    protected int buttonFirstRowStart;
    protected int buttonTitleRowStart;
    protected int buttonSecondRowStart;
    private final List<Button> backButtons = new ArrayList<Button>();
    private final List<Button> forwardButtons = new ArrayList<Button>();
    private final List<Button> titleButtons = new ArrayList<Button>();
    protected PlayerEntity player;
    protected Title temporaryTitle;
    protected List<Title> titlesListCache;
    protected List<Title> titlesListFiltered;
    private boolean gender;
    private TextFieldWidget search;
    private final ITextComponent maleComp = new StringTextComponent("M").func_240699_a_(TextFormatting.BLUE);
    private final ITextComponent femaleComp = new StringTextComponent("F").func_240699_a_(TextFormatting.RED);

    public GuiTitleSelection(PlayerEntity player, ITitles cap) {
        super((ITextComponent)new StringTextComponent("Title Selection"));
        this.player = player;
        this.gender = cap.getGenderSetting();
        this.temporaryTitle = cap.getDisplayTitle();
        this.titlesListCache = new ArrayList<Title>(cap.getObtainedTitles());
        String playerName = player.func_200200_C_().getString();
        Title possibleContributor = TitlesAPI.internal().getTitle(playerName);
        if (!possibleContributor.isNull()) {
            this.titlesListCache.add(possibleContributor);
        }
        this.titlesListCache.sort(new Title.RarityComparator());
        this.titlesListFiltered = new ArrayList<Title>(this.titlesListCache);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.page = 1;
        this.updateMaxPages();
        this.guiLeft = (this.field_230708_k_ - 308) / 2;
        this.guiTop = (this.field_230709_l_ - 218) / 2 - 10;
        this.leftOffset = this.guiLeft + 34;
        this.buttonFirstRowStart = this.guiTop + 37;
        this.buttonTitleRowStart = this.buttonFirstRowStart + 23;
        this.buttonSecondRowStart = this.buttonTitleRowStart + 123;
        this.search = new TextFieldWidget(this.field_230712_o_, this.leftOffset + 65, this.buttonFirstRowStart + 1, 110, 18, (ITextComponent)new StringTextComponent("search"));
        this.func_230480_a_((Widget)this.search);
        this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset, this.buttonFirstRowStart, 60, 20, (ITextComponent)new TranslationTextComponent("gui.titles.random"), button -> this.chooseRandomTitle()));
        this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 180, this.buttonFirstRowStart, 60, 20, (ITextComponent)new TranslationTextComponent("gui.titles.none"), button -> {
            this.temporaryTitle = Title.NULL_TITLE;
        }));
        this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 45, this.buttonSecondRowStart, 60, 20, (ITextComponent)new TranslationTextComponent("gui.titles.cancel"), button -> this.exitScreen(false)));
        this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 135, this.buttonSecondRowStart, 60, 20, (ITextComponent)new TranslationTextComponent("gui.titles.confirm"), button -> this.exitScreen(true)));
        this.backButtons.add((Button)this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset, this.buttonSecondRowStart, 20, 20, ITextComponent.func_244388_a((String)"<<"), button -> this.setPage(1))));
        this.backButtons.add((Button)this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 22, this.buttonSecondRowStart, 20, 20, ITextComponent.func_244388_a((String)"<"), button -> this.setPage(this.page - 1))));
        this.forwardButtons.add((Button)this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 198, this.buttonSecondRowStart, 20, 20, ITextComponent.func_244388_a((String)">"), button -> this.setPage(this.page + 1))));
        this.forwardButtons.add((Button)this.func_230480_a_((Widget)new SimpleButtonOverride(this.leftOffset + 220, this.buttonSecondRowStart, 20, 20, ITextComponent.func_244388_a((String)">>"), button -> this.setPage(this.maxPages))));
        this.func_230480_a_((Widget)new ToggleImageButton(this.guiLeft + 3, this.buttonFirstRowStart, 20, 20, 200, 220, 20, this.bgTexture, 512, 512, button -> this.genderToggle((ToggleImageButton)button), this.gender));
        this.updateButtons();
    }

    private void updateMaxPages() {
        this.maxPages = Math.max(1, (int)Math.ceil((double)this.titlesListFiltered.size() / 12.0));
    }

    private void genderToggle(ToggleImageButton button) {
        button.toggle();
        this.gender = button.getValue();
        this.updateButtons();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.bgTexture);
        GuiTitleSelection.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)308, (int)218, (int)512, (int)512);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ITextComponent titledPlayerName = TitlesAPI.getFormattedTitle(this.temporaryTitle, this.player.func_200200_C_(), this.gender);
        GuiTitleSelection.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)titledPlayerName, (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 17), (int)0xFFFFFF);
        GuiTitleSelection.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)String.format("%s/%s", this.page, this.maxPages), (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 189), (int)0xFFFFFF);
        if (this.titlesListFiltered.size() == 0) {
            String emptyText = "gui.titles.titleselection.empty";
            if (this.titlesListCache.size() > 0) {
                emptyText = emptyText + ".filter";
            }
            GuiTitleSelection.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)emptyText, (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 109), (int)0xFFFFFF);
        }
    }

    protected void exitScreen(boolean update) {
        if (update) {
            PacketHandler.sendToServer(new PacketSyncSelectedTitle(this.player.func_110124_au(), this.temporaryTitle.getKey()));
        }
        PacketHandler.sendToServer(new PacketSyncGenderSetting(this.player.func_110124_au(), this.gender));
        this.func_231175_as__();
    }

    public void func_231023_e_() {
        this.search.func_146178_a();
        super.func_231023_e_();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.search.func_230999_j_()) {
            String s = this.search.func_146179_b();
            if (super.func_231046_a_(keyCode, scanCode, modifiers) && !Objects.equals(s, this.search.func_146179_b())) {
                this.parseSearch(this.search.func_146179_b());
            }
            return true;
        }
        if (Keybinds.openTitleSelection.getKeyBinding().func_197976_a(keyCode, scanCode) || this.getMinecraft().field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            this.exitScreen(false);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.search.func_230999_j_()) {
            String s = this.search.func_146179_b();
            if (this.search.func_231042_a_(codePoint, modifiers) && !Objects.equals(s, this.search.func_146179_b())) {
                this.parseSearch(this.search.func_146179_b());
            }
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    private void parseSearch(String searchText) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(searchText.toLowerCase().split("\\s")));
        String modFilter = "";
        String rarityFilter = "";
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            String part = (String)iter.next();
            if (part.startsWith("@") && modFilter.equals("")) {
                modFilter = part.substring(1);
                iter.remove();
            }
            if (!part.startsWith("#") || !rarityFilter.equals("")) continue;
            rarityFilter = part.substring(1);
            iter.remove();
        }
        String finalModFilter = modFilter;
        String finalRarityFilter = rarityFilter;
        this.titlesListFiltered = this.titlesListCache.stream().filter(t -> t.getModid().startsWith(finalModFilter)).filter(t -> {
            String rarityName = t.getRarity().name();
            for (String letter : finalRarityFilter.split("")) {
                if (!rarityName.startsWith(letter.toUpperCase())) continue;
                return true;
            }
            return false;
        }).filter(t -> {
            if (parts.size() < 1) {
                return true;
            }
            String titleString = TitlesAPI.getFormattedTitle(t, this.gender).getString().toLowerCase();
            for (String part : parts) {
                if (!titleString.contains(part)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        this.updateMaxPages();
        if (this.page > this.maxPages) {
            this.page = 1;
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        this.removeButtons(this.titleButtons);
        this.titleButtons.clear();
        int maxIndex = Math.min(this.page * 12, this.titlesListFiltered.size());
        if (this.page == 1) {
            this.backButtons.forEach(b -> {
                b.field_230693_o_ = false;
            });
        } else {
            this.backButtons.forEach(b -> {
                b.field_230693_o_ = true;
            });
        }
        if (maxIndex == this.titlesListFiltered.size()) {
            this.forwardButtons.forEach(b -> {
                b.field_230693_o_ = false;
            });
        } else {
            this.forwardButtons.forEach(b -> {
                b.field_230693_o_ = true;
            });
        }
        List<Title> titlesToDisplay = this.titlesListFiltered.subList((this.page - 1) * 12, maxIndex);
        int titleButtonWidth = 120;
        for (int i = 0; i < titlesToDisplay.size(); ++i) {
            int col = i % 2;
            int row = i / 2;
            int x = this.leftOffset + titleButtonWidth * col;
            int y = this.buttonTitleRowStart + row * 20;
            Button button = (Button)this.func_230480_a_((Widget)new TitleButton(x, y, titleButtonWidth, 20, b -> {
                this.temporaryTitle = ((TitleButton)b).getTitle();
            }, titlesToDisplay.get(i), this.gender));
            this.titleButtons.add(button);
        }
        this.field_230710_m_.addAll(this.titleButtons);
    }

    private void removeButtons(List<Button> list) {
        this.field_230710_m_.removeAll(list);
        this.field_230705_e_.removeAll(list);
    }

    private void setPage(int pageNum) {
        this.page = pageNum;
        this.updateButtons();
    }

    private void chooseRandomTitle() {
        this.temporaryTitle = this.titlesListFiltered.size() <= 0 ? Title.NULL_TITLE : this.titlesListFiltered.get(this.player.field_70170_p.field_73012_v.nextInt(this.titlesListFiltered.size()));
    }
}

