/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.handler;

import aurilux.titles.api.TitlesAPI;
import aurilux.titles.api.capability.ITitles;
import aurilux.titles.client.Keybinds;
import aurilux.titles.client.gui.GuiTitleSelection;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleRegistry;
import aurilux.titles.common.impl.TitlesCapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@Mod.EventBusSubscriber(modid="titles", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        if (Keybinds.openTitleSelection.func_151468_f() && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            TitlesAPI.getCapability((PlayerEntity)player).ifPresent(arg_0 -> ClientEventHandler.lambda$onClientTick$0((PlayerEntity)player, arg_0));
        }
    }

    @SubscribeEvent
    public static void onClientReceivedChat(ClientChatReceivedEvent event) {
        TranslationTextComponent textComponent;
        IFormattableTextComponent component = event.getMessage().func_230531_f_();
        if (component instanceof TranslationTextComponent && (textComponent = (TranslationTextComponent)component).func_150268_i().contains("chat.type.advancement.")) {
            String playerName = ((ITextComponent)((ITextComponent)textComponent.func_150271_j()[0]).func_150253_a().get(0)).func_150261_e();
            PlayerEntity player = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217369_A().stream().filter(pe -> pe.func_200200_C_().func_150261_e().equals(playerName)).findFirst().orElse(null);
            ITitles playerCap = (ITitles)TitlesAPI.getCapability(player).orElse((Object)new TitlesCapImpl());
            TranslationTextComponent advancementComp = (TranslationTextComponent)textComponent.func_150271_j()[1];
            Arrays.stream(advancementComp.func_150271_j()).filter(tc -> tc instanceof TranslationTextComponent).map(tc -> ((TranslationTextComponent)tc).func_150268_i()).map(ClientEventHandler::processKey).map(TitlesAPI.internal()::getTitle).filter(title -> !title.isNull()).findFirst().ifPresent(title -> {
                component.func_230529_a_((ITextComponent)new TranslationTextComponent("chat.advancement.append", new Object[]{TitlesAPI.getFormattedTitle(title, playerCap.getGenderSetting())}));
                event.setMessage((ITextComponent)component);
            });
        }
    }

    private static String processKey(String key) {
        ArrayList<String> keyParts = new ArrayList<String>(Arrays.asList(key.split("[/.:]")));
        keyParts.removeIf(part -> part.startsWith("advancement") || part.equals("title") || part.equals("name"));
        List modList = ModList.get().getMods().stream().map(ModInfo::getModId).filter(id -> !id.equals("forge") && !id.equals("FML") && !id.equals("mcp")).collect(Collectors.toList());
        String possibleModId = "";
        for (String part2 : keyParts) {
            if (!modList.contains(part2)) continue;
            possibleModId = part2;
            break;
        }
        if (!possibleModId.equals("")) {
            keyParts.remove(possibleModId);
            return possibleModId + ":" + String.join((CharSequence)"/", keyParts);
        }
        for (String modId : modList) {
            String testKey = modId + ":" + String.join((CharSequence)"/", keyParts);
            if (!TitleRegistry.INSTANCE.getObjectiveTitles().containsKey(testKey)) continue;
            return testKey;
        }
        TitlesMod.LOG.debug("Advancement key follows an unfamiliar pattern");
        return "";
    }

    private static /* synthetic */ void lambda$onClientTick$0(PlayerEntity player, ITitles cap) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiTitleSelection(player, cap));
    }
}

