/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.argument;

import aurilux.titles.api.Title;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.core.TitleRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;

public class TitleArgument
implements ArgumentType<Title> {
    private static final List<String> EXAMPLES = Arrays.asList("titles:captain", "titles:opulent", "titles:chicken_chaser");

    public static TitleArgument title() {
        return new TitleArgument();
    }

    public Title parse(StringReader reader) throws CommandSyntaxException {
        return TitlesAPI.internal().getTitle(ResourceLocation.func_195826_a((StringReader)reader).toString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(TitleRegistry.INSTANCE.getRegisteredTitles().keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static <S> Title getTitle(CommandContext<S> context, String name) {
        return (Title)context.getArgument(name, Title.class);
    }
}

