/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.core;

import aurilux.titles.api.Title;
import aurilux.titles.common.TitlesMod;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.item.Rarity;
import net.minecraftforge.fml.ModList;

public class TitleRegistry {
    public static final TitleRegistry INSTANCE = new TitleRegistry();
    private final Map<String, Title> objectiveTitles = new HashMap<String, Title>();
    private final Map<String, Title> lootTitles = new HashMap<String, Title>();
    private final Map<String, Title> contributorTitlesByUsername = new HashMap<String, Title>();
    private final Map<String, Title> contributorTitlesByTitleKey = new HashMap<String, Title>();

    private TitleRegistry() {
    }

    public Title getTitle(String titleKey) {
        return this.objectiveTitles.getOrDefault(titleKey, this.lootTitles.getOrDefault(titleKey, this.contributorTitlesByUsername.getOrDefault(titleKey, this.contributorTitlesByTitleKey.getOrDefault(titleKey, Title.NULL_TITLE))));
    }

    public Map<String, Title> getObjectiveTitles() {
        return new HashMap<String, Title>(this.objectiveTitles);
    }

    public Map<String, Title> getLootTitles() {
        return new HashMap<String, Title>(this.lootTitles);
    }

    public Map<String, Title> getRegisteredTitles() {
        HashMap<String, Title> temp = new HashMap<String, Title>();
        temp.putAll(this.objectiveTitles);
        temp.putAll(this.lootTitles);
        return temp;
    }

    public void init() {
        new ThreadContributorLoader();
        this.loadLootTitles();
    }

    public void registerTitle(Rarity rarity, String titleKey) {
        this.objectiveTitles.put(titleKey, new Title(titleKey, rarity));
    }

    private void loadLootTitles() {
        Optional container = ModList.get().getModContainerById("titles");
        container.ifPresent(c -> {
            try {
                Class<?> ownerClass = c.getMod().getClass();
                BufferedReader reader = new BufferedReader(new InputStreamReader(ownerClass.getResourceAsStream("/data/titles/loot_titles.json")));
                JsonObject titleData = new JsonParser().parse((Reader)reader).getAsJsonObject();
                if (titleData != null) {
                    for (Map.Entry entry : titleData.entrySet()) {
                        Rarity titleRarity = Rarity.valueOf((String)((String)entry.getKey()).toUpperCase());
                        if (titleRarity.equals((Object)Rarity.EPIC)) continue;
                        JsonArray titles = ((JsonElement)entry.getValue()).getAsJsonArray();
                        for (int i = 0; i < titles.size(); ++i) {
                            String key = titles.get(i).getAsString();
                            this.lootTitles.put(key, new Title(key, titleRarity));
                        }
                    }
                }
            }
            catch (Exception ex) {
                TitlesMod.LOG.error("Failed to load loot titles", (Throwable)ex);
            }
        });
    }

    private class ThreadContributorLoader
    extends Thread {
        private ThreadContributorLoader() {
            this.setName("Titles Contributor Loader");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Aurilux/Titles/master/contributors.properties");
                Properties props = new Properties();
                InputStreamReader reader = new InputStreamReader(url.openStream());
                props.load(reader);
                for (String key : props.stringPropertyNames()) {
                    String value = props.getProperty(key);
                    TitleRegistry.this.contributorTitlesByUsername.put(key, new Title(value, Rarity.EPIC));
                    TitleRegistry.this.contributorTitlesByTitleKey.put(value, new Title(value, Rarity.EPIC));
                }
            }
            catch (IOException e) {
                TitlesMod.LOG.warn("Unable to load contributors list. Most likely you're offline or github is down.");
            }
        }
    }
}

