/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.api.TitlesAPI;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="titles")
public class AdvancementHandler {
    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        Advancement advancement = event.getAdvancement();
        TitlesAPI.internal().unlockTitle(player, advancement.func_192067_g().toString());
    }

    @SubscribeEvent
    public static void onArrowHit(LivingDamageEvent event) {
        if (!event.getSource().field_76373_n.equals("arrow") || !(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        if (event.getEntityLiving().func_85035_bI() >= 7) {
            AdvancementHandler.grantCriterion((ServerPlayerEntity)event.getEntity(), "pincushion");
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Block block = Block.func_149634_a((Item)event.getTo().func_77973_b());
            EquipmentSlotType slot = event.getSlot();
            if (block == Blocks.field_196625_cS && slot == EquipmentSlotType.HEAD) {
                AdvancementHandler.grantCriterion(player, "melon_lord");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mounted = event.getEntityBeingMounted();
        Entity mounting = event.getEntityMounting();
        if (mounted instanceof BoatEntity && mounting instanceof PlayerEntity) {
            AdvancementHandler.grantCriterion((ServerPlayerEntity)mounting, "captain");
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        boolean beaconBaseAndOpulent;
        Block placedBlock = event.getPlacedBlock().func_177230_c();
        Set blockTags = placedBlock.getTags();
        ResourceLocation opulentTag = new ResourceLocation("titles", "opulent");
        ResourceLocation beaconBaseTag = new ResourceLocation("minecraft", "beacon_base_blocks");
        boolean bl = beaconBaseAndOpulent = blockTags.contains(opulentTag) && blockTags.contains(beaconBaseTag);
        if (placedBlock != Blocks.field_150461_bJ && !beaconBaseAndOpulent) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos beaconBlockPos = null;
        if (placedBlock == Blocks.field_150461_bJ) {
            beaconBlockPos = event.getPos();
        } else {
            BlockPos placedPos = event.getPos();
            block0: for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    for (int y = 0; y <= 4; ++y) {
                        BlockPos tempPos = placedPos.func_177982_a(x, y, z);
                        if (world.func_180495_p(tempPos).func_177230_c() != Blocks.field_150461_bJ) continue;
                        beaconBlockPos = tempPos;
                        break block0;
                    }
                }
            }
        }
        boolean onlyOpulentBlock = true;
        int levels = 0;
        if (beaconBlockPos != null) {
            int j;
            int i = 1;
            block3: while (i <= 4 && (j = beaconBlockPos.func_177956_o() - i) >= 0) {
                for (int k = beaconBlockPos.func_177958_n() - i; k <= beaconBlockPos.func_177958_n() + i; ++k) {
                    for (int l = beaconBlockPos.func_177952_p() - i; l <= beaconBlockPos.func_177952_p() + i; ++l) {
                        if (world.func_180495_p(new BlockPos(k, j, l)).func_177230_c() == placedBlock) continue;
                        onlyOpulentBlock = false;
                        break block3;
                    }
                }
                levels = i++;
            }
        }
        if (onlyOpulentBlock && levels == 4) {
            AdvancementHandler.grantCriterion(player, "opulent");
        }
    }

    private static void grantCriterion(ServerPlayerEntity player, String advancementId) {
        PlayerAdvancements advancements = player.func_192039_O();
        AdvancementManager manager = player.func_71121_q().func_73046_m().func_191949_aK();
        Advancement advancement = manager.func_192778_a(new ResourceLocation("titles", advancementId));
        if (advancement != null) {
            advancements.func_192750_a(advancement, "code_triggered");
        }
    }
}

