/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.api.Title;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.entity.merchant.villager.TitleForEmeraldsAndFragmentsTrade;
import aurilux.titles.common.impl.TitlesCapImpl;
import aurilux.titles.common.network.PacketHandler;
import aurilux.titles.common.network.messages.PacketSyncDataOnLogin;
import aurilux.titles.common.network.messages.PacketSyncSelectedTitle;
import aurilux.titles.common.util.CapabilityHelper;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="titles")
public class CommonEventHandler {
    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            CapabilityHelper.attach(event, TitlesCapImpl.NAME, TitlesAPI.TITLES_CAPABILITY, new TitlesCapImpl());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        TitlesAPI.getCapability(event.getOriginal()).ifPresent(oldCap -> {
            CompoundNBT bags = (CompoundNBT)oldCap.serializeNBT();
            TitlesAPI.getCapability(event.getPlayer()).ifPresent(newCap -> newCap.deserializeNBT((INBT)bags));
        });
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity playerLoggingIn = (ServerPlayerEntity)event.getPlayer();
        TitlesAPI.getCapability((PlayerEntity)playerLoggingIn).ifPresent(loggingInCap -> {
            HashMap<UUID, String> allSelectedTitles = new HashMap<UUID, String>();
            for (ServerPlayerEntity serverPlayer : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (serverPlayer.func_110124_au() == playerLoggingIn.func_110124_au()) continue;
                TitlesAPI.getCapability((PlayerEntity)serverPlayer).ifPresent(cap -> allSelectedTitles.put(serverPlayer.func_110124_au(), cap.getDisplayTitle().getKey()));
            }
            PacketHandler.sendTo(new PacketSyncDataOnLogin((CompoundNBT)loggingInCap.serializeNBT(), allSelectedTitles), playerLoggingIn);
            PacketHandler.sendToAll(new PacketSyncSelectedTitle(playerLoggingIn.func_110124_au(), loggingInCap.getDisplayTitle().getKey()));
        });
    }

    @SubscribeEvent
    public static void onPlayerNameFormat(PlayerEvent.NameFormat event) {
        PlayerEntity player = event.getPlayer();
        TitlesAPI.getCapability(player).ifPresent(cap -> {
            Title currentTitle = cap.getDisplayTitle();
            event.setDisplayname(TitlesAPI.getFormattedTitle(currentTitle, player));
        });
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals(VillagerProfession.field_221160_j)) {
            ((List)event.getTrades().get(1)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.COMMON, 3, 5));
            ((List)event.getTrades().get(3)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.UNCOMMON, 2, 10));
            ((List)event.getTrades().get(5)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.RARE, 1, 30));
        }
    }
}

