/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.impl;

import aurilux.titles.api.Title;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.api.capability.ITitles;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;

public class TitlesCapImpl
implements ITitles {
    public static final ResourceLocation NAME = new ResourceLocation("titles", "titles");
    private final String GENDER_SETTING = "gender_setting";
    private final String DISPLAY_TITLE = "display_title";
    private final String OBTAINED_TITLES = "obtained_titles";
    private final Set<Title> obtainedTitles = new HashSet<Title>();
    private Title displayTitle = Title.NULL_TITLE;
    private boolean genderSetting = true;

    @Override
    public boolean add(Title title) {
        return !title.isNull() && this.obtainedTitles.add(title);
    }

    @Override
    public void remove(Title title) {
        this.obtainedTitles.remove(title);
    }

    @Override
    public boolean hasTitle(Title title) {
        return this.obtainedTitles.contains(title);
    }

    @Override
    public Set<Title> getObtainedTitles() {
        return this.obtainedTitles;
    }

    @Override
    public void setDisplayTitle(Title newTitle) {
        this.displayTitle = newTitle;
    }

    @Override
    public Title getDisplayTitle() {
        return this.displayTitle;
    }

    @Override
    public boolean getGenderSetting() {
        return this.genderSetting;
    }

    @Override
    public void setGenderSetting(boolean newSetting) {
        this.genderSetting = newSetting;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        data.func_74757_a("gender_setting", this.genderSetting);
        data.func_74778_a("display_title", this.getDisplayTitle().getKey());
        ListNBT obtained = new ListNBT();
        for (Title title : this.obtainedTitles) {
            obtained.add((Object)StringNBT.func_229705_a_((String)title.getKey()));
        }
        data.func_218657_a("obtained_titles", (INBT)obtained);
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.genderSetting = nbt.func_74767_n("gender_setting");
        this.displayTitle = TitlesAPI.internal().getTitle(nbt.func_74779_i("display_title"));
        ListNBT obtained = (ListNBT)nbt.func_74781_a("obtained_titles");
        for (int i = 0; i < obtained.size(); ++i) {
            Title title = TitlesAPI.internal().getTitle(obtained.func_150307_f(i));
            this.add(title);
        }
    }
}

