/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.TitlesAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncDataOnLogin {
    private final CompoundNBT comp;
    private final Map<UUID, String> playerDisplayTitles;

    public PacketSyncDataOnLogin(CompoundNBT comp, Map<UUID, String> playerDisplayTitles) {
        this.comp = comp;
        this.playerDisplayTitles = playerDisplayTitles;
    }

    public static void encode(PacketSyncDataOnLogin msg, PacketBuffer buf) {
        buf.func_150786_a(msg.comp);
        buf.writeInt(msg.playerDisplayTitles.entrySet().size());
        for (Map.Entry<UUID, String> entry : msg.playerDisplayTitles.entrySet()) {
            buf.func_180714_a(entry.getKey().toString());
            buf.func_180714_a(entry.getValue());
        }
    }

    public static PacketSyncDataOnLogin decode(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(UUID.fromString(buf.func_218666_n()), buf.func_218666_n());
        }
        return new PacketSyncDataOnLogin(nbt, map);
    }

    public static void handle(PacketSyncDataOnLogin message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
            if (clientPlayer != null) {
                TitlesAPI.getCapability((PlayerEntity)clientPlayer).ifPresent(cap -> cap.deserializeNBT((INBT)message.comp));
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world != null) {
                    for (Map.Entry<UUID, String> entry : message.playerDisplayTitles.entrySet()) {
                        PlayerEntity player = world.func_217371_b(entry.getKey());
                        TitlesAPI.setDisplayTitle(player, entry.getValue());
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

