/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.network.PacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketSyncGenderSetting {
    private final boolean gender;
    private final UUID playerUUID;

    public PacketSyncGenderSetting(UUID uuid, boolean setting) {
        this.playerUUID = uuid;
        this.gender = setting;
    }

    public static void encode(PacketSyncGenderSetting msg, PacketBuffer buf) {
        buf.func_180714_a(msg.playerUUID.toString());
        buf.writeBoolean(msg.gender);
    }

    public static PacketSyncGenderSetting decode(PacketBuffer buf) {
        UUID uuid = UUID.fromString(buf.func_218666_n());
        boolean setting = buf.readBoolean();
        return new PacketSyncGenderSetting(uuid, setting);
    }

    public static void handle(PacketSyncGenderSetting message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player;
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                player = Minecraft.func_71410_x().field_71441_e.func_217371_b(message.playerUUID);
            } else {
                player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(message.playerUUID);
                PacketHandler.sendToAll(new PacketSyncGenderSetting(message.playerUUID, message.gender));
            }
            if (player != null) {
                TitlesAPI.getCapability(player).ifPresent(cap -> cap.setGenderSetting(message.gender));
                player.refreshDisplayName();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

