/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.network.PacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketSyncSelectedTitle {
    private final UUID playerUUID;
    private final String selectedTitle;

    public PacketSyncSelectedTitle(UUID uuid, String titleKey) {
        this.playerUUID = uuid;
        this.selectedTitle = titleKey;
    }

    public static void encode(PacketSyncSelectedTitle msg, PacketBuffer buf) {
        buf.func_180714_a(msg.playerUUID.toString());
        buf.func_180714_a(msg.selectedTitle);
    }

    public static PacketSyncSelectedTitle decode(PacketBuffer buf) {
        UUID uuid = UUID.fromString(buf.func_218666_n());
        String titleKey = buf.func_218666_n();
        return new PacketSyncSelectedTitle(uuid, titleKey);
    }

    public static void handle(PacketSyncSelectedTitle message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player;
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                player = Minecraft.func_71410_x().field_71441_e.func_217371_b(message.playerUUID);
            } else {
                player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(message.playerUUID);
                PacketHandler.sendToAll(new PacketSyncSelectedTitle(message.playerUUID, message.selectedTitle));
            }
            if (player != null) {
                TitlesAPI.setDisplayTitle(player, message.selectedTitle);
                player.refreshDisplayName();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

