/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.util;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class CapabilityHelper {
    public static <T> void registerDummyCapability(Class<T> type, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, new DummyStorage(), factory);
    }

    public static <T extends INBTSerializable<CompoundNBT>> void registerDeferredCapability(Class<T> type, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, new DeferredStorage(), factory);
    }

    public static <T extends INBTSerializable<CompoundNBT>> void attach(AttachCapabilitiesEvent<?> event, ResourceLocation key, Capability<T> cap, T capInstance) {
        SerializableProvider<T> provider = new SerializableProvider<T>(cap, capInstance);
        event.addCapability(key, provider);
        event.addListener(() -> ((LazyOptional)provider.capOptional).invalidate());
    }

    public static <T> void attach(AttachCapabilitiesEvent<?> event, ResourceLocation key, Capability<T> cap, T capInstance) {
        BasicProvider<T> provider = new BasicProvider<T>(cap, capInstance);
        event.addCapability(key, provider);
        event.addListener(() -> provider.capOptional.invalidate());
    }

    private static class SerializableProvider<T extends INBTSerializable<CompoundNBT>>
    extends BasicProvider<T>
    implements ICapabilitySerializable<CompoundNBT> {
        public SerializableProvider(Capability<T> capability, T capInstance) {
            super(capability, capInstance);
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)((INBTSerializable)this.capInstance).serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            ((INBTSerializable)this.capInstance).deserializeNBT((INBT)nbt);
        }
    }

    private static class BasicProvider<T>
    implements ICapabilityProvider {
        protected final T capInstance;
        protected final Capability<T> capability;
        protected final LazyOptional<T> capOptional;

        public BasicProvider(Capability<T> capability, T capInstance) {
            this.capability = capability;
            this.capInstance = capInstance;
            this.capOptional = LazyOptional.of(() -> this.capInstance);
        }

        @Nonnull
        public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
            return this.capability.orEmpty(cap, this.capOptional);
        }
    }

    private static class DeferredStorage<T extends INBTSerializable<CompoundNBT>>
    implements Capability.IStorage<T> {
        private DeferredStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }
    }

    private static class DummyStorage<T>
    implements Capability.IStorage<T> {
        private DummyStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
        }
    }
}

