/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api;

import java.util.Comparator;

public class TitleInfo {
    public static final TitleInfo NULL_TITLE = new TitleInfo("null", TitleRarity.COMMON);
    private String key;
    private String modid;
    private String langKey;
    private TitleRarity titleRarity;

    public TitleInfo() {
    }

    public TitleInfo(String key, TitleRarity titleRarity) {
        this.key = key;
        int colon = key.indexOf(":");
        if (colon == -1) {
            this.modid = "titles";
            this.langKey = key;
        } else {
            this.modid = key.substring(0, colon);
            this.langKey = "title." + key.replaceAll("[\\s]", "_").replaceAll("[\\W]", ".");
        }
        this.titleRarity = titleRarity;
    }

    public String getKey() {
        return this.key;
    }

    public String getModid() {
        return this.modid;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public TitleRarity getTitleRarity() {
        return this.titleRarity;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TitleInfo)) {
            return false;
        }
        TitleInfo temp = (TitleInfo)o;
        return this.key.equals(temp.key) && this.titleRarity.equals((Object)temp.titleRarity);
    }

    public String toString() {
        return "(" + this.key + ", " + this.titleRarity.toString() + ")";
    }

    public static class ModComparator
    implements Comparator<TitleInfo> {
        @Override
        public int compare(TitleInfo o1, TitleInfo o2) {
            return o1.modid.compareTo(o2.modid);
        }
    }

    public static class RarityComparator
    implements Comparator<TitleInfo> {
        @Override
        public int compare(TitleInfo o1, TitleInfo o2) {
            if (o1.titleRarity.ordinal() > o2.titleRarity.ordinal()) {
                return 1;
            }
            if (o1.titleRarity.ordinal() < o2.titleRarity.ordinal()) {
                return -1;
            }
            return 0;
        }
    }

    public static enum TitleRarity {
        COMMON,
        UNCOMMON,
        RARE,
        UNIQUE;

    }
}

