/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.gui;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.api.capability.TitlesImpl;
import aurilux.titles.client.gui.GuiTitleSelection;
import aurilux.titles.common.init.ModItems;
import aurilux.titles.common.network.PacketDispatcher;
import aurilux.titles.common.network.messages.PacketSyncFragmentCount;
import aurilux.titles.common.network.messages.PacketSyncUnlockedTitle;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTitleArchive
extends GuiTitleSelection {
    private final int PURCHASE_BUTTON = 15;
    private final int CLOSE_BUTTON = 16;
    private int totalFragCost = 0;

    public GuiTitleArchive(EntityPlayer player) {
        super(player);
        this.temporaryTitle = TitleInfo.NULL_TITLE;
        this.calculateTotalFragCost();
    }

    @Override
    public List<TitleInfo> getTitlesList() {
        ArrayList<TitleInfo> temp = new ArrayList<TitleInfo>(TitlesAPI.getArchiveTitles().values());
        temp.removeIf(t -> TitlesAPI.getTitlesCap(this.player).getObtainedTitles().contains(t));
        Collections.sort(temp, new TitleInfo.RarityComparator());
        return temp;
    }

    private void calculateTotalFragCost() {
        this.totalFragCost = 0;
        for (TitleInfo info : this.titlesList) {
            this.totalFragCost += this.getFragCost(info);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.field_146296_j.func_175042_a(new ItemStack(ModItems.archiveFragment), this.guiLeft + 16, this.guiTop + 31);
        String fragmentDisplay = "x " + TitlesAPI.getTitlesCap(this.player).getFragmentCount() + " [" + this.totalFragCost + "]";
        if (this.temporaryTitle != TitleInfo.NULL_TITLE) {
            fragmentDisplay = fragmentDisplay + ChatFormatting.RED + " -" + this.getFragCost(this.temporaryTitle);
        }
        this.field_146289_q.func_175063_a(fragmentDisplay, (float)(this.guiLeft + 30), (float)(this.guiTop + 35), 0xFFFFFF);
    }

    @Override
    protected String getEmptyMessage() {
        return "gui.titles.titlearchive.empty";
    }

    private void purchaseTitle() {
        TitlesImpl.DefaultImpl titlesImpl = TitlesAPI.getTitlesCap(this.player);
        if (titlesImpl.getFragmentCount() < this.getFragCost(this.temporaryTitle)) {
            return;
        }
        titlesImpl.addFragments(-this.getFragCost(this.temporaryTitle));
        TitlesAPI.addTitleToPlayer(this.player, this.temporaryTitle.getKey());
        PacketDispatcher.INSTANCE.sendToServer((IMessage)new PacketSyncUnlockedTitle(this.temporaryTitle.getKey()));
        PacketDispatcher.INSTANCE.sendToServer((IMessage)new PacketSyncFragmentCount(titlesImpl.getFragmentCount()));
        this.titlesList = this.getTitlesList();
        this.calculateTotalFragCost();
        this.temporaryTitle = TitleInfo.NULL_TITLE;
    }

    private int getFragCost(TitleInfo titleInfo) {
        switch (titleInfo.getTitleRarity().ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 15: {
                this.purchaseTitle();
                break;
            }
            case 16: {
                this.exitScreen(false);
                break;
            }
            case 17: {
                this.page = 0;
                break;
            }
            case 18: {
                --this.page;
                break;
            }
            case 19: {
                ++this.page;
                break;
            }
            case 20: {
                this.page = this.maxPages;
                break;
            }
            default: {
                this.temporaryTitle = (TitleInfo)this.titlesList.get(button.field_146127_k + this.page * 12);
            }
        }
        this.updateButtonList();
    }

    @Override
    protected void addChangeButtons() {
        this.field_146292_n.add(new GuiButton(16, this.leftOffset + 45, this.buttonSecondRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.close", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(15, this.leftOffset + 135, this.buttonSecondRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.purchase", (Object[])new Object[0])));
    }
}

