/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.api.TitlesAPI;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="titles")
public class AdvancementHandler {
    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Advancement advancement = event.getAdvancement();
        TitlesAPI.addTitleToPlayer(player, advancement.func_192067_g().toString(), true);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            Block block = Block.func_149634_a((Item)event.getTo().func_77973_b());
            EntityEquipmentSlot slot = event.getSlot();
            if (block == Blocks.field_150423_aK && slot == EntityEquipmentSlot.HEAD) {
                AdvancementHandler.grantCriterion(player, "melon_lord");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mounted = event.getEntityBeingMounted();
        Entity mounting = event.getEntityMounting();
        if (mounted instanceof EntityBoat && mounting instanceof EntityPlayerMP) {
            AdvancementHandler.grantCriterion((EntityPlayerMP)mounting, "captain");
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        BlockPos beaconBlockPos;
        World world;
        block11: {
            Block placedBlock = event.getPlacedBlock().func_177230_c();
            if (placedBlock != Blocks.field_150484_ah && placedBlock != Blocks.field_150461_bJ) {
                return;
            }
            world = event.getPlayer().field_70170_p;
            beaconBlockPos = null;
            if (placedBlock == Blocks.field_150484_ah) {
                BlockPos placedPos = event.getPos();
                for (int x = -4; x <= 4; ++x) {
                    for (int z = -4; z <= 4; ++z) {
                        for (int y = 0; y <= 4; ++y) {
                            BlockPos tempPos = placedPos.func_177982_a(x, y, z);
                            if (world.func_180495_p(tempPos).func_177230_c() != Blocks.field_150461_bJ) continue;
                            beaconBlockPos = tempPos;
                            break block11;
                        }
                    }
                }
            } else {
                beaconBlockPos = event.getPos();
            }
        }
        boolean onlyDiamondBlock = true;
        int levels = 0;
        if (beaconBlockPos != null) {
            int j;
            int i = 1;
            block3: while (i <= 4 && (j = beaconBlockPos.func_177956_o() - i) >= 0) {
                for (int k = beaconBlockPos.func_177958_n() - i; k <= beaconBlockPos.func_177958_n() + i; ++k) {
                    for (int l = beaconBlockPos.func_177952_p() - i; l <= beaconBlockPos.func_177952_p() + i; ++l) {
                        if (world.func_180495_p(new BlockPos(k, j, l)).func_177230_c() == Blocks.field_150484_ah) continue;
                        onlyDiamondBlock = false;
                        break block3;
                    }
                }
                levels = i++;
            }
        }
        if (onlyDiamondBlock && levels == 4) {
            AdvancementHandler.grantCriterion((EntityPlayerMP)event.getPlayer(), "opulent");
        }
    }

    private static void grantCriterion(EntityPlayerMP player, String advancementId) {
        PlayerAdvancements advancements = player.func_192039_O();
        AdvancementManager manager = player.func_71121_q().func_191952_z();
        Advancement advancement = manager.func_192778_a(new ResourceLocation("titles", advancementId));
        if (advancement != null) {
            advancements.func_192750_a(advancement, "code_triggered");
        }
    }
}

