/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.internal.IInternalMethodHandler;
import aurilux.titles.common.Titles;
import aurilux.titles.common.init.ContributorLoader;
import aurilux.titles.common.init.ModConfig;
import aurilux.titles.common.network.PacketDispatcher;
import aurilux.titles.common.network.messages.PacketSyncUnlockedTitle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InternalMethodHandler
implements IInternalMethodHandler {
    @Override
    public TitleInfo getTitleFromKey(String key) {
        return ContributorLoader.getTitleFromKey(key);
    }

    @Override
    public void syncUnlockedTitle(String key, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncUnlockedTitle(key), (EntityPlayerMP)player);
        }
    }

    @Override
    public void sendChatMessageToAllPlayers(String message, ITextComponent playerName, TitleInfo info) {
        Titles.proxy.sendChatMessageToAllPlayers(message, playerName, this.getFormattedTitle(info));
    }

    @Override
    public String getFormattedTitle(TitleInfo titleInfo) {
        return this.getFormattedTitle(titleInfo, false);
    }

    @Override
    public String getFormattedTitle(TitleInfo titleInfo, boolean addComma) {
        TextFormatting titleColor;
        if (titleInfo.equals(TitleInfo.NULL_TITLE)) {
            return "";
        }
        switch (titleInfo.getTitleRarity()) {
            case UNIQUE: {
                titleColor = ModConfig.uniqueColor.textFormatting;
                break;
            }
            case RARE: {
                titleColor = ModConfig.rareColor.textFormatting;
                break;
            }
            case UNCOMMON: {
                titleColor = ModConfig.uncommonColor.textFormatting;
                break;
            }
            default: {
                titleColor = ModConfig.commonColor.textFormatting;
            }
        }
        return (addComma ? ", " : "") + titleColor + new TextComponentTranslation(titleInfo.getLangKey(), new Object[0]).func_150254_d();
    }
}

