/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.network.PacketDispatcher;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncSelectedTitle
implements IMessage {
    private UUID playerUUID;
    private String selectedTitle;

    public PacketSyncSelectedTitle() {
    }

    public PacketSyncSelectedTitle(UUID playerUUID, String titleKey) {
        this.playerUUID = playerUUID;
        this.selectedTitle = titleKey;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.selectedTitle = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.selectedTitle);
    }

    public static class HandlerServer
    implements IMessageHandler<PacketSyncSelectedTitle, IMessage> {
        public IMessage onMessage(final PacketSyncSelectedTitle message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.field_71133_b.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(message.playerUUID);
                    TitlesAPI.setPlayerSelectedTitle((EntityPlayer)player, TitlesAPI.getTitleFromKey(message.selectedTitle));
                    player.refreshDisplayName();
                    PacketDispatcher.INSTANCE.sendToAll((IMessage)new PacketSyncSelectedTitle(message.playerUUID, message.selectedTitle));
                }
            });
            return null;
        }
    }

    public static class HandlerClient
    implements IMessageHandler<PacketSyncSelectedTitle, IMessage> {
        public IMessage onMessage(final PacketSyncSelectedTitle message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = FMLClientHandler.instance().getWorldClient().func_152378_a(message.playerUUID);
                    if (player != null) {
                        TitlesAPI.setPlayerSelectedTitle(player, TitlesAPI.getTitleFromKey(message.selectedTitle));
                        player.refreshDisplayName();
                    }
                }
            });
            return null;
        }
    }
}

