/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.TitlesAPI;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncTitleDataOnLogin
implements IMessage {
    private final Map<UUID, String> playerSelectedTitles = new HashMap<UUID, String>();
    private NBTTagCompound comp;

    public PacketSyncTitleDataOnLogin() {
    }

    public PacketSyncTitleDataOnLogin(EntityPlayer player) {
        this.comp = TitlesAPI.getTitlesCap(player).serializeNBT();
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        for (EntityPlayerMP temp : playerList.func_181057_v()) {
            if (temp.func_110124_au() == player.func_110124_au()) continue;
            this.playerSelectedTitles.put(temp.func_110124_au(), TitlesAPI.getPlayerSelectedTitle((EntityPlayer)temp).getKey());
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.comp);
        buf.writeInt(this.playerSelectedTitles.entrySet().size());
        for (Map.Entry<UUID, String> entry : this.playerSelectedTitles.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey().toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.comp = ByteBufUtils.readTag((ByteBuf)buf);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.playerSelectedTitles.put(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncTitleDataOnLogin, IMessage> {
        public IMessage onMessage(final PacketSyncTitleDataOnLogin message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TitlesAPI.getTitlesCap((EntityPlayer)Minecraft.func_71410_x().field_71439_g).deserializeNBT(message.comp);
                    WorldClient world = FMLClientHandler.instance().getWorldClient();
                    for (Map.Entry entry : message.playerSelectedTitles.entrySet()) {
                        EntityPlayer player = world.func_152378_a((UUID)entry.getKey());
                        TitlesAPI.setPlayerSelectedTitle(player, TitlesAPI.getTitleFromKey((String)entry.getValue()));
                    }
                }
            });
            return null;
        }
    }
}

