/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.loaders.tileentity;

import com.teamacronymcoders.base.capability.energy.EnergyStorageDirectional;
import com.teamacronymcoders.base.capability.energy.EnergyStorageSerializable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import xyz.brassgoggledcoders.transport.library.tileentity.loader.TileEntityLoaderBase;

public class TileEntityFELoader
extends TileEntityLoaderBase<IEnergyStorage> {
    private final EnergyStorageSerializable energyStorage = new EnergyStorageSerializable(100000, 10000, 10000);
    private final EnergyStorageDirectional input = new EnergyStorageDirectional((IEnergyStorage)this.energyStorage, true);
    private final EnergyStorageDirectional output = new EnergyStorageDirectional((IEnergyStorage)this.energyStorage, false);

    protected void readCapability(NBTTagCompound data) {
        this.energyStorage.deserializeNBT(data.func_74775_l("energy"));
    }

    protected void writeCapability(NBTTagCompound data) {
        data.func_74782_a("energy", (NBTBase)this.energyStorage.serializeNBT());
    }

    public Capability<IEnergyStorage> getCapabilityType() {
        return CapabilityEnergy.ENERGY;
    }

    public IEnergyStorage getInternalCapability() {
        return this.energyStorage;
    }

    public IEnergyStorage getOutputCapability() {
        return this.output;
    }

    public IEnergyStorage getInputCapability() {
        return this.input;
    }

    @Override
    protected boolean transfer(IEnergyStorage from, IEnergyStorage to) {
        int amountSimPushed;
        int amountSimPulled = from.extractEnergy(10000, true);
        if (amountSimPulled > 0 && (amountSimPushed = to.receiveEnergy(amountSimPulled, true)) > 0) {
            return to.receiveEnergy(from.extractEnergy(amountSimPushed, false), false) > 0;
        }
        return false;
    }
}

